/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400CertificateVldlUtilImpl;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;

class AS400CertificateVldlUtilImplRemote
extends AS400CertificateVldlUtilImpl {
    AS400CertificateVldlUtilImplRemote() {
    }

    int calladdCertificate(byte[] cert, int certlen, String ifsPathName, int pathlen) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[7];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(101, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(cert);
        byte[] certlenB = new byte[4];
        BinaryConverter.intToByteArray(certlen, certlenB, 0);
        parmlist[2] = new ProgramParameter(certlenB);
        byte[] vldlPathB = new byte[pathlen];
        this.converter_.stringToByteArray(ifsPathName, vldlPathB);
        parmlist[3] = new ProgramParameter(vldlPathB);
        byte[] pathlenB = new byte[4];
        BinaryConverter.intToByteArray(pathlen, pathlenB, 0);
        parmlist[4] = new ProgramParameter(pathlenB);
        parmlist[5] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[6] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[6].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[5].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        return 0;
    }

    int calldeleteCertificate(byte[] cert, int certlen, String ifsPathName, int pathlen, int certType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[8];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(102, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(cert);
        byte[] certlenB = new byte[4];
        BinaryConverter.intToByteArray(certlen, certlenB, 0);
        parmlist[2] = new ProgramParameter(certlenB);
        byte[] vldlPathB = new byte[pathlen];
        this.converter_.stringToByteArray(ifsPathName, vldlPathB);
        parmlist[3] = new ProgramParameter(vldlPathB);
        byte[] pathlenB = new byte[4];
        BinaryConverter.intToByteArray(pathlen, pathlenB, 0);
        parmlist[4] = new ProgramParameter(pathlenB);
        byte[] certTypeB = new byte[4];
        BinaryConverter.intToByteArray(certType, certTypeB, 0);
        parmlist[5] = new ProgramParameter(certTypeB);
        parmlist[6] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[7] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[7].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[6].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        return 0;
    }

    int calllistCertificates(String ifsPathName, int pathlen, String usrSpaceName, boolean[] parmEntered, String[] attrS, byte[][] attrB) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int i;
        ProgramParameter[] parmlist = new ProgramParameter[10];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(103, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        byte[] vldlPathB = new byte[pathlen];
        this.converter_.stringToByteArray(ifsPathName, vldlPathB);
        parmlist[1] = new ProgramParameter(vldlPathB);
        byte[] vldlLengthB = new byte[4];
        BinaryConverter.intToByteArray(pathlen, vldlLengthB, 0);
        parmlist[2] = new ProgramParameter(vldlLengthB);
        byte[] usrSpaceNameB = new byte[20];
        this.converter_.stringToByteArray(usrSpaceName, usrSpaceNameB);
        parmlist[3] = new ProgramParameter(usrSpaceNameB);
        byte[] parmPresent = new byte[28];
        for (i = 0; i < 7; ++i) {
            if (parmEntered[i]) {
                BinaryConverter.intToByteArray(1, parmPresent, i * 4);
                continue;
            }
            BinaryConverter.intToByteArray(0, parmPresent, i * 4);
        }
        parmlist[4] = new ProgramParameter(parmPresent);
        int length = 0;
        int[] parmsize = new int[7];
        for (i = 0; i < attrS.length; ++i) {
            if (attrS[i] == null) continue;
            length += attrS[i].length();
        }
        for (int j = 0; j < attrB.length; ++j) {
            if (attrB[j] != null) {
                length += attrB[j].length;
                parmsize[i] = attrB[j].length;
            }
            ++i;
        }
        byte[] attrbytes = new byte[length * 2];
        byte[][] attrSbytes = new byte[attrS.length][];
        for (i = 0; i < attrS.length; ++i) {
            if (attrS[i] == null || 0 == attrS[i].length()) continue;
            attrSbytes[i] = this.converter_.stringToByteArray(attrS[i]);
            parmsize[i] = attrSbytes[i].length;
        }
        length = 0;
        byte[] parmsizeBytes = new byte[28];
        for (i = 0; i < attrS.length; ++i) {
            if (null != attrSbytes[i]) {
                System.arraycopy(attrSbytes[i], 0, attrbytes, length, attrSbytes[i].length);
                length += attrSbytes[i].length;
            }
            BinaryConverter.intToByteArray(parmsize[i], parmsizeBytes, i * 4);
        }
        for (i = 0; i < attrB.length; ++i) {
            if (null != attrB[i]) {
                System.arraycopy(attrB[i], 0, attrbytes, length, attrB[i].length);
                length += attrB[i].length;
            }
            BinaryConverter.intToByteArray(parmsize[6 + i], parmsizeBytes, (6 + i) * 4);
        }
        parmlist[5] = new ProgramParameter(parmsizeBytes);
        parmlist[6] = new ProgramParameter(attrbytes);
        parmlist[7] = new ProgramParameter(4);
        parmlist[8] = new ProgramParameter(100);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[9] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            this.numberCertificatesFound_ = 0;
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[9].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            this.numberCertificatesFound_ = 0;
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[8].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        byte[] numberCertificatesFoundB = parmlist[7].getOutputData();
        this.numberCertificatesFound_ = BinaryConverter.byteArrayToInt(numberCertificatesFoundB, 0);
        return rc;
    }

    int callcheckCertificate(byte[] cert, int certlen, String ifsPathName, int pathlen, int certType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmlist = new ProgramParameter[9];
        byte[] pgmEntry = new byte[4];
        BinaryConverter.intToByteArray(104, pgmEntry, 0);
        parmlist[0] = new ProgramParameter(pgmEntry);
        parmlist[1] = new ProgramParameter(cert);
        byte[] certlenB = new byte[4];
        BinaryConverter.intToByteArray(certlen, certlenB, 0);
        parmlist[2] = new ProgramParameter(certlenB);
        byte[] vldlPathB = new byte[pathlen];
        this.converter_.stringToByteArray(ifsPathName, vldlPathB);
        parmlist[3] = new ProgramParameter(vldlPathB);
        byte[] pathlenB = new byte[4];
        BinaryConverter.intToByteArray(pathlen, pathlenB, 0);
        parmlist[4] = new ProgramParameter(pathlenB);
        byte[] certTypeB = new byte[4];
        BinaryConverter.intToByteArray(certType, certTypeB, 0);
        parmlist[5] = new ProgramParameter(certTypeB);
        parmlist[6] = new ProgramParameter(4);
        parmlist[7] = new ProgramParameter(7);
        byte[] retcodeB = new byte[4];
        BinaryConverter.intToByteArray(-1, retcodeB, 0);
        parmlist[8] = new ProgramParameter(retcodeB, 4);
        ProgramCall pgmCall = new ProgramCall(this.system_);
        try {
            pgmCall.setProgram("/QSYS.LIB/QYJSPCTU.PGM", parmlist);
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
        pgmCall.suggestThreadsafe();
        if (!pgmCall.run()) {
            AS400Message[] messagelist = pgmCall.getMessageList();
            this.cpfError_ = messagelist[0].toString();
            return -1;
        }
        retcodeB = parmlist[8].getOutputData();
        int rc = BinaryConverter.byteArrayToInt(retcodeB, 0);
        if (0 != rc) {
            if (-1 == rc) {
                return rc;
            }
            byte[] errorInfoB = parmlist[7].getOutputData();
            this.cpfError_ = this.converter_.byteArrayToString(errorInfoB, 0).trim();
            return rc;
        }
        byte[] presentB = parmlist[6].getOutputData();
        this.present_ = BinaryConverter.byteArrayToInt(presentB, 0);
        return 0;
    }
}

