/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400AbstractTime;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;

public class AS400Date
extends AS400AbstractTime {
    private static final long serialVersionUID = -2802488573427538664L;
    private java.sql.Date defaultValue_;
    private static Hashtable formatsMap_;
    public static final int FORMAT_MDY = 0;
    public static final int FORMAT_DMY = 1;
    public static final int FORMAT_YMD = 2;
    public static final int FORMAT_JUL = 3;
    public static final int FORMAT_ISO = 4;
    public static final int FORMAT_USA = 5;
    public static final int FORMAT_EUR = 6;
    public static final int FORMAT_JIS = 7;
    public static final int FORMAT_CYMD = 8;
    public static final int FORMAT_CMDY = 9;
    public static final int FORMAT_CDMY = 10;
    public static final int FORMAT_LONGJUL = 11;
    public static final int FORMAT_MY = 12;
    public static final int FORMAT_YM = 13;
    public static final int FORMAT_MYY = 14;
    public static final int FORMAT_YYM = 15;
    private static final int FORMAT_RANGE_MINIMUM = 0;
    private static final int FORMAT_RANGE_MAXIMUM = 15;

    public AS400Date() {
        this(4);
    }

    public AS400Date(TimeZone timeZone) {
        this(timeZone, 4);
    }

    public AS400Date(int format) {
        this.setFormat(format, this.defaultSeparatorFor(format));
    }

    public AS400Date(TimeZone timeZone, int format) {
        super(timeZone);
        this.setFormat(format, this.defaultSeparatorFor(format));
    }

    public AS400Date(int format, Character separator) {
        this();
        this.setFormat(format, separator);
    }

    public AS400Date(TimeZone timeZone, int format, Character separator) {
        this(timeZone);
        this.setFormat(format, separator);
    }

    public Object getDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = new java.sql.Date(0L);
        }
        return this.defaultValue_;
    }

    public int getFormat() {
        return super.getFormat();
    }

    public Character getSeparator() {
        return super.getSeparator();
    }

    public int getInstanceType() {
        return 17;
    }

    public Class getJavaType() {
        return java.sql.Date.class;
    }

    public void setFormat(int format) {
        super.setFormat(format, this.defaultSeparatorFor(format));
    }

    void setFormat(String format) {
        super.setFormat(AS400Date.toFormat(format));
    }

    void setSeparator(Character separator) {
        super.setSeparator(separator);
    }

    public void setFormat(int format, Character separator) {
        super.setFormat(format, separator);
    }

    public void setFormat(int format, char separator) {
        super.setFormat(format, new Character(separator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Hashtable getFormatsMap() {
        if (formatsMap_ != null) return formatsMap_;
        Class<AS400Date> clazz = AS400Date.class;
        synchronized (AS400Date.class) {
            if (formatsMap_ != null) return formatsMap_;
            formatsMap_ = new Hashtable(12);
            formatsMap_.put("MDY", new Integer(0));
            formatsMap_.put("DMY", new Integer(1));
            formatsMap_.put("YMD", new Integer(2));
            formatsMap_.put("JUL", new Integer(3));
            formatsMap_.put("ISO", new Integer(4));
            formatsMap_.put("USA", new Integer(5));
            formatsMap_.put("EUR", new Integer(6));
            formatsMap_.put("JIS", new Integer(7));
            formatsMap_.put("CYMD", new Integer(8));
            formatsMap_.put("CMDY", new Integer(9));
            formatsMap_.put("CDMY", new Integer(10));
            formatsMap_.put("LONGJUL", new Integer(11));
            formatsMap_.put("MY", new Integer(12));
            formatsMap_.put("YM", new Integer(13));
            formatsMap_.put("MYY", new Integer(14));
            formatsMap_.put("YYM", new Integer(15));
            // ** MonitorExit[var0] (shouldn't be in output)
            return formatsMap_;
        }
    }

    public static int toFormat(String formatName) {
        if (formatName == null || formatName.length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "AS400Date.toFormat(" + formatName + "): Returning default date format.");
            }
            return 4;
        }
        Integer formatInt = (Integer)AS400Date.getFormatsMap().get(formatName.trim().toUpperCase());
        if (formatInt == null) {
            throw new ExtendedIllegalArgumentException("format (" + formatName + ")", 2);
        }
        return formatInt;
    }

    static boolean isYearWithinRange(int year, int format) {
        switch (format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: {
                return year >= 1940 && year <= 2039;
            }
            case 8: 
            case 9: 
            case 10: {
                return year >= 1900 && year <= 2899;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                return year >= 1 && year <= 9999;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + format, null);
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        return super.toBytes(javaValue, as400Value, offset);
    }

    public Object toObject(byte[] as400Value, int offset) {
        if (as400Value == null) {
            throw new NullPointerException("as400Value");
        }
        String dateString = this.getCharConverter().byteArrayToString(as400Value, offset, this.getLength());
        return this.parse(dateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object javaValue) {
        int era;
        int year;
        java.sql.Date dateObj;
        if (javaValue == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            dateObj = (java.sql.Date)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "javaValue is of type " + javaValue.getClass().getName());
            throw e;
        }
        AS400Date aS400Date = this;
        synchronized (aS400Date) {
            GregorianCalendar cal = this.getCalendar(dateObj);
            year = cal.get(1);
            era = cal.get(0);
        }
        if (era == 0) {
            throw new ExtendedIllegalArgumentException("javaValue (era=0)", 4);
        }
        if (!AS400Date.isYearWithinRange(year, this.getFormat())) {
            Trace.log(2, "Year " + year + " is outside the range of values for AS400Date format " + this.getFormat());
            throw new ExtendedIllegalArgumentException("javaValue (year=" + year + ")", 4);
        }
        String dateString = this.getDateFormatter().format(dateObj);
        dateString = this.addCenturyDigit(dateString, dateObj);
        return dateString;
    }

    public java.sql.Date parse(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            Integer centuryDigit = AS400Date.parseCenturyDigit(source, this.getFormat());
            if (centuryDigit != null) {
                source = source.substring(1);
            } else {
                centuryDigit = this.disambiguateCentury(source);
            }
            SimpleDateFormat dateFormatter = this.getDateFormatter(centuryDigit);
            Date dateObj = dateFormatter.parse(source);
            return new java.sql.Date(dateObj.getTime());
        }
        catch (Exception e) {
            Trace.log(2, e.getMessage(), source);
            Trace.log(2, "Date string is expected to be in format: " + this.prependCentury(this.patternFor(this.getFormat(), this.getSeparator())));
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2);
        }
    }

    public static java.sql.Date parseXsdString(String source) {
        return AS400Date.parseXsdString(source, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static java.sql.Date parseXsdString(String source, TimeZone timeZone) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            Date simpleDateObj = AS400Date.getDateFormatterXSD(timeZone).parse(source);
            return new java.sql.Date(simpleDateObj.getTime());
        }
        catch (ParseException e) {
            Trace.log(2, e.getMessage(), source);
            Trace.log(2, "Value is expected to be in standard XML Schema 'date' format: yyyy-MM-dd");
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2);
        }
    }

    public static String toXsdString(Object javaValue) {
        return AS400Date.toXsdString(javaValue, TIMEZONE_GMT);
    }

    public static String toXsdString(Object javaValue, TimeZone timeZone) {
        java.sql.Date dateObj;
        if (javaValue == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            dateObj = (java.sql.Date)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "javaValue is of type " + javaValue.getClass().getName());
            throw e;
        }
        return AS400Date.getDateFormatterXSD(timeZone).format(dateObj);
    }

    private String prependCentury(String pattern) {
        switch (this.getFormat()) {
            case 8: 
            case 9: 
            case 10: {
                return "C" + pattern;
            }
        }
        return pattern;
    }

    private String addCenturyDigit(String dateString, java.sql.Date dateObj) {
        switch (this.getFormat()) {
            case 8: 
            case 9: 
            case 10: {
                int year = this.getCalendar(dateObj).get(1);
                int century = year / 100 - 19;
                return Integer.toString(century) + dateString;
            }
        }
        return dateString;
    }

    private Integer disambiguateCentury(String dateString) {
        int offsetToYear;
        switch (this.getFormat()) {
            case 2: 
            case 3: 
            case 13: {
                offsetToYear = 0;
                break;
            }
            case 12: {
                if (this.getSeparator() == null) {
                    offsetToYear = 2;
                    break;
                }
                offsetToYear = 3;
                break;
            }
            case 0: 
            case 1: {
                if (this.getSeparator() == null) {
                    offsetToYear = 4;
                    break;
                }
                offsetToYear = 6;
                break;
            }
            default: {
                return null;
            }
        }
        int year = Integer.parseInt(dateString.substring(offsetToYear, offsetToYear + 2));
        int century = year == 0 ? 0 : (year < 40 ? 1 : 0);
        return new Integer(century);
    }

    static Integer parseCenturyDigit(String dateString, int format) {
        switch (format) {
            case 8: 
            case 9: 
            case 10: {
                return Integer.valueOf(Character.toString(dateString.charAt(0)));
            }
        }
        return null;
    }

    String patternFor(int format, Character separator) {
        String sep = separator == null ? "" : separator.toString();
        switch (format) {
            case 12: {
                return "MM" + sep + "yy";
            }
            case 13: {
                return "yy" + sep + "MM";
            }
            case 14: {
                return "MM" + sep + "yyyy";
            }
            case 15: {
                return "yyyy" + sep + "MM";
            }
            case 0: {
                return "MM" + sep + "dd" + sep + "yy";
            }
            case 1: {
                return "dd" + sep + "MM" + sep + "yy";
            }
            case 2: {
                return "yy" + sep + "MM" + sep + "dd";
            }
            case 3: {
                return "yy" + sep + "DDD";
            }
            case 4: 
            case 7: {
                return "yyyy" + sep + "MM" + sep + "dd";
            }
            case 5: {
                return "MM" + sep + "dd" + sep + "yyyy";
            }
            case 6: {
                return "dd" + sep + "MM" + sep + "yyyy";
            }
            case 8: {
                return "yy" + sep + "MM" + sep + "dd";
            }
            case 9: {
                return "MM" + sep + "dd" + sep + "yy";
            }
            case 10: {
                return "dd" + sep + "MM" + sep + "yy";
            }
            case 11: {
                return "yyyy" + sep + "DDD";
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + format, null);
    }

    Character defaultSeparatorFor(int format) {
        if (!this.isValidFormat(format)) {
            throw new ExtendedIllegalArgumentException("format (" + format + ")", 2);
        }
        switch (format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return SLASH;
            }
            case 4: 
            case 7: {
                return HYPHEN;
            }
            case 6: {
                return PERIOD;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + format, null);
    }

    boolean isValidFormat(int format) {
        return AS400Date.validateFormat(format);
    }

    public static boolean validateFormat(int format) {
        return format >= 0 && format <= 15;
    }

    public static int getByteLength(int format, Character separator) {
        if (separator == null) {
            switch (format) {
                case 12: 
                case 13: {
                    return 4;
                }
                case 0: 
                case 1: 
                case 2: 
                case 14: 
                case 15: {
                    return 6;
                }
                case 11: {
                    return 7;
                }
                case 3: {
                    return 5;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return 8;
                }
                case 8: 
                case 9: 
                case 10: {
                    return 7;
                }
            }
            throw new InternalErrorException(6, "Unrecognized format: " + format, null);
        }
        switch (format) {
            case 12: 
            case 13: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 14: 
            case 15: {
                return 7;
            }
            case 0: 
            case 1: 
            case 2: 
            case 11: {
                return 8;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 10;
            }
            case 8: 
            case 9: 
            case 10: {
                return 9;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + format, null);
    }

    int lengthFor(int format) {
        return AS400Date.getByteLength(format, this.getSeparator());
    }
}

