/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImpl;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileEvent;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class AS400File
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400File";
    static final long serialVersionUID = 4L;
    protected boolean longRecordNumber = false;
    public static final String BLANK = "*BLANK";
    public static final int COMMIT_LOCK_LEVEL_ALL = 0;
    public static final int COMMIT_LOCK_LEVEL_CHANGE = 1;
    public static final int COMMIT_LOCK_LEVEL_CURSOR_STABILITY = 2;
    public static final int COMMIT_LOCK_LEVEL_DEFAULT = 4;
    public static final int COMMIT_LOCK_LEVEL_NONE = 3;
    public static final int READ_ALLOW_SHARED_READ_LOCK = 1;
    public static final int READ_ALLOW_SHARED_WRITE_LOCK = 0;
    public static final int READ_EXCLUSIVE_LOCK = 4;
    public static final int READ_ONLY = 0;
    public static final int READ_WRITE = 1;
    public static final String SOURCE_MEMBER_TEXT = "*SRCMBRTXT";
    public static final String TYPE_DATA = "*DATA";
    public static final String TYPE_SOURCE = "*SRC";
    public static final int WRITE_ALLOW_SHARED_READ_LOCK = 3;
    public static final int WRITE_ALLOW_SHARED_WRITE_LOCK = 2;
    public static final int WRITE_EXCLUSIVE_LOCK = 5;
    public static final int WRITE_ONLY = 2;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;
    transient Vector fileListeners_;
    transient boolean isOpen_;
    boolean readNoUpdate_ = false;
    boolean ssp_ = false;
    String library_ = "";
    String file_ = "";
    String member_ = "";
    String name_ = "";
    RecordFormat recordFormat_;
    AS400 system_;
    transient AS400FileImpl impl_;

    public AS400File() {
        this.initializeTransient();
    }

    public AS400File(AS400 system, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.setName(name);
        this.system_ = system;
    }

    public void addFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.addElement(listener);
    }

    public void addPhysicalFileMember(String name, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() > 10) {
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 1);
        }
        if (textDescription != null && textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription (" + textDescription + ")", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("addPhysicalFileMember", new Class[]{String.class, String.class}, new Object[]{name, textDescription});
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    void checkOpen() {
        if (!this.isOpen_) {
            throw new ExtendedIllegalStateException(3);
        }
    }

    synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.name_ == null || this.name_.length() == 0) {
                throw new ExtendedIllegalStateException("name", 4);
            }
            this.impl_ = (AS400FileImpl)this.system_.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
            this.system_.signon(false);
            this.impl_.doItNoExceptions("setAll", new Class[]{AS400Impl.class, String.class, RecordFormat.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{this.system_.getImpl(), this.name_, this.recordFormat_, new Boolean(this.readNoUpdate_), new Boolean(this instanceof KeyedFile), new Boolean(this.ssp_)});
        }
    }

    public synchronized void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isOpen_) {
            try {
                try {
                    this.releaseExplicitLocks();
                }
                catch (AS400SecurityException e) {
                    // empty catch block
                }
                this.doIt("close");
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                // empty catch block
            }
            this.isOpen_ = false;
            this.fireEvent(0);
        }
    }

    private void doIt(String x) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.impl_.doIt(x, new Class[0], new Object[0]);
    }

    public void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted()) {
            this.doIt("commit");
        }
    }

    public static void commit(AS400 system) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        system.signon(false);
        AS400FileImpl impl = (AS400FileImpl)system.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        impl.doIt("commit", new Class[]{AS400Impl.class}, new Object[]{system.getImpl()});
    }

    public void create(int recordLength, String fileType, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (recordLength < 1 || recordLength > 32766) {
            throw new ExtendedIllegalArgumentException("recordLength (" + String.valueOf(recordLength) + ")", 4);
        }
        if (fileType == null) {
            throw new NullPointerException("fileType");
        }
        if (!fileType.equalsIgnoreCase(TYPE_DATA) && !fileType.equalsIgnoreCase(TYPE_SOURCE)) {
            throw new ExtendedIllegalArgumentException("fileType", 2);
        }
        if (textDescription != null && textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("create", new Class[]{Integer.TYPE, String.class, String.class}, new Object[]{new Integer(recordLength), fileType, textDescription});
        RecordFormat old = this.recordFormat_;
        this.recordFormat_ = new RecordFormat(this.file_);
        if (fileType.equalsIgnoreCase(TYPE_DATA)) {
            this.recordFormat_.addFieldDescription(new CharacterFieldDescription(new AS400Text(recordLength, this.system_.getCcsid(), this.system_), this.file_));
        } else {
            this.recordFormat_.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 2), "SRCSEQ"));
            this.recordFormat_.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 0), "SRCDAT"));
            this.recordFormat_.addFieldDescription(new CharacterFieldDescription(new AS400Text(recordLength - 12, this.system_.getCcsid(), this.system_), "SRCDTA"));
        }
        this.impl_.doIt("setRecordFormat", new Class[]{RecordFormat.class}, new Object[]{this.recordFormat_});
        this.fireEvent(4);
        this.changes_.firePropertyChange("recordFormat", old, this.recordFormat_);
    }

    public void create(String ddsSourceFile, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (ddsSourceFile == null) {
            throw new NullPointerException("ddsSourceFile");
        }
        if (textDescription != null && textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("create", new Class[]{String.class, String.class}, new Object[]{ddsSourceFile, textDescription});
        this.fireEvent(4);
    }

    public void create(RecordFormat recordFormat, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.create(recordFormat, textDescription, null, null, null, null, false, null, null);
    }

    public void create(RecordFormat recordFormat, String textDescription, String altSeq, String ccsid, String order, String ref, boolean unique, String format, String text) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        if (textDescription != null && textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription (" + textDescription + ")", 1);
        }
        this.chooseImpl();
        this.impl_.doIt("createDDSSourceFile", new Class[]{RecordFormat.class, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class}, new Object[]{recordFormat, altSeq, ccsid, order, ref, new Boolean(unique), format, text});
        this.create("/QSYS.LIB/QTEMP.LIB/JT400DSSRC.FILE/JT400DSSRC.MBR", textDescription);
        RecordFormat old = this.recordFormat_;
        this.recordFormat_ = recordFormat;
        this.impl_.doIt("setRecordFormat", new Class[]{RecordFormat.class}, new Object[]{this.recordFormat_});
        this.fireEvent(4);
        this.changes_.firePropertyChange("recordFormat", old, this.recordFormat_);
    }

    public void delete() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        this.chooseImpl();
        this.doIt("delete");
        this.fireEvent(1);
    }

    public void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("deleteCurrentRecord");
        this.fireEvent(2);
    }

    public void deleteMember() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        this.chooseImpl();
        this.doIt("deleteMember");
    }

    public void endCommitmentControl() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.chooseImpl();
        this.doIt("endCommitmentControl");
    }

    public static void endCommitmentControl(AS400 system) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        system.signon(false);
        AS400FileImpl impl = (AS400FileImpl)system.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        impl.doIt("endCommitmentControl", new Class[]{AS400Impl.class}, new Object[]{system.getImpl()});
    }

    Record fillInRecord(Record r) {
        if (r != null) {
            r.initializeTextObjects(this.system_);
        }
        return r;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen_) {
            this.doIt("discardReplies");
            this.close();
        }
        super.finalize();
    }

    private void fireEvent(int eIndex) {
        Vector targets = (Vector)this.fileListeners_.clone();
        FileEvent event = new FileEvent(this, eIndex);
        block7: for (int i = 0; i < targets.size(); ++i) {
            FileListener target = (FileListener)targets.elementAt(i);
            switch (eIndex) {
                case 0: {
                    target.fileClosed(event);
                    continue block7;
                }
                case 4: {
                    target.fileCreated(event);
                    continue block7;
                }
                case 1: {
                    target.fileDeleted(event);
                    continue block7;
                }
                case 2: {
                    target.fileModified(event);
                    continue block7;
                }
                case 3: {
                    target.fileOpened(event);
                }
            }
        }
    }

    public int getBlockingFactor() {
        if (!this.isOpen_) {
            return 0;
        }
        return this.impl_.doItInt("getBlockingFactor");
    }

    public int getCommitLockLevel() {
        if (this.impl_ == null) {
            return -1;
        }
        return this.impl_.doItInt("getCommitLockLevel");
    }

    public int[] getExplicitLocks() {
        if (this.impl_ == null) {
            return new int[0];
        }
        return this.impl_.getExplicitLocks();
    }

    public String getFileName() {
        return this.file_;
    }

    public String getLibraryName() {
        return this.library_;
    }

    public String getMemberName() {
        return this.member_;
    }

    public String getPath() {
        return this.name_;
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    void initializeTransient() {
        this.isOpen_ = false;
        this.fileListeners_ = new Vector();
        this.vetos_ = new VetoableChangeSupport(this);
        this.changes_ = new PropertyChangeSupport(this);
        this.impl_ = null;
    }

    public boolean isCommitmentControlStarted() {
        try {
            this.chooseImpl();
        }
        catch (ExtendedIllegalStateException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring illegal state on isCommitmentControlStarted().", (Throwable)e);
            }
            return false;
        }
        catch (AS400SecurityException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring security exception on isCommitmentControlStarted().", (Throwable)e);
            }
            return false;
        }
        catch (IOException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring I/O exception on isCommitmentControlStarted().", (Throwable)e);
            }
            return false;
        }
        return this.impl_.doItBoolean("isCommitmentControlStarted");
    }

    public static boolean isCommitmentControlStarted(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        try {
            system.signon(false);
            AS400FileImpl impl = (AS400FileImpl)system.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
            return impl.doItBoolean("isCommitmentControlStarted", new Class[]{AS400Impl.class}, new Object[]{system.getImpl()});
        }
        catch (IOException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring I/O exception on isCommitmentControlStarted(AS400).", (Throwable)e);
            }
            return false;
        }
        catch (AS400SecurityException e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Ignoring security exception on isCommitmentControlStarted(AS400).", (Throwable)e);
            }
            return false;
        }
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    public boolean isReadNoUpdate() {
        if (this.impl_ != null) {
            this.readNoUpdate_ = this.impl_.doItBoolean("isReadNoUpdate");
        }
        return this.readNoUpdate_;
    }

    public boolean isReadOnly() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.doItInt("getOpenType") == 0;
    }

    public boolean isReadWrite() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.doItInt("getOpenType") == 1;
    }

    public boolean isSSPFile() {
        return this.ssp_;
    }

    public boolean isWriteOnly() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.doItInt("getOpenType") == 2;
    }

    public void lock(int lockToObtain) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (lockToObtain < 0 || lockToObtain > 5) {
            throw new ExtendedIllegalArgumentException("lockToObtain", 2);
        }
        this.chooseImpl();
        this.impl_.doIt("lock", new Class[]{Integer.TYPE}, new Object[]{new Integer(lockToObtain)});
    }

    public void open() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.open(1, 1, 4);
    }

    public void open(int openType, int blockingFactor, int commitLockLevel) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        if (openType != 0 && openType != 1 && openType != 2) {
            throw new ExtendedIllegalArgumentException("openType", 2);
        }
        if (blockingFactor < 0) {
            throw new ExtendedIllegalArgumentException("blockingFactor", 2);
        }
        if (commitLockLevel < 0 || commitLockLevel > 4) {
            throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
        }
        this.openFile(openType, blockingFactor, commitLockLevel, this instanceof KeyedFile);
    }

    synchronized void openFile(int openType, int blockingFactor, int commitLockLevel, boolean access) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int bf;
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        this.chooseImpl();
        this.recordFormat_.initializeTextObjects(this.system_);
        if (openType != 1) {
            int block;
            bf = blockingFactor == 0 ? ((block = 2048 / (this.recordFormat_.getNewRecord().getRecordLength() + 16)) > 0 ? block : 1) : blockingFactor;
            int recordIncrement = this.recordFormat_.getNewRecord().getRecordLength() + this.recordFormat_.getNumberOfFields() + this.recordFormat_.getNumberOfKeyFields() + 16;
            bf = bf * recordIncrement >= 0x1000000 ? 0x1000000 / recordIncrement : bf;
        } else {
            bf = 1;
        }
        String[] toSet = this.impl_.openFile2(openType, bf, commitLockLevel, access);
        if (toSet[0] != null) {
            this.library_ = toSet[0];
        }
        if (toSet[1] != null) {
            String old = this.member_;
            this.member_ = toSet[1];
            this.changes_.firePropertyChange("member", old, this.member_);
        }
        this.isOpen_ = true;
        this.fireEvent(3);
    }

    public void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorAfterLast");
    }

    public void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        this.doIt("positionCursorBeforeFirst");
    }

    public void positionCursorToFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            this.doIt("positionCursorToFirstLong");
        } else {
            this.doIt("positionCursorToFirst");
        }
    }

    public void positionCursorToLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            this.doIt("positionCursorToLastLong");
        } else {
            this.doIt("positionCursorToLast");
        }
    }

    public void positionCursorToNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            this.doIt("positionCursorToNextLong");
        } else {
            this.doIt("positionCursorToNext");
        }
    }

    public void positionCursorToPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            this.doIt("positionCursorToPreviousLong");
        } else {
            this.doIt("positionCursorToPrevious");
        }
    }

    public Record read() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[0], new Object[0]));
    }

    public abstract Record[] readAll() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public Record readFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        return this.fillInRecord(this.impl_.doItRecord("readFirst", new Class[0], new Object[0]));
    }

    public Record readLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readLastLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readLast", new Class[0], new Object[0]));
    }

    public Record readNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNext", new Class[0], new Object[0]));
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public Record readPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPrevious", new Class[0], new Object[0]));
    }

    public void refreshRecordCache() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            this.doIt("refreshRecordCacheLong");
        } else {
            this.doIt("refreshRecordCache");
        }
    }

    public void releaseExplicitLocks() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.chooseImpl();
        this.doIt("releaseExplicitLocks");
    }

    public void removeFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    public void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted()) {
            this.doIt("rollback");
        }
    }

    public static void rollback(AS400 system) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        system.signon(false);
        AS400FileImpl impl = (AS400FileImpl)system.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        impl.doIt("rollback", new Class[]{AS400Impl.class}, new Object[]{system.getImpl()});
    }

    public AS400Message[] runCommand(String command) throws AS400SecurityException, InterruptedException, IOException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.chooseImpl();
        return this.impl_.execute(command);
    }

    private void setName(String name) {
        QSYSObjectPathName ifs = new QSYSObjectPathName(name);
        if (!ifs.getObjectType().equals("FILE") && !ifs.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(name, 1);
        }
        this.library_ = ifs.getLibraryName();
        this.file_ = ifs.getObjectName();
        this.member_ = ifs.getObjectType().equals("FILE") ? "*FIRST" : (ifs.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : ifs.getMemberName());
        this.name_ = name;
    }

    public void setPath(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String oldName = this.name_;
        this.vetos_.fireVetoableChange("path", oldName, name);
        this.setName(name);
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setPath", new Class[]{String.class}, new Object[]{name});
        }
        this.changes_.firePropertyChange("path", oldName, name);
    }

    public void setReadNoUpdate(boolean readNoUpdate) {
        this.readNoUpdate_ = readNoUpdate;
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setReadNoUpdate", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(readNoUpdate)});
        }
    }

    public void setRecordFormat() throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        this.setRecordFormat(0);
    }

    public void setRecordFormat(int recordFormat) throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        if (recordFormat < 0) {
            throw new ExtendedIllegalArgumentException("recordFormat (" + String.valueOf(recordFormat) + ") too small", 4);
        }
        this.chooseImpl();
        this.setRecordFormat(this.impl_.doItRecordFormat("setRecordFormat", new Class[]{Integer.TYPE}, new Object[]{new Integer(recordFormat)}));
    }

    public void setRecordFormat(String recordFormat) throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        this.chooseImpl();
        this.setRecordFormat(this.impl_.doItRecordFormat("setRecordFormat", new Class[]{String.class}, new Object[]{recordFormat}));
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        RecordFormat old = this.recordFormat_;
        this.vetos_.fireVetoableChange("recordFormat", old, recordFormat);
        this.recordFormat_ = recordFormat;
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setRecordFormat", new Class[]{RecordFormat.class}, new Object[]{this.recordFormat_});
        }
        this.changes_.firePropertyChange("recordFormat", old, this.recordFormat_);
    }

    public void setSSPFile(boolean treatAsSSP) {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException("treatAsSSP", 5);
        }
        this.ssp_ = treatAsSSP;
        if (this.impl_ != null) {
            this.impl_.doItNoExceptions("setSSPFile", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(treatAsSSP)});
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.isOpen_ || this.impl_ != null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 old = this.system_;
        this.vetos_.fireVetoableChange("system", old, system);
        this.system_ = system;
        this.changes_.firePropertyChange("system", old, this.system_);
    }

    public void startCommitmentControl(int commitLockLevel) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (commitLockLevel < 0 || commitLockLevel > 2) {
            throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
        }
        if (this.isCommitmentControlStarted()) {
            throw new ExtendedIllegalStateException(1);
        }
        this.chooseImpl();
        this.impl_.doIt("startCommitmentControl", new Class[]{Integer.TYPE}, new Object[]{new Integer(commitLockLevel)});
    }

    public static void startCommitmentControl(AS400 system, int commitLockLevel) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (commitLockLevel < 0 || commitLockLevel > 2) {
            throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
        }
        system.signon(false);
        AS400FileImpl impl = (AS400FileImpl)system.loadImpl3("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote", "com.ibm.as400.access.AS400FileImplProxy");
        impl.doIt("startCommitmentControl", new Class[]{AS400Impl.class, Integer.TYPE}, new Object[]{system.getImpl(), new Integer(commitLockLevel)});
    }

    public void update(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.impl_.doIt("update", new Class[]{Record.class}, new Object[]{record});
        this.fireEvent(2);
    }

    public void write(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.write(new Record[]{record});
    }

    public void write(Record[] records) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (records == null) {
            throw new NullPointerException("records");
        }
        if (records.length == 0) {
            throw new ExtendedIllegalArgumentException("records", 1);
        }
        this.impl_.doIt("write", new Class[]{Record[].class}, new Object[]{records});
        this.fireEvent(2);
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

