/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileRecordDescriptionEvent;
import com.ibm.as400.access.AS400FileRecordDescriptionImpl;
import com.ibm.as400.access.AS400FileRecordDescriptionListener;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RecordFormat;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;

public class AS400FileRecordDescription
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private String file_ = "";
    private String member_ = "";
    private String name_ = "";
    private AS400 system_ = null;
    transient Vector rdeListeners_;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;
    private transient AS400FileRecordDescriptionImpl impl_;

    public AS400FileRecordDescription() {
        this.initializeTransient();
    }

    public AS400FileRecordDescription(AS400 system, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.name_ = name;
        this.parseName();
        this.system_ = system;
    }

    public void addAS400FileRecordDescriptionListener(AS400FileRecordDescriptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.rdeListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.impl_ = (AS400FileRecordDescriptionImpl)this.system_.loadImpl2("com.ibm.as400.access.AS400FileRecordDescriptionImplRemote", "com.ibm.as400.access.AS400FileRecordDescriptionImplProxy");
            this.impl_.setPath(this.name_);
            this.impl_.setSystem(this.system_.getImpl());
        }
        this.system_.signon(false);
    }

    public synchronized void createRecordFormatSource(String filePath, String packageName) throws AS400Exception, AS400SecurityException, IOException, InterruptedException {
        this.chooseImpl();
        String[] filesToWrite = this.impl_.createRecordFormatSource(packageName);
        String fileSeparator = System.getProperty("file.separator");
        if (filePath != null) {
            if (filePath.lastIndexOf(fileSeparator) != filePath.length() - fileSeparator.length()) {
                filePath = filePath + fileSeparator;
            }
        } else {
            filePath = "";
        }
        for (int i = 0; i < filesToWrite.length / 2; ++i) {
            String fileName = filePath + filesToWrite[i * 2];
            FileOutputStream os = new FileOutputStream(fileName);
            PrintWriter sourceFile = new PrintWriter(os, true);
            sourceFile.print(filesToWrite[i * 2 + 1]);
            if (sourceFile.checkError()) {
                sourceFile.close();
                throw new InternalErrorException("Error writing to sourceFile.", 6);
            }
            sourceFile.close();
        }
        Vector targets = (Vector)this.rdeListeners_.clone();
        AS400FileRecordDescriptionEvent event = new AS400FileRecordDescriptionEvent(this, 2);
        for (int i = 0; i < targets.size(); ++i) {
            AS400FileRecordDescriptionListener target = (AS400FileRecordDescriptionListener)targets.elementAt(i);
            target.recordFormatSourceCreated(event);
        }
    }

    private void parseName() {
        QSYSObjectPathName ifs = new QSYSObjectPathName(this.name_);
        if (!ifs.getObjectType().equals("FILE") && !ifs.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(this.name_, 1);
        }
        this.file_ = ifs.getObjectName();
        this.member_ = ifs.getObjectType().equals("FILE") ? "*FIRST" : (ifs.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : ifs.getMemberName());
    }

    public String getFileName() {
        return this.file_;
    }

    public String getMemberName() {
        return this.member_;
    }

    public String getPath() {
        return this.name_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.rdeListeners_ = new Vector();
        this.impl_ = null;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeAS400FileRecordDescriptionListener(AS400FileRecordDescriptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.rdeListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    public synchronized RecordFormat[] retrieveRecordFormat() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.chooseImpl();
        RecordFormat[] rfs = this.impl_.retrieveRecordFormat();
        for (int i = 0; rfs != null && i < rfs.length; ++i) {
            rfs[i].initializeTextObjects(this.system_);
        }
        Vector targets = (Vector)this.rdeListeners_.clone();
        AS400FileRecordDescriptionEvent event = new AS400FileRecordDescriptionEvent(this, 1);
        for (int i = 0; i < targets.size(); ++i) {
            AS400FileRecordDescriptionListener target = (AS400FileRecordDescriptionListener)targets.elementAt(i);
            target.recordFormatRetrieved(event);
        }
        return rfs;
    }

    public void setPath(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String oldName = this.name_;
        this.vetos_.fireVetoableChange("path", oldName, name);
        this.name_ = name;
        this.parseName();
        if (this.impl_ != null) {
            this.impl_.setPath(this.name_);
        }
        this.changes_.firePropertyChange("path", oldName, name);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 old = this.system_;
        this.vetos_.fireVetoableChange("system", old, system);
        this.system_ = system;
        if (this.impl_ != null) {
            this.impl_.setSystem(this.system_.getImpl());
        }
        this.changes_.firePropertyChange("system", old, this.system_);
    }
}

