/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;

class AS400ImplProxy
extends AbstractProxyImpl
implements AS400Impl {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400ImplProxy";
    private int bidiStringType = 0;

    AS400ImplProxy() {
        super("AS400");
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connection_.addListener(this.pxId_, listener, "Connection");
    }

    public String ccsidToEncoding(int ccsid) {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "ccsidToEncoding", new Class[]{Integer.TYPE}, new Object[]{new Integer(ccsid)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public SignonInfo changePassword(String systemName, boolean systemNameLocal, String userId, byte[] oldBytes, byte[] newBytes) throws AS400SecurityException, IOException {
        try {
            return (SignonInfo)this.connection_.callMethod(this.pxId_, "changePassword", new Class[]{String.class, Boolean.TYPE, String.class, byte[].class, byte[].class}, new Object[]{systemName, new Boolean(systemNameLocal), userId, oldBytes, newBytes}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    public void connect(int service) throws AS400SecurityException, IOException {
        this.connect(service, -1, false);
    }

    public void connect(int service, int overridePort, boolean skipSignonServer) throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connect", new Class[]{Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(service), new Boolean(skipSignonServer)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    public Socket connectToPort(int port) throws AS400SecurityException, IOException {
        try {
            return (Socket)this.connection_.callMethod(this.pxId_, "connectToPort", new Class[]{Integer.TYPE}, new Object[]{new Integer(port)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    public Socket connectToPort(int port, boolean forceNonLocalhost) throws AS400SecurityException, IOException {
        try {
            return (Socket)this.connection_.callMethod(this.pxId_, "connectToPort", new Class[]{Integer.TYPE}, new Object[]{new Integer(port)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    public void disconnect(int service) {
        try {
            this.connection_.callMethod(this.pxId_, "disconnect", new Class[]{Integer.TYPE}, new Object[]{new Integer(service)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public byte[] exchangeSeed(byte[] proxySeed) {
        try {
            return (byte[])this.connection_.callMethod(this.pxId_, "exchangeSeed", new Class[]{byte[].class}, new Object[]{proxySeed}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void generateProfileToken(ProfileTokenCredential profileToken, String userIdentity) throws AS400SecurityException, IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "generateProfileToken", new Class[]{ProfileTokenCredential.class, String.class}, new Object[]{profileToken, userIdentity}, new boolean[]{true, false}, true);
            ProfileTokenCredential returnArg = (ProfileTokenCredential)rv.getArgument(0);
            profileToken.setToken(returnArg.getToken());
            return;
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    public void generateProfileToken(ProfileTokenCredential profileToken, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException, InterruptedException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "generateProfileToken", new Class[]{ProfileTokenCredential.class, String.class, CredentialVault.class, String.class}, new Object[]{profileToken, userId, vault, gssName}, new boolean[]{true, false, false, false}, true);
            ProfileTokenCredential returnArg = (ProfileTokenCredential)rv.getArgument(0);
            profileToken.setToken(returnArg.getToken());
            return;
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow3(e);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    public String[] getJobs(int service) {
        try {
            return (String[])this.connection_.callMethod(this.pxId_, "getJobs", new Class[]{Integer.TYPE}, new Object[]{new Integer(service)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public int getServicePort(String systemName, int service) {
        try {
            return this.connection_.callMethod(this.pxId_, "getServicePort", new Class[]{String.class, Integer.TYPE}, new Object[]{systemName, new Integer(service)}).getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public boolean isConnected(int service) {
        try {
            return this.connection_.callMethod(this.pxId_, "isConnected", new Class[]{Integer.TYPE}, new Object[]{new Integer(service)}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public boolean isConnectionAlive() {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "isConnectionAlive");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public boolean isConnectionAlive(int service) {
        try {
            return this.connection_.callMethod(this.pxId_, "isConnectionAlive", new Class[]{Integer.TYPE}, new Object[]{new Integer(service)}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void newConverter(int ccsid) throws UnsupportedEncodingException {
        try {
            this.connection_.callMethod(this.pxId_, "newConverter", new Class[]{Integer.TYPE}, new Object[]{new Integer(ccsid)});
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)target;
            }
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connection_.removeListener(this.pxId_, listener, "Connection");
    }

    public void setGSSCredential(Object gssCredential) {
        try {
            this.connection_.callMethod(this.pxId_, "setGSSCredential", new Class[]{Object.class}, new Object[]{gssCredential});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setServicePort(String systemName, int service, int port) {
        try {
            this.connection_.callMethod(this.pxId_, "setServicePort", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{systemName, new Integer(service), new Integer(port)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setServicePortsToDefault(String systemName) {
        try {
            this.connection_.callMethod(this.pxId_, "setServicePortsToDefault", new Class[]{String.class}, new Object[]{systemName});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setState(SSLOptions useSSLConnection, boolean canUseNativeOptimization, boolean threadUsed, int ccsid, String nlv, SocketProperties socketProperties, String ddmRDB, boolean mustUseNetSockets, boolean mustUseSuppliedProfile, boolean mustAddLanguageLibrary) {
        try {
            this.connection_.callMethod(this.pxId_, "setState", new Class[]{SSLOptions.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, String.class, SocketProperties.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{useSSLConnection, new Boolean(canUseNativeOptimization), new Boolean(threadUsed), new Integer(ccsid), nlv, socketProperties, ddmRDB, new Boolean(mustUseNetSockets), new Boolean(mustUseSuppliedProfile), new Boolean(mustAddLanguageLibrary)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public SignonInfo signon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException {
        try {
            return (SignonInfo)this.connection_.callMethod(this.pxId_, "signon", new Class[]{String.class, Boolean.TYPE, String.class, CredentialVault.class, String.class}, new Object[]{systemName, new Boolean(systemNameLocal), userId, vault, gssName}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    public SignonInfo skipSignon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException {
        try {
            return (SignonInfo)this.connection_.callMethod(this.pxId_, "skipSignon", new Class[]{String.class, Boolean.TYPE, String.class, CredentialVault.class, String.class}, new Object[]{systemName, new Boolean(systemNameLocal), userId, vault, gssName}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    public void setBidiStringType(int bidiStringType) {
        this.bidiStringType = bidiStringType;
    }

    public int getBidiStringType() {
        return this.bidiStringType;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

