/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCCallableStatement;
import com.ibm.as400.access.AS400JDBCCallableStatementRedirect;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCDatabaseMetaData;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCPreparedStatementRedirect;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400JDBCStatementRedirect;
import com.ibm.as400.access.AS400JDBCTransientException;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.SQLData;
import java.beans.PropertyVetoException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

public class AS400JDBCConnectionRedirect
extends AS400JDBCConnection {
    public static final int SEAMLESS_RETRY_COUNT = 15;
    boolean enableSeamlessFailover_ = false;
    boolean doNotHandleErrors_ = false;
    AS400JDBCConnectionImpl currentConnection_ = new AS400JDBCConnectionImpl();
    JDDataSourceURL currentUrl_ = null;
    private AS400 originalAs400;
    private JDDataSourceURL originalDataSourceUrl_;
    private JDProperties originalProperties_;
    private Properties info_;
    private Properties originalInfo_;
    private JDDataSourceURL[] reconnectUrls_;
    private JDProperties[] reconnectProperties_;
    private AS400[] reconnectAS400s_;
    private int maxRetriesForClientReroute_ = -1;
    private int retryIntervalForClientReroute_ = -1;
    private Vector setCommands_ = null;
    private boolean throwException_;
    private boolean autoCommitSet_ = false;
    private boolean autoCommitSetting_ = false;
    private boolean transactionIsolationSet_ = false;
    private int transactionIsolationSetting_ = 0;
    private Hashtable clientInfoHashtable_ = null;
    private boolean holdabilitySet_ = false;
    private int holdability_ = 0;
    private boolean readOnlySet_ = false;
    private boolean readOnly_;
    private boolean networkTimeoutSet_ = false;
    private int networkTimeout_;
    private boolean lastConnectionCanSeamlessFailover_ = false;
    private boolean topLevelApi_ = false;
    String[] reconnectUrlStrings_ = null;

    AS400JDBCConnectionRedirect() {
    }

    private void setupRetryInformation() {
        this.enableSeamlessFailover_ = this.getEnableSeamlessFailover();
        this.maxRetriesForClientReroute_ = this.getMaxRetriesForClientReroute();
        this.retryIntervalForClientReroute_ = this.getRetryIntervalForClientReroute();
        if (this.retryIntervalForClientReroute_ > 0 && this.maxRetriesForClientReroute_ < 0) {
            this.maxRetriesForClientReroute_ = 3;
        }
        if (this.maxRetriesForClientReroute_ > 0 && this.retryIntervalForClientReroute_ < 0) {
            this.retryIntervalForClientReroute_ = 0;
        }
        Vector alternateServerNames = this.getAlternateServerNames();
        Vector alternatePortNumbers = this.getAlternatePortNumbers();
        this.setupAlternateServers(alternateServerNames, alternatePortNumbers);
    }

    private void setupAlternateServers(String alternateServers) {
        Vector alternateServerNames = this.getCommaSeparatedList(alternateServers);
        Vector alternatePortNumbers = this.getAlternatePortNumbers();
        this.setupAlternateServers(alternateServerNames, alternatePortNumbers);
    }

    private void setupAlternateServers(Vector alternateServerNames, Vector alternatePortNumbers) {
        int alternateServerCount = alternateServerNames.size();
        int alternatePortCount = alternatePortNumbers.size();
        this.reconnectUrls_ = new JDDataSourceURL[1 + alternateServerCount];
        this.reconnectProperties_ = new JDProperties[1 + alternateServerCount];
        this.reconnectAS400s_ = new AS400[1 + alternateServerCount];
        this.reconnectUrls_[0] = this.originalDataSourceUrl_;
        this.reconnectProperties_[0] = this.originalProperties_;
        this.reconnectAS400s_[0] = new AS400(this.originalAs400);
        boolean secure = this.originalProperties_.getBoolean(32);
        for (int i = 0; i < alternateServerCount; ++i) {
            String server = (String)alternateServerNames.elementAt(i);
            String port = null;
            port = i < alternatePortCount ? (String)alternatePortNumbers.elementAt(i) : (secure ? "9471" : "8471");
            this.reconnectUrls_[i + 1] = this.fixupDataSourceUrl(server, port);
            this.reconnectProperties_[i + 1] = this.fixupProperties(server, port);
            this.reconnectAS400s_[i + 1] = this.fixupAS400(server, port);
        }
    }

    private AS400 fixupAS400(String server, String port) {
        AS400 as400 = new AS400(this.originalAs400);
        try {
            as400.setSystemName(server);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return as400;
    }

    private JDProperties fixupProperties(String server, String port) {
        JDProperties properties = (JDProperties)this.originalProperties_.clone();
        if (port != null) {
            properties.setString(92, port);
        }
        return properties;
    }

    private JDDataSourceURL fixupDataSourceUrl(String server, String port) {
        JDDataSourceURL url = new JDDataSourceURL(this.originalDataSourceUrl_, server, port);
        return url;
    }

    boolean getEnableSeamlessFailover() {
        int value = this.originalProperties_.getInt(98);
        return value == 1;
    }

    int getMaxRetriesForClientReroute() {
        int value = this.originalProperties_.getInt(96);
        if (value < 0) {
            value = -1;
        }
        return value;
    }

    int getRetryIntervalForClientReroute() {
        int value = this.originalProperties_.getInt(97);
        if (value < 0) {
            value = -1;
        }
        return value;
    }

    private Vector getAlternatePortNumbers() {
        return this.getPropertiesList(95);
    }

    private Vector getAlternateServerNames() {
        return this.getPropertiesList(94);
    }

    private Vector getPropertiesList(int property) {
        String propertyString = this.originalProperties_.getString(property);
        return this.getCommaSeparatedList(propertyString);
    }

    private Vector getCommaSeparatedList(String list) {
        Vector<String> propertiesList = new Vector<String>();
        if (list != null) {
            int startIndex = 0;
            int commaIndex = list.indexOf(44, startIndex);
            while (commaIndex >= 0) {
                propertiesList.add(list.substring(startIndex, commaIndex));
                startIndex = commaIndex + 1;
                commaIndex = list.indexOf(44, startIndex);
            }
            String lastPort = list.substring(startIndex);
            if (lastPort.length() > 0) {
                propertiesList.add(lastPort);
            }
        }
        return propertiesList;
    }

    boolean reconnect(SQLException originalException) throws SQLException {
        return this.findNewConnection(originalException);
    }

    private void replaySettings(AS400JDBCConnectionImpl newConnection) throws SQLException {
        if (this.setCommands_ != null) {
            Statement stmt = newConnection.createStatement();
            Enumeration elements = this.setCommands_.elements();
            while (elements.hasMoreElements()) {
                String setCommand = (String)elements.nextElement();
                stmt.executeUpdate(setCommand);
            }
            stmt.close();
        }
        if (this.autoCommitSet_) {
            newConnection.setAutoCommit(this.autoCommitSetting_);
        }
        if (this.transactionIsolationSet_) {
            newConnection.setTransactionIsolation(this.transactionIsolationSetting_);
        }
        if (this.holdabilitySet_) {
            newConnection.setHoldability(this.holdability_);
        }
        if (this.readOnlySet_) {
            newConnection.setReadOnly(this.readOnly_);
        }
        if (this.networkTimeoutSet_) {
            newConnection.setNetworkTimeout(this.networkTimeout_);
        }
        if (this.clientInfoHashtable_ != null) {
            Enumeration keysEnum = this.clientInfoHashtable_.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                String value = (String)this.clientInfoHashtable_.get(key);
                newConnection.setClientInfo(key, value);
            }
        }
        newConnection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupNewConnection(AS400JDBCConnectionImpl newConnection, JDDataSourceURL newUrl, SQLException e) throws SQLException {
        block9: {
            this.replaySettings(newConnection);
            if (this.enableSeamlessFailover_) {
                this.lastConnectionCanSeamlessFailover_ = this.currentConnection_.canSeamlessFailover();
            }
            this.doNotHandleErrors_ = true;
            try {
                try {
                    this.currentConnection_.closeAllResultSets();
                }
                catch (Exception closeException) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(this, "Exception from closeAllResultSets", e);
                    }
                    Object var6_5 = null;
                    this.doNotHandleErrors_ = false;
                    break block9;
                }
                catch (Throwable t) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(this, "Throwable from closeAllResultSets", e);
                    }
                    Object var6_6 = null;
                    this.doNotHandleErrors_ = false;
                }
                Object var6_4 = null;
                this.doNotHandleErrors_ = false;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.doNotHandleErrors_ = false;
                throw throwable;
            }
        }
        this.currentConnection_.resetStatements(newConnection.transactionManager_);
        this.currentConnection_.transferObjects(newConnection);
        this.currentConnection_ = newConnection;
        this.currentUrl_ = newUrl;
        if (this.lastConnectionCanSeamlessFailover_ && this.topLevelApi_) {
            return true;
        }
        this.throwException_ = true;
        JDError.throwSQLException((Object)this, "08506", e);
        return false;
    }

    boolean findNewConnection(SQLException originalException) throws SQLException {
        int searchStart = 0;
        int sqlcode = originalException.getErrorCode();
        if (sqlcode == -7061 && this.currentUrl_ != null) {
            for (int i = 0; i < this.reconnectUrls_.length; ++i) {
                if (this.reconnectUrls_[i] != this.currentUrl_) continue;
                searchStart = i + 1;
                if (searchStart == this.reconnectUrls_.length) {
                    searchStart = 0;
                }
                i = this.reconnectUrls_.length;
            }
        }
        Exception[] exceptions = new Exception[this.reconnectUrls_.length];
        long startMilliseconds = System.currentTimeMillis();
        int retryCount = this.maxRetriesForClientReroute_ >= 0 ? this.maxRetriesForClientReroute_ : Integer.MAX_VALUE;
        long delayMilliseconds = this.retryIntervalForClientReroute_ >= 0 ? (long)(this.retryIntervalForClientReroute_ * 1000) : 30000L;
        while (retryCount > 0) {
            long retryStartMilliseonds = System.currentTimeMillis();
            for (int i = searchStart; i < this.reconnectUrls_.length; ++i) {
                AS400JDBCConnectionImpl connection = new AS400JDBCConnectionImpl();
                AS400 as400 = new AS400(this.reconnectAS400s_[i]);
                try {
                    connection.setProperties(this.reconnectUrls_[i], this.reconnectProperties_[i], as400, this.originalInfo_);
                    return this.setupNewConnection(connection, this.reconnectUrls_[i], originalException);
                }
                catch (SQLException e) {
                    if (this.throwException_) {
                        this.throwException_ = false;
                        throw e;
                    }
                    exceptions[i] = e;
                    if (!JDTrace.isTraceOn()) continue;
                    JDTrace.logException(this, "Unable to connect to system i=" + i + " as400=" + as400, e);
                    continue;
                }
            }
            --retryCount;
            if (searchStart > 0) {
                ++retryCount;
                searchStart = 0;
                continue;
            }
            long retryDelayMilliseconds = 0L;
            long retryElaspedMilliseconds = System.currentTimeMillis() - retryStartMilliseonds;
            if (this.maxRetriesForClientReroute_ < 0 && this.retryIntervalForClientReroute_ < 0) {
                retryDelayMilliseconds = delayMilliseconds - retryElaspedMilliseconds;
                delayMilliseconds += delayMilliseconds / 2L;
                long remainingMilliseconds = 600000L + startMilliseconds - System.currentTimeMillis();
                if (remainingMilliseconds < 0L) {
                    retryCount = 0;
                    retryDelayMilliseconds = 0L;
                } else if (remainingMilliseconds < retryDelayMilliseconds + retryElaspedMilliseconds && (retryDelayMilliseconds = remainingMilliseconds - retryElaspedMilliseconds) < 0L) {
                    retryDelayMilliseconds = 0L;
                }
            } else {
                retryDelayMilliseconds = delayMilliseconds - retryElaspedMilliseconds;
            }
            if (retryDelayMilliseconds <= 0L) continue;
            try {
                Thread.sleep(retryDelayMilliseconds);
            }
            catch (InterruptedException e) {
                throw originalException;
            }
        }
        throw originalException;
    }

    boolean handleException(SQLException e) throws SQLException {
        if (this.doNotHandleErrors_ || this.inFinalizer_) {
            throw e;
        }
        int sqlCode = e.getErrorCode();
        String sqlState = e.getSQLState();
        if (sqlCode == -99999 && ("08S01".equals(sqlState) || "08001".equals(sqlState)) || sqlCode == -7061 && this.should7061Reconnect(e)) {
            if (this.reconnect(e)) {
                return true;
            }
        } else {
            throw e;
        }
        throw e;
    }

    private boolean should7061Reconnect(SQLException e) {
        String message = e.getMessage();
        return message.indexOf(" 71.") > 0;
    }

    boolean handleSQLClientInfoException(SQLClientInfoException e) throws SQLClientInfoException {
        try {
            return this.handleException(e);
        }
        catch (SQLException e2) {
            if (e2 instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e2;
            }
            JDError.throwSQLClientInfoException(this, e2.getSQLState(), e2, e.getFailedProperties());
            throw e;
        }
    }

    public void cancel(int id) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.cancel(id);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void checkAccess(JDSQLStatement sqlStatement) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.checkAccess(sqlStatement);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void checkCancel() {
        this.currentConnection_.checkCancel();
    }

    public boolean checkHoldabilityConstants(int holdability) {
        return this.currentConnection_.checkHoldabilityConstants(holdability);
    }

    public void checkOpen() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.checkOpen();
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.clearWarnings();
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            Object var5_4;
            try {
                try {
                    this.currentConnection_.close();
                    retryOperation = false;
                }
                catch (SQLException e) {
                    if (retryCount > 0) {
                        this.topLevelApi_ = true;
                    }
                    retryOperation = this.handleException(e);
                    --retryCount;
                    var5_4 = null;
                    this.topLevelApi_ = false;
                    continue;
                }
                var5_4 = null;
                this.topLevelApi_ = false;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.topLevelApi_ = false;
                throw throwable;
            }
        }
    }

    public void handleAbort() {
        this.currentConnection_.handleAbort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            Object var5_4;
            try {
                try {
                    this.currentConnection_.commit();
                    retryOperation = false;
                }
                catch (SQLException e) {
                    if (retryCount > 0) {
                        this.topLevelApi_ = true;
                    }
                    retryOperation = this.handleException(e);
                    --retryCount;
                    var5_4 = null;
                    this.topLevelApi_ = false;
                    continue;
                }
                var5_4 = null;
                this.topLevelApi_ = false;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.topLevelApi_ = false;
                throw throwable;
            }
        }
    }

    public void setCheckStatementHoldability(boolean check) {
        this.currentConnection_.setCheckStatementHoldability(check);
    }

    public int correctResultSetType(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.correctResultSetType(resultSetType, resultSetConcurrency);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            Object var6_5;
            AS400JDBCStatement newStatement;
            block7: {
                newStatement = (AS400JDBCStatement)this.currentConnection_.createStatement(this);
                if (!this.enableSeamlessFailover_) break block7;
                AS400JDBCStatementRedirect aS400JDBCStatementRedirect = new AS400JDBCStatementRedirect(newStatement);
                var6_5 = null;
                this.topLevelApi_ = false;
                return aS400JDBCStatementRedirect;
            }
            try {
                AS400JDBCStatement aS400JDBCStatement = newStatement;
                var6_5 = null;
                this.topLevelApi_ = false;
                return aS400JDBCStatement;
            }
            catch (SQLException e) {
                try {
                    if (retryCount > 0) {
                        this.topLevelApi_ = true;
                    }
                    retryOperation = this.handleException(e);
                    --retryCount;
                    var6_5 = null;
                    this.topLevelApi_ = false;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    this.topLevelApi_ = false;
                    throw throwable;
                }
            }
        }
        return null;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                AS400JDBCStatement newStatement = (AS400JDBCStatement)this.currentConnection_.createStatement(this, resultSetType, resultSetConcurrency);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                AS400JDBCStatement newStatement = (AS400JDBCStatement)this.currentConnection_.createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void debug(DBBaseRequestDS request) {
        this.currentConnection_.debug(request);
    }

    public void debug(DBReplyRequestedDS reply) {
        this.currentConnection_.debug(reply);
    }

    public AS400Impl getAS400() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getAS400();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getAutoCommit();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public String getCatalog() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getCatalog();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getConcurrentAccessResolution() {
        return this.currentConnection_.getConcurrentAccessResolution();
    }

    public ConvTable getConverter(int ccsid) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getConverter(ccsid);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getDataCompression() {
        return this.currentConnection_.getDataCompression();
    }

    public String getDefaultSchema() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getDefaultSchema();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String getDefaultSchema(boolean returnRawValue) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getDefaultSchema(returnRawValue);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getHoldability() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getHoldability();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public int getID() {
        return this.currentConnection_.getID();
    }

    public int getInternalHoldability() {
        return this.currentConnection_.getInternalHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                AS400JDBCDatabaseMetaData metadata = (AS400JDBCDatabaseMetaData)this.currentConnection_.getMetaData();
                metadata.connection_ = this;
                return metadata;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public JDProperties getProperties() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getProperties();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String getServerJobIdentifier() {
        return this.currentConnection_.getServerJobIdentifier();
    }

    public int getServerFunctionalLevel() {
        return this.currentConnection_.getServerFunctionalLevel();
    }

    public AS400 getSystem() {
        return this.currentConnection_.getSystem();
    }

    public int getTransactionIsolation() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getTransactionIsolation();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public JDTransactionManager getTransactionManager() {
        return this.currentConnection_.getTransactionManager();
    }

    public Map getTypeMap() throws SQLException {
        return this.currentConnection_.getTypeMap();
    }

    public int getUnusedId(int resultSetType) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getUnusedId(resultSetType);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public boolean getMustSpecifyForUpdate() {
        return this.currentConnection_.getMustSpecifyForUpdate();
    }

    public String getURL() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getURL();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String getUserName() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getUserName();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getVRM() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getVRM();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getWarnings();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public boolean isCursorNameUsed(String cursorName) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.isCursorNameUsed(cursorName);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public boolean isClosed() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.isClosed();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.isReadOnly();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public boolean isReadOnlyAccordingToProperties() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.isReadOnlyAccordingToProperties();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public void markCursorsClosed(boolean isRollback) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.markCursorsClosed(isRollback);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void markStatementsClosed() {
        this.currentConnection_.markStatementsClosed();
    }

    public String makeGeneratedKeySelectStatement(String sql, int[] columnIndexes, String[] columnNames) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.makeGeneratedKeySelectStatement(sql, columnIndexes, columnNames);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String makeGeneratedKeySelectStatement(String sql) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.makeGeneratedKeySelectStatement(sql);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String nativeSQL(String sql) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.nativeSQL(this, sql);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void notifyClose(AS400JDBCStatement statement, int id) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.notifyClose(statement, id);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void postWarning(SQLWarning sqlWarning) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.postWarning(sqlWarning);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                AS400JDBCCallableStatement newStatement = (AS400JDBCCallableStatement)this.currentConnection_.prepareCall(this, sql);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCCallableStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                AS400JDBCCallableStatement stmt = (AS400JDBCCallableStatement)this.currentConnection_.prepareCall(this, sql, resultSetType, resultSetConcurrency);
                stmt.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCCallableStatementRedirect(stmt);
                }
                return stmt;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                AS400JDBCCallableStatement stmt = (AS400JDBCCallableStatement)this.currentConnection_.prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                stmt.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCCallableStatementRedirect(stmt);
                }
                return stmt;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            try {
                AS400JDBCPreparedStatement newStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement(this, sql);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                try {
                    retryOperation = this.handleException(e);
                }
                catch (AS400JDBCTransientException e2) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--retryCount >= 0) {
                            retryOperation = true;
                            continue;
                        }
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            try {
                AS400JDBCPreparedStatement newStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement((AS400JDBCConnection)this, sql, autoGeneratedKeys);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                try {
                    retryOperation = this.handleException(e);
                }
                catch (AS400JDBCTransientException e2) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--retryCount >= 0) {
                            retryOperation = true;
                            continue;
                        }
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            try {
                AS400JDBCPreparedStatement newStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement(this, sql, resultSetType, resultSetConcurrency);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                try {
                    retryOperation = this.handleException(e);
                }
                catch (AS400JDBCTransientException e2) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--retryCount >= 0) {
                            retryOperation = true;
                            continue;
                        }
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            try {
                AS400JDBCPreparedStatement newStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                try {
                    retryOperation = this.handleException(e);
                }
                catch (AS400JDBCTransientException e2) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--retryCount >= 0) {
                            retryOperation = true;
                            continue;
                        }
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            try {
                AS400JDBCPreparedStatement newStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement((AS400JDBCConnection)this, sql, columnIndexes);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                try {
                    retryOperation = this.handleException(e);
                }
                catch (AS400JDBCTransientException e2) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--retryCount >= 0) {
                            retryOperation = true;
                            continue;
                        }
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        boolean retryOperation = true;
        int retryCount = 15;
        while (retryOperation) {
            try {
                AS400JDBCPreparedStatement newStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement((AS400JDBCConnection)this, sql, columnNames);
                newStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(newStatement);
                }
                return newStatement;
            }
            catch (SQLException e) {
                try {
                    retryOperation = this.handleException(e);
                }
                catch (AS400JDBCTransientException e2) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--retryCount >= 0) {
                            retryOperation = true;
                            continue;
                        }
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void processSavepointRequest(String savepointStatement) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.processSavepointRequest(savepointStatement);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void pseudoClose() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.pseudoClose();
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.releaseSavepoint(savepoint);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void rollback() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.rollback();
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.rollback(savepoint);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void send(DBBaseRequestDS request) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.send(request);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void send(DBBaseRequestDS request, int id) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.send(request, id);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void send(DBBaseRequestDS request, int id, boolean leavePending) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.send(request, id, leavePending);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void sendAndHold(DBBaseRequestDS request, int id) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.sendAndHold(request, id);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.sendAndReceive(request);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request, int id) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.sendAndReceive(request, id);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public DBReplyRequestedDS sendAndMultiReceive(DBBaseRequestDS request) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.sendAndMultiReceive(request);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public DBReplyRequestedDS receiveMoreData() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.receiveMoreData();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setAutoCommit(autoCommit);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        this.autoCommitSet_ = true;
        this.autoCommitSetting_ = autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setCatalog(catalog);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setConcurrentAccessResolution(int concurrentAccessResolution) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setConcurrentAccessResolution(concurrentAccessResolution);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setDB2eWLMCorrelator(byte[] bytes) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setDB2eWLMCorrelator(bytes);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setDRDA(boolean drda) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setDRDA(drda);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setHoldability(holdability);
                retryOperation = false;
                this.holdability_ = holdability;
                this.holdabilitySet_ = true;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400 as400, Properties info) throws SQLException {
        block6: {
            try {
                this.originalDataSourceUrl_ = dataSourceUrl;
                this.originalProperties_ = properties;
                this.originalAs400 = as400;
                this.originalInfo_ = info;
                if (info == null) {
                    this.originalInfo_ = new Properties();
                    this.originalInfo_.put("user", as400.getUserId());
                }
                this.setupRetryInformation();
                this.currentConnection_.setProperties(dataSourceUrl, properties, as400, info);
                String alternateServer = this.currentConnection_.getAlternateServer();
                if (alternateServer != null) {
                    this.setupAlternateServers(alternateServer);
                }
            }
            catch (SQLException e) {
                try {
                    this.handleException(e);
                }
                catch (SQLException e2) {
                    if (e2.getErrorCode() == -4498) break block6;
                    throw e2;
                }
            }
        }
    }

    public void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400Impl as400) throws SQLException {
        this.originalDataSourceUrl_ = dataSourceUrl;
        this.currentUrl_ = dataSourceUrl;
        this.originalProperties_ = properties;
        this.setupRetryInformation();
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setProperties(dataSourceUrl, properties, as400);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public boolean ignoreWarning(String sqlState) {
        return this.currentConnection_.ignoreWarning(sqlState);
    }

    public boolean ignoreWarning(SQLWarning warning) {
        return this.currentConnection_.ignoreWarning(warning);
    }

    public void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400Impl as400, boolean newServer, boolean skipSignonServer) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.originalDataSourceUrl_ = dataSourceUrl;
                this.originalProperties_ = properties;
                this.currentConnection_.setProperties(dataSourceUrl, properties, as400, newServer, skipSignonServer);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setReadOnly(readOnly);
                retryOperation = false;
                this.readOnlySet_ = true;
                this.readOnly_ = readOnly;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.setSavepoint();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.setSavepoint(name);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Savepoint setSavepoint(String name, int id) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.setSavepoint(name, id);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setServerAttributes() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setServerAttributes();
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setSystem(AS400 as400) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.originalAs400 = as400;
                this.currentConnection_.setSystem(as400);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setTransactionIsolation(level);
                retryOperation = false;
                this.transactionIsolationSet_ = true;
                this.transactionIsolationSetting_ = level;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setTypeMap(typeMap);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public boolean useExtendedFormats() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.useExtendedFormats();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public String[] getValidWrappedList() {
        return this.currentConnection_.getValidWrappedList();
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setClientInfo(name, value);
                if (this.clientInfoHashtable_ == null) {
                    this.clientInfoHashtable_ = new Hashtable();
                }
                if (value == null) {
                    value = "";
                }
                this.clientInfoHashtable_.put(name, value);
                retryOperation = false;
            }
            catch (SQLClientInfoException e) {
                retryOperation = this.handleSQLClientInfoException(e);
            }
        }
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setClientInfo(properties);
                if (this.clientInfoHashtable_ == null) {
                    this.clientInfoHashtable_ = new Hashtable();
                }
                String[] possibleNames = new String[]{"ApplicationName", "ClientUser", "ClientAccounting", "ClientHostname", "ClientProgramID"};
                for (int i = 0; i < possibleNames.length; ++i) {
                    String name = possibleNames[i];
                    String value = properties.getProperty(name);
                    if (value == null) {
                        value = "";
                    }
                    this.clientInfoHashtable_.put(name, value);
                }
                retryOperation = false;
            }
            catch (SQLClientInfoException e) {
                retryOperation = this.handleSQLClientInfoException(e);
            }
        }
    }

    public String getClientInfo(String name) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getClientInfo(name);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Properties getClientInfo() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getClientInfo();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Clob createClob() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.createClob();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Blob createBlob() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.createBlob();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.createArrayOf(typeName, elements);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.createStruct(typeName, attributes);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setDBHostServerTrace(boolean trace) {
        this.currentConnection_.setDBHostServerTrace(trace);
    }

    public boolean doUpdateDeleteBlocking() {
        return this.currentConnection_.doUpdateDeleteBlocking();
    }

    public int getMaximumBlockedInputRows() {
        return this.currentConnection_.getMaximumBlockedInputRows();
    }

    public String getSchema() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getSchema();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setNetworkTimeout(int timeout) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setNetworkTimeout(timeout);
                retryOperation = false;
                this.networkTimeoutSet_ = true;
                this.networkTimeout_ = timeout;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public int getNetworkTimeout() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.getNetworkTimeout();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public void setSchema(String schema) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setSchema(schema);
                retryOperation = false;
                if (this.setCommands_ == null) {
                    this.setCommands_ = new Vector();
                }
                this.setCommands_.add("SET SCHEMA " + schema);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public boolean isQueryTimeoutMechanismCancel() {
        return this.currentConnection_.isQueryTimeoutMechanismCancel();
    }

    public void setupVariableFieldCompression() {
        this.currentConnection_.setupVariableFieldCompression();
    }

    public boolean useVariableFieldCompression() {
        return this.currentConnection_.useVariableFieldCompression();
    }

    public boolean useVariableFieldInsertCompression() {
        return this.currentConnection_.useVariableFieldInsertCompression();
    }

    public void setDisableCompression(boolean disableCompression_) {
        this.currentConnection_.setDisableCompression(disableCompression_);
    }

    public void dumpStatementCreationLocation() {
        this.currentConnection_.dumpStatementCreationLocation();
    }

    public void testDataTruncation(AS400JDBCStatement statementWarningObject, AS400JDBCResultSet resultSetWarningObject, int parameterIndex, boolean isParameter, SQLData data, JDSQLStatement sqlStatement) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.testDataTruncation(statementWarningObject, resultSetWarningObject, parameterIndex, isParameter, data, sqlStatement);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public ConvTable getConverter() {
        return this.currentConnection_.getConverter();
    }

    public void setLastServerSQLState(String lastSqlState) {
        this.currentConnection_.setLastServerSQLState(lastSqlState);
    }

    public String getLastServerSQLState() {
        return this.currentConnection_.getLastServerSQLState();
    }

    public ConvTable getPackageCCSID_Converter() {
        return this.currentConnection_.getPackageCCSID_Converter();
    }

    public void finalize() {
    }

    public boolean getReadOnly() {
        return this.currentConnection_.getReadOnly();
    }

    public boolean getCheckStatementHoldability() {
        return this.currentConnection_.getCheckStatementHoldability();
    }

    public String toString() {
        return this.currentConnection_.toString();
    }

    int getNewAutoCommitSupport() {
        return this.currentConnection_.getNewAutoCommitSupport();
    }

    void addSetCommand(String command) {
        if (this.setCommands_ == null) {
            this.setCommands_ = new Vector();
        }
        this.setCommands_.addElement(command);
    }

    boolean canSeamlessFailover() {
        return this.lastConnectionCanSeamlessFailover_;
    }

    public String[] getReconnectURLs() {
        if (this.reconnectUrlStrings_ == null) {
            this.reconnectUrlStrings_ = new String[this.reconnectUrls_.length];
            for (int i = 0; i < this.reconnectUrls_.length; ++i) {
                this.reconnectUrlStrings_[i] = this.reconnectUrls_[i].toString();
            }
        }
        return this.reconnectUrlStrings_;
    }

    public boolean isValid(int timeout) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.isValid(timeout);
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public NClob createNClob() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.createNClob();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public SQLXML createSQLXML() throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                return this.currentConnection_.createSQLXML();
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void abort(Executor executor) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.abort(executor);
                retryOperation = false;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        boolean retryOperation = true;
        while (retryOperation) {
            try {
                this.currentConnection_.setNetworkTimeout(executor, milliseconds);
                retryOperation = false;
                this.networkTimeoutSet_ = true;
                this.networkTimeout_ = milliseconds;
            }
            catch (SQLException e) {
                retryOperation = this.handleException(e);
            }
        }
    }
}

