/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCManagedDataSource;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class AS400JDBCManagedConnectionPoolDataSource
extends AS400JDBCManagedDataSource
implements ConnectionPoolDataSource,
Referenceable,
Serializable {
    static final long serialVersionUID = 1L;
    private int initialPoolSize_ = 5;
    private int minPoolSize_ = 0;
    private int maxPoolSize_ = 0;
    private long maxIdleTime_ = 3600000L;
    private long propertyCycle_ = 300000L;
    private long maxLifetime_ = 86400000L;
    private boolean reuseConnections_ = true;
    private boolean pretestConnections_ = false;
    private boolean enforceMaxPoolSize_ = false;

    public AS400JDBCManagedConnectionPoolDataSource() {
    }

    public AS400JDBCManagedConnectionPoolDataSource(String serverName) {
        super(serverName);
    }

    public AS400JDBCManagedConnectionPoolDataSource(String serverName, String user, String password) {
        super(serverName, user, password);
    }

    public AS400JDBCManagedConnectionPoolDataSource(String serverName, String user, String password, String keyRingNameX, String keyRingPasswordX) {
        super(serverName, user, password, keyRingNameX, keyRingPasswordX);
    }

    AS400JDBCManagedConnectionPoolDataSource(Reference reference) {
        super(reference);
        RefAddr refAddr = reference.get("enforceMaxPoolSize");
        if (refAddr != null) {
            this.setEnforceMaxPoolSize(Boolean.valueOf((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("initialPoolSize")) != null) {
            this.setInitialPoolSize(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("maxLifetime")) != null) {
            this.setMaxLifetime(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("minPoolSize")) != null) {
            this.setMinPoolSize(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("maxPoolSize")) != null) {
            this.setMaxPoolSize(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("maxIdleTime")) != null) {
            this.setMaxIdleTime(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("pretestConnections")) != null) {
            this.setPretestConnections(Boolean.valueOf((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("propertyCycle")) != null) {
            this.setPropertyCycle(Integer.parseInt((String)refAddr.getContent()));
        }
        if ((refAddr = reference.get("reuseConnections")) != null) {
            this.setReuseConnections(Boolean.valueOf((String)refAddr.getContent()));
        }
    }

    public boolean checkPoolHealth(boolean logStatistics) {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.checkPoolHealth() is deprecated");
        return super.checkPoolHealth(logStatistics);
    }

    public void closePool() {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.closePool() is deprecated");
        super.closePool();
    }

    public Connection getConnection() throws SQLException {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.getConnection() is deprecated");
        return super.getConnection();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        this.logWarning("AS400JDBCManagedConnectionPoolDataSource.getConnection() is deprecated");
        return super.getConnection(user, password);
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize_;
    }

    public int getMaxIdleTime() {
        return (int)(this.maxIdleTime_ / 1000L);
    }

    public int getMaxLifetime() {
        return (int)(this.maxLifetime_ / 1000L);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public int getMinPoolSize() {
        return this.minPoolSize_;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        AS400JDBCPooledConnection pc = new AS400JDBCPooledConnection(this.createPhysicalConnection());
        if (JDTrace.isTraceOn() || this.log_ != null) {
            this.logInformation("PooledConnection created");
        }
        return pc;
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        AS400JDBCPooledConnection pc = new AS400JDBCPooledConnection(this.createPhysicalConnection(user, password));
        if (JDTrace.isTraceOn() || this.log_ != null) {
            this.logInformation("PooledConnection created for user " + user);
        }
        return pc;
    }

    public int getPropertyCycle() {
        return (int)(this.propertyCycle_ / 1000L);
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.ibm.as400.access.AS400JDBCObjectFactory", null);
        ref.add(new StringRefAddr("enforceMaxPoolSize", String.valueOf(this.isEnforceMaxPoolSize())));
        ref.add(new StringRefAddr("initialPoolSize", String.valueOf(this.getInitialPoolSize())));
        ref.add(new StringRefAddr("maxLifetime", String.valueOf(this.getMaxLifetime())));
        ref.add(new StringRefAddr("minPoolSize", String.valueOf(this.getMinPoolSize())));
        ref.add(new StringRefAddr("maxPoolSize", String.valueOf(this.getMaxPoolSize())));
        ref.add(new StringRefAddr("maxIdleTime", String.valueOf(this.getMaxIdleTime())));
        ref.add(new StringRefAddr("pretestConnections", String.valueOf(this.isPretestConnections())));
        ref.add(new StringRefAddr("propertyCycle", String.valueOf(this.getPropertyCycle())));
        ref.add(new StringRefAddr("reuseConnections", String.valueOf(this.isReuseConnections())));
        Reference dsRef = super.getReference();
        for (int i = 0; i < dsRef.size(); ++i) {
            ref.add(dsRef.get(i));
        }
        return ref;
    }

    static final boolean isConnectionPoolProperty(String prop) {
        return prop.equals("initialPoolSize") || prop.equals("enforceMaxPoolSize") || prop.equals("maxLifetime") || prop.equals("minPoolSize") || prop.equals("maxPoolSize") || prop.equals("maxIdleTime") || prop.equals("pretestConnections") || prop.equals("propertyCycle") || prop.equals("reuseConnections");
    }

    public boolean isEnforceMaxPoolSize() {
        return this.enforceMaxPoolSize_;
    }

    public boolean isPretestConnections() {
        return this.pretestConnections_;
    }

    public boolean isReuseConnections() {
        return this.reuseConnections_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setEnforceMaxPoolSize(boolean enforce) {
        this.enforceMaxPoolSize_ = enforce;
        this.logProperty("enforceMaxPoolSize", String.valueOf(this.enforceMaxPoolSize_));
    }

    public void setInitialPoolSize(int initialPoolSize) {
        String property = "initialPoolSize";
        if (initialPoolSize < 0) {
            throw new ExtendedIllegalArgumentException("initialPoolSize", 4);
        }
        this.initialPoolSize_ = initialPoolSize;
        this.logProperty("initialPoolSize", Integer.toString(this.initialPoolSize_));
    }

    public void setMaxIdleTime(int maxIdleTime) {
        String property = "maxIdleTime";
        if (maxIdleTime < 0) {
            throw new ExtendedIllegalArgumentException("maxIdleTime", 4);
        }
        this.maxIdleTime_ = maxIdleTime * 1000;
        this.logProperty("maxIdleTime", Integer.toString(maxIdleTime));
    }

    public void setMaxLifetime(int maxLifetime) {
        String property = "maxLifetime";
        if (maxLifetime < 0) {
            throw new ExtendedIllegalArgumentException("maxLifetime", 4);
        }
        this.maxLifetime_ = maxLifetime * 1000;
        this.logProperty("maxLifetime", Integer.toString(maxLifetime));
    }

    public void setMaxPoolSize(int maxPoolSize) {
        String property = "maxPoolSize";
        if (maxPoolSize < 0) {
            throw new ExtendedIllegalArgumentException("maxPoolSize", 4);
        }
        this.maxPoolSize_ = maxPoolSize;
        this.logProperty("maxPoolSize", Integer.toString(this.maxPoolSize_));
    }

    public void setMinPoolSize(int minPoolSize) {
        String property = "minPoolSize";
        if (minPoolSize < 0) {
            throw new ExtendedIllegalArgumentException("minPoolSize", 4);
        }
        this.minPoolSize_ = minPoolSize;
        this.logProperty("minPoolSize", Integer.toString(this.minPoolSize_));
    }

    public void setPretestConnections(boolean pretest) {
        this.pretestConnections_ = pretest;
        this.logProperty("pretestConnections", String.valueOf(this.pretestConnections_));
    }

    public void setPropertyCycle(int propertyCycle) {
        String property = "propertyCycle";
        if (propertyCycle < 0) {
            throw new ExtendedIllegalArgumentException("propertyCycle", 4);
        }
        this.propertyCycle_ = propertyCycle * 1000;
        this.logProperty("propertyCycle", Integer.toString(propertyCycle));
    }

    public void setReuseConnections(boolean reuse) {
        this.reuseConnections_ = reuse;
        this.logProperty("reuseConnections", String.valueOf(this.reuseConnections_));
    }
}

