/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBColumnDescriptorsDataFormat;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.ToolboxWrapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class AS400JDBCResultSetMetaData
extends ToolboxWrapper
implements ResultSetMetaData {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    static final int SQL_UNSEARCHABLE = 240;
    static final int SQL_LIKE_ONLY = 241;
    static final int SQL_ALL_EXCEPT_LIKE = 242;
    static final int SQL_SEARCHABLE = 243;
    static final int SQL_READ_ONLY = 240;
    static final int SQL_WRITE_CAPABLE = 241;
    static final int SQL_READ_WRITE_UNKNOWN = 242;
    private String catalog_;
    private int concurrency_;
    private String cursorName_;
    private JDRow row_;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_;
    private ConvTable convTable_;
    private AS400JDBCConnection con_;
    SQLConversionSettings settings_;

    AS400JDBCResultSetMetaData(String catalog, int concurrency, String cursorName, JDRow row, DBExtendedColumnDescriptors extendedColumnDescriptors, ConvTable convTable, AS400JDBCConnection con) throws SQLException {
        this.catalog_ = catalog;
        this.concurrency_ = concurrency;
        this.cursorName_ = cursorName;
        this.row_ = row;
        this.extendedColumnDescriptors_ = extendedColumnDescriptors;
        this.convTable_ = convTable;
        this.con_ = con;
        this.settings_ = SQLConversionSettings.getConversionSettings(this.con_);
    }

    private void checkIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            JDError.throwSQLException((Object)this, "07009", columnIndex + "<1");
        }
        if (columnIndex > this.row_.getFieldCount()) {
            JDError.throwSQLException((Object)this, "07009", columnIndex + ">" + this.row_.getFieldCount());
        }
    }

    public String getCatalogName(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.catalog_;
    }

    public String getColumnClassName(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        SQLData sqlData = this.row_.getSQLType(columnIndex);
        String className = sqlData.getObject().getClass().getName();
        return className;
    }

    public int getColumnCount() throws SQLException {
        return this.row_.getFieldCount();
    }

    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLType(columnIndex).getDisplaySize();
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        String columnLabel;
        DBColumnDescriptorsDataFormat dataFormat;
        this.checkIndex(columnIndex);
        if (this.extendedColumnDescriptors_ != null && (dataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(columnIndex, this.convTable_, this.settings_)) != null && (columnLabel = dataFormat.getColumnLabel(this.convTable_)) != null && columnLabel.length() > 0) {
            return columnLabel;
        }
        return this.row_.getFieldName(columnIndex);
    }

    public String getColumnName(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        String columnName = this.row_.getFieldName(columnIndex);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getColumnName(" + columnIndex + ") returned " + columnName);
        }
        return columnName;
    }

    public int getColumnType(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLType(columnIndex).getType();
    }

    public int getColumnCCSID(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getCCSID(columnIndex);
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLTypeName(columnIndex);
    }

    public int getPrecision(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLType(columnIndex).getPrecision();
    }

    public int getScale(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLType(columnIndex).getScale();
    }

    public String getSchemaName(int columnIndex) throws SQLException {
        DBColumnDescriptorsDataFormat dataFormat;
        this.checkIndex(columnIndex);
        if (this.extendedColumnDescriptors_ != null && (dataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(columnIndex, this.convTable_, this.settings_)) != null) {
            return dataFormat.getBaseTableSchemaName(this.convTable_);
        }
        return "";
    }

    public String getTableName(int columnIndex) throws SQLException {
        DBColumnDescriptorsDataFormat dataFormat;
        this.checkIndex(columnIndex);
        if (this.extendedColumnDescriptors_ != null && (dataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(columnIndex, this.convTable_, this.settings_)) != null) {
            return dataFormat.getBaseTableName(this.convTable_);
        }
        return "";
    }

    /*
     * Loose catch block
     */
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        ResultSet rs;
        Statement ps;
        block15: {
            this.checkIndex(columnIndex);
            String tableName = this.getTableName(columnIndex);
            if (tableName == null || tableName.length() == 0) {
                return false;
            }
            ps = null;
            rs = null;
            ps = this.con_.prepareStatement("SELECT identity_generation FROM QSYS2" + this.getCatalogSeparator() + "SYSCOLUMNS" + " WHERE identity_generation is not null" + " AND column_name = ?" + " AND table_name = ?" + " AND table_schema = ?");
            ps.setString(1, this.getColumnName(columnIndex));
            ps.setString(2, tableName);
            ps.setString(3, this.getSchemaName(columnIndex));
            rs = ps.executeQuery();
            if (!rs.next()) break block15;
            boolean bl = true;
            Object var7_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e2) {
                JDTrace.logException(this, "isAutoIncrement rs.close()", e2);
            }
            if (ps != null) {
                ps.close();
            }
            return bl;
        }
        boolean bl = false;
        Object var7_9 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e2) {
            JDTrace.logException(this, "isAutoIncrement rs.close()", e2);
        }
        if (ps != null) {
            ps.close();
        }
        return bl;
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var7_10 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e2) {
                        JDTrace.logException(this, "isAutoIncrement rs.close()", e2);
                    }
                    if (ps == null) break block18;
                    ps.close();
                }
                throw throwable;
            }
        }
    }

    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLType(columnIndex).isText();
    }

    public boolean isCurrency(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return false;
    }

    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return false;
    }

    public int isNullable(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.isNullable(columnIndex);
    }

    public boolean isReadOnly(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.extendedColumnDescriptors_ != null) {
            return this.extendedColumnDescriptors_.getUpdateable(columnIndex) == -16;
        }
        return this.concurrency_ == 1007;
    }

    public boolean isSearchable(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.extendedColumnDescriptors_ != null) {
            return this.extendedColumnDescriptors_.getSearchable(columnIndex) != -16;
        }
        return true;
    }

    public boolean isSigned(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.row_.getSQLType(columnIndex).isSigned();
    }

    public boolean isWritable(int columnIndex) throws SQLException {
        return !this.isReadOnly(columnIndex);
    }

    public String toString() {
        return this.cursorName_;
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCResultSetMetaData", "java.sql.ResultSetMetaData"};
    }

    private String getCatalogSeparator() throws SQLException {
        String catalogSeparator = this.con_.getProperties().equals(9, "sql") ? "." : "/";
        return catalogSeparator;
    }
}

