/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

class AS400JDBCWriter
extends Writer {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private long position_;
    private AS400JDBCClob clob_;
    private AS400JDBCClobLocator locator_;
    private AS400JDBCSQLXML xml_;

    AS400JDBCWriter(AS400JDBCClob clob, long positionToStartWriting) {
        this.clob_ = clob;
        this.position_ = positionToStartWriting;
    }

    AS400JDBCWriter(AS400JDBCClobLocator locator, long positionToStartWriting) {
        this.locator_ = locator;
        this.position_ = positionToStartWriting;
    }

    AS400JDBCWriter(AS400JDBCSQLXML xml, long positionToStartWriting) {
        this.xml_ = xml;
        this.position_ = positionToStartWriting;
    }

    public void close() {
        this.closed_ = true;
    }

    public void flush() {
    }

    public void write(char[] cbuf) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf");
        }
        if (off < 0 || off > len) {
            throw new ExtendedIllegalArgumentException("off", 2);
        }
        if (len < 0) {
            throw new ExtendedIllegalArgumentException("len", 2);
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(new String(cbuf, off, len));
    }

    public void write(int c) throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(new String(new char[]{(char)c}));
    }

    public void write(String str) throws IOException {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(str, 0, str.length());
    }

    public synchronized void write(String str, int off, int len) throws IOException {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (off < 0 || off > len) {
            throw new ExtendedIllegalArgumentException("off", 2);
        }
        if (len < 0) {
            throw new ExtendedIllegalArgumentException("len", 2);
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        try {
            if (this.clob_ != null) {
                this.clob_.setString(this.position_, str, off, len);
            } else if (this.locator_ != null) {
                this.locator_.setString(this.position_, str, off, len);
            } else if (this.xml_ != null) {
                this.xml_.setString(this.position_, str, off, len);
            }
            this.position_ += (long)len;
        }
        catch (SQLException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(this, "Exception caught", e);
            }
            this.closed_ = true;
            IOException throwException = new IOException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }
}

