/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConnectionPoolEventSupport;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ConnectionPoolListener;
import com.ibm.as400.access.ConnectionPoolProperties;
import com.ibm.as400.access.PoolMaintenance;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class ConnectionPool
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int CCSID_DEFAULT = -1;
    ConnectionPoolProperties properties_ = new ConnectionPoolProperties();
    private boolean inUse_ = false;
    private boolean isRunMaintenance_ = true;
    transient PoolMaintenance maintenance_;
    transient PropertyChangeSupport changes_;
    transient ConnectionPoolEventSupport poolListeners_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionPoolListener(ConnectionPoolListener listener) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.poolListeners_ == null) {
                this.poolListeners_ = new ConnectionPoolEventSupport();
            }
        }
        this.poolListeners_.addConnectionPoolListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(listener);
            this.properties_.addPropertyChangeListener(listener);
        }
    }

    abstract void cleanupConnections();

    public abstract void close() throws ConnectionPoolException;

    protected void finalize() throws Throwable {
        if (this.maintenance_ != null && this.maintenance_.isAlive()) {
            this.maintenance_.shutdown();
        }
        super.finalize();
    }

    int getCCSID() {
        return this.properties_.getCCSID();
    }

    public long getCleanupInterval() {
        return this.properties_.getCleanupInterval();
    }

    public int getMaxConnections() {
        return this.properties_.getMaxConnections();
    }

    public long getMaxInactivity() {
        return this.properties_.getMaxInactivity();
    }

    public long getMaxLifetime() {
        return this.properties_.getMaxLifetime();
    }

    public int getMaxUseCount() {
        return this.properties_.getMaxUseCount();
    }

    public long getMaxUseTime() {
        return this.properties_.getMaxUseTime();
    }

    private void initializeTransient() {
    }

    synchronized boolean isInUse() {
        return this.inUse_;
    }

    public boolean isPretestConnections() {
        return this.properties_.isPretestConnections();
    }

    public boolean isRunMaintenance() {
        return this.isRunMaintenance_;
    }

    public boolean isThreadUsed() {
        return this.properties_.isThreadUsed();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
        this.properties_.removePropertyChangeListener(listener);
    }

    public void removeConnectionPoolListener(ConnectionPoolListener listener) {
        if (this.poolListeners_ != null) {
            this.poolListeners_.removeConnectionPoolListener(listener);
        }
    }

    abstract void runMaintenance(boolean var1);

    void setCCSID(int ccsid) {
        this.properties_.setCCSID(ccsid);
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.properties_.setCleanupInterval(cleanupInterval);
        this.runMaintenance(false);
        if (cleanupInterval == 0L) {
            this.setRunMaintenance(false);
        }
    }

    synchronized void setInUse(boolean inUse) {
        this.inUse_ = inUse;
    }

    public void setMaxConnections(int maxConnections) {
        int oldValue = this.getMaxConnections();
        this.properties_.setMaxConnections(maxConnections);
        boolean reduced = oldValue == -1 || oldValue > maxConnections;
        this.runMaintenance(reduced);
    }

    public void setMaxInactivity(long maxInactivity) {
        this.properties_.setMaxInactivity(maxInactivity);
    }

    public void setMaxLifetime(long maxLifetime) {
        this.properties_.setMaxLifetime(maxLifetime);
    }

    public void setMaxUseCount(int maxUseCount) {
        this.properties_.setMaxUseCount(maxUseCount);
    }

    public void setMaxUseTime(long maxUseTime) {
        this.properties_.setMaxUseTime(maxUseTime);
    }

    public void setPretestConnections(boolean pretest) {
        this.properties_.setPretestConnections(pretest);
    }

    public void setRunMaintenance(boolean cleanup) {
        String property = "runMaintenance";
        boolean oldValue = this.isRunMaintenance_;
        this.isRunMaintenance_ = cleanup;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, new Boolean(oldValue), new Boolean(cleanup));
        }
        if (this.maintenance_ != null) {
            this.maintenance_.setRunning(cleanup);
        }
    }

    public void setThreadUsed(boolean useThreads) {
        this.properties_.setThreadUsed(useThreads, this.isInUse());
    }
}

