/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;

class ConvTable1202
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    ConvTable1202() {
        super(1202);
    }

    String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length / 2];
        for (int i = 0; i < length / 2; ++i) {
            dest[i] = (char)(((0xFF & buf[i * 2 + 1 + offset]) << 8) + (0xFF & buf[i * 2 + offset]));
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest);
    }

    byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        char[] src = source.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.encoding_, ConvTable.dumpCharArray(src));
        }
        byte[] dest = new byte[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            dest[i * 2 + 1] = (byte)(src[i] >>> 8);
            dest[i * 2] = (byte)(0xFF & src[i]);
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, dest);
        }
        return dest;
    }
}

