/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableInputStream;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ConvTableJavaMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    InputStreamReader reader_;
    OutputStreamWriter writer_;
    ByteArrayOutputStream outBuffer_;
    ConvTableInputStream inBuffer_;

    ConvTableJavaMap(String encoding) throws UnsupportedEncodingException {
        super(0);
        this.encoding_ = encoding;
        String ccsid = ConversionMaps.encodingToCcsidString(encoding);
        try {
            this.ccsid_ = new Integer(ccsid);
        }
        catch (Exception e) {
            if (Trace.traceConversion_) {
                Trace.log(5, "No associated CCSID for encoding '" + encoding + "'. Lookup returned " + ccsid + ".");
            }
            this.ccsid_ = 0;
        }
        this.inBuffer_ = new ConvTableInputStream();
        this.outBuffer_ = new ByteArrayOutputStream();
        this.writer_ = new OutputStreamWriter((OutputStream)this.outBuffer_, this.encoding_);
        this.reader_ = new InputStreamReader((InputStream)this.inBuffer_, this.encoding_);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded Java map for encoding: " + this.encoding_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for encoding: " + this.encoding_, buf, offset, length);
        }
        char[] dest = new char[length];
        int count = 0;
        ConvTableInputStream convTableInputStream = this.inBuffer_;
        synchronized (convTableInputStream) {
            block8: {
                this.inBuffer_.setContents(buf, offset, length);
                try {
                    if (this.reader_ == null) {
                        this.reader_ = new InputStreamReader((InputStream)this.inBuffer_, this.encoding_);
                    }
                    count = this.reader_.read(dest);
                }
                catch (IOException e) {
                    if (!Trace.traceConversion_) break block8;
                    Trace.log(2, "IOException occurred on byteArrayToString for encoding " + this.encoding_, (Throwable)e);
                }
            }
            this.reader_ = null;
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for encoding: " + this.encoding_ + " (" + count + ")", ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest, 0, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for encoding: " + this.encoding_, ConvTable.dumpCharArray(source.toCharArray()));
        }
        byte[] ret = null;
        ByteArrayOutputStream byteArrayOutputStream = this.outBuffer_;
        synchronized (byteArrayOutputStream) {
            block8: {
                try {
                    this.outBuffer_.reset();
                    if (this.writer_ == null) {
                        this.writer_ = new OutputStreamWriter((OutputStream)this.outBuffer_, this.encoding_);
                    }
                    this.writer_.write(source);
                    this.writer_.flush();
                }
                catch (IOException e) {
                    if (!Trace.traceConversion_) break block8;
                    Trace.log(2, "IOException occurred on stringToByteArray for encoding " + this.encoding_, (Throwable)e);
                }
            }
            this.writer_ = null;
            ret = this.outBuffer_.toByteArray();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for encoding: " + this.encoding_, ret);
        }
        return ret;
    }
}

