/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ConvTableWriter
extends OutputStreamWriter {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private BufferedOutputStream os_ = null;
    private int ccsid_ = -1;
    private ConvTable table_ = null;
    private BidiConversionProperties properties_ = new BidiConversionProperties();
    private boolean isMixedByte_ = false;
    private char[] cache_ = new char[1024];
    private boolean isCachedByte_ = false;
    private byte cachedByte_ = 0;
    private int nextWrite_ = 0;

    public ConvTableWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out);
        this.os_ = new BufferedOutputStream(out);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
        this.os_ = new BufferedOutputStream(out);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream out, int ccsid) throws UnsupportedEncodingException {
        super(out);
        if (ccsid < 0 || ccsid > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", ccsid);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.os_ = new BufferedOutputStream(out);
        this.ccsid_ = ccsid;
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream out, int ccsid, int bidiStringType) throws UnsupportedEncodingException {
        this(out, ccsid, new BidiConversionProperties(bidiStringType));
    }

    public ConvTableWriter(OutputStream out, int ccsid, BidiConversionProperties properties) throws UnsupportedEncodingException {
        super(out);
        if (ccsid < 0 || ccsid > 65535) {
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.os_ = new BufferedOutputStream(out);
        this.ccsid_ = ccsid;
        this.properties_ = properties;
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream out, int ccsid, int bidiStringType, int cacheSize) throws UnsupportedEncodingException {
        this(out, ccsid, bidiStringType);
        if (cacheSize < 1) {
            throw new ExtendedIllegalArgumentException("cacheSize", 4);
        }
        this.cache_ = new char[cacheSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            if (this.nextWrite_ == this.cache_.length) {
                this.flush();
            }
            this.cache_[this.nextWrite_++] = c;
            if (Trace.traceOn_) {
                Trace.log(5, "Added to ConvTableWriter(" + this.toString() + ") cache: " + c + "," + this.nextWrite_ + "," + this.cache_.length, ConvTable.dumpCharArray(this.cache_, this.nextWrite_));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(char[] c, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            int reps = len / this.cache_.length;
            for (int i = 0; i < reps; ++i) {
                this.flush();
                System.arraycopy(c, off + i * this.cache_.length, this.cache_, 0, this.cache_.length);
                this.nextWrite_ = this.cache_.length;
            }
            int leftover = len % this.cache_.length;
            this.flush();
            System.arraycopy(c, off + reps * this.cache_.length, this.cache_, 0, leftover);
            this.nextWrite_ = leftover;
            if (Trace.traceOn_) {
                Trace.log(5, "Added to ConvTableWriter(" + this.toString() + ") cache: " + off + "," + len + "," + this.nextWrite_ + "," + this.cache_.length, ConvTable.dumpCharArray(this.cache_, this.nextWrite_));
            }
        }
    }

    private void checkOpen() throws IOException {
        if (this.table_ == null) {
            super.flush();
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.table_ == null) {
                return;
            }
            this.flush();
            if (this.isCachedByte_) {
                this.os_.write(this.cachedByte_);
                this.os_.flush();
            }
            this.table_ = null;
            this.cache_ = null;
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (Trace.traceOn_) {
                Trace.log(5, "Flushing cache for ConvTableWriter(" + this.toString() + ") with size " + this.nextWrite_ + ".");
            }
            if (this.nextWrite_ > 0 && this.table_ != null) {
                String s = new String(this.cache_, 0, this.nextWrite_);
                this.nextWrite_ = 0;
                byte[] b = this.table_.stringToByteArray(s, this.properties_);
                if (this.isMixedByte_) {
                    if (this.cachedByte_ == 15 && b[0] == 14) {
                        this.os_.write(b, 1, b.length - 2);
                        this.cachedByte_ = b[b.length - 1];
                        this.isCachedByte_ = true;
                    } else {
                        if (this.isCachedByte_) {
                            this.os_.write(this.cachedByte_);
                        }
                        this.os_.write(b, 0, b.length - 1);
                        this.cachedByte_ = b[b.length - 1];
                        this.isCachedByte_ = true;
                    }
                } else {
                    this.os_.write(b);
                }
                this.os_.flush();
            }
            super.flush();
        }
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public String getEncoding() {
        if (this.ccsid_ == -1) {
            return super.getEncoding();
        }
        return ConversionMaps.ccsidToEncoding(this.ccsid_);
    }

    private void initializeCcsid() {
        String ccsidStr;
        String enc = super.getEncoding();
        if (enc != null && (ccsidStr = ConversionMaps.encodingToCcsidString(enc)) != null) {
            this.ccsid_ = Integer.parseInt(ccsidStr);
        }
    }

    private void initializeTable() throws UnsupportedEncodingException {
        try {
            this.table_ = this.ccsid_ == -1 ? ConvTable.getTable(this.getEncoding()) : ConvTable.getTable(this.ccsid_, null);
            if (this.table_ instanceof ConvTableMixedMap) {
                this.isMixedByte_ = true;
            }
            if (Trace.traceOn_) {
                Trace.log(5, "ConvTableWriter initialized with CCSID " + this.ccsid_ + ", encoding " + this.getEncoding() + ", string type " + this.properties_.getBidiStringType() + ", and table type " + this.isMixedByte_ + ".");
            }
        }
        catch (UnsupportedEncodingException uee) {
            if (Trace.traceOn_) {
                Trace.log(2, "The specified CCSID is not supported in the current JVM nor by the Toolbox: " + this.ccsid_ + "/" + this.getEncoding(), (Throwable)uee);
            }
            throw uee;
        }
    }

    public void write(int c) throws IOException {
        this.addToCache((char)c);
    }

    public void write(char[] buffer) throws IOException {
        if (buffer == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        this.addToCache(buffer, 0, buffer.length);
    }

    public void write(char[] buffer, int offset, int length) throws IOException {
        if (buffer == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (length == 0) {
            return;
        }
        if (offset < 0 || offset >= buffer.length) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", offset);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (length < 0 || length > buffer.length) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        this.addToCache(buffer, offset, length);
    }

    public void write(String data) throws IOException {
        if (data == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        this.addToCache(data.toCharArray(), 0, data.toCharArray().length);
    }

    public void write(String data, int offset, int length) throws IOException {
        if (data == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        if (length == 0) {
            return;
        }
        if (offset < 0 || offset >= data.length()) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", offset);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (length < 0 || length > data.length()) {
            Trace.log(2, "Value of parameter 'length' is not valid:", length);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        this.addToCache(data.toCharArray(), offset, length);
    }
}

