/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;

class DBExtendedData
implements DBData {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int actualLength_ = -1;
    private boolean dataCompressed_ = false;
    private boolean vlfCompressed_ = false;
    private int rowCount_ = -1;
    private int columnCount_ = -1;
    private int indicatorSize_ = -1;
    private int rowSize_ = -1;
    private int indicatorOffset_ = -1;
    private int dataOffset_ = -1;
    private int length_ = -1;
    private int offsetToRowInformationHeader_ = -1;
    private int offsetToRowInformationArray_ = -1;
    private int aliasCount_ = 0;

    public DBExtendedData(int actualLength, boolean dataCompressed) {
        this.actualLength_ = actualLength;
        this.dataCompressed_ = dataCompressed;
    }

    public DBExtendedData(int actualLength, boolean dataCompressed, boolean vlfCompressed) {
        this.actualLength_ = actualLength;
        this.dataCompressed_ = dataCompressed;
        this.vlfCompressed_ = vlfCompressed;
    }

    public DBExtendedData(int rowCount, int columnCount, int indicatorSize, int rowSize) throws DBDataStreamException {
        this.rowCount_ = rowCount;
        this.columnCount_ = columnCount;
        this.indicatorSize_ = indicatorSize;
        this.rowSize_ = rowSize;
        this.length_ = 20 + this.rowCount_ * (this.columnCount_ * this.indicatorSize_ + this.rowSize_);
    }

    public void overlay(byte[] rawBytes, int offset) {
        this.offset_ = offset;
        if (this.rowCount_ == -1) {
            this.rowCount_ = BinaryConverter.byteArrayToInt(rawBytes, this.offset_ + 4);
            this.columnCount_ = BinaryConverter.byteArrayToShort(rawBytes, this.offset_ + 8);
            this.indicatorSize_ = BinaryConverter.byteArrayToShort(rawBytes, this.offset_ + 10);
            this.rowSize_ = BinaryConverter.byteArrayToInt(rawBytes, this.offset_ + 16);
            this.length_ = 20 + this.rowCount_ * (this.columnCount_ * this.indicatorSize_ + this.rowSize_);
            if (this.dataCompressed_) {
                this.length_ += offset;
                byte[] decompressedBytes = new byte[this.length_];
                System.arraycopy(rawBytes, 0, decompressedBytes, 0, this.offset_ + 20);
                JDUtilities.decompress(rawBytes, this.offset_ + 20, this.actualLength_ - 26, decompressedBytes, this.offset_ + 20);
                this.rawBytes_ = decompressedBytes;
                this.indicatorOffset_ = this.offset_ + 20;
            } else {
                this.rawBytes_ = rawBytes;
                this.indicatorOffset_ = this.offset_ + 20;
            }
            if (this.vlfCompressed_) {
                this.offsetToRowInformationHeader_ = this.indicatorOffset_ + this.columnCount_ * this.rowCount_ * this.indicatorSize_;
                this.offsetToRowInformationArray_ = this.offsetToRowInformationHeader_ + BinaryConverter.byteArrayToInt(rawBytes, this.offsetToRowInformationHeader_);
            }
        } else {
            this.rawBytes_ = rawBytes;
            this.indicatorOffset_ = this.offset_ + 20;
            this.setRowCount(this.rowCount_);
            this.setColumnCount(this.columnCount_);
            this.setIndicatorSize(this.indicatorSize_);
            this.setRowSize(this.rowSize_);
            this.initializeReserved();
        }
        this.dataOffset_ = this.indicatorOffset_ + this.rowCount_ * this.columnCount_ * this.indicatorSize_;
    }

    public int getLength() {
        return this.length_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getRowCount() {
        return this.rowCount_;
    }

    public int getColumnCount() {
        return this.columnCount_;
    }

    public int getIndicatorSize() {
        return this.indicatorSize_;
    }

    public int getRowSize() {
        return this.rowSize_;
    }

    public int getIndicator(int rowIndex, int columnIndex) {
        if (this.indicatorSize_ == 0) {
            return 0;
        }
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffset_ + this.indicatorSize_ * ((rowIndex + this.aliasCount_) * this.columnCount_ + columnIndex));
    }

    public int getRawOffset() {
        return this.offset_;
    }

    public int getRowDataOffset(int rowIndex) {
        if (this.vlfCompressed_) {
            if (rowIndex >= this.rowCount_ || rowIndex < 0) {
                return -1;
            }
            return this.offsetToRowInformationHeader_ + BinaryConverter.byteArrayToInt(this.rawBytes_, this.offsetToRowInformationArray_ + rowIndex * 4);
        }
        return this.dataOffset_ + (rowIndex + this.aliasCount_) * this.rowSize_;
    }

    public byte[] getRawBytes() {
        return this.rawBytes_;
    }

    public void setConsistencyToken(int consistencyToken) {
        BinaryConverter.intToByteArray(consistencyToken, this.rawBytes_, this.offset_);
    }

    public void setParameterMarkerInputCompression(boolean b) {
        this.rawBytes_[this.offset_ + 12] = b ? -128 : 0;
    }

    public void initializeReserved() {
        BinaryConverter.intToByteArray(0, this.rawBytes_, this.offset_ + 12);
    }

    public void setRowCount(int rowCount) {
        BinaryConverter.intToByteArray(rowCount, this.rawBytes_, this.offset_ + 4);
    }

    public void setColumnCount(int columnCount) {
        BinaryConverter.shortToByteArray((short)columnCount, this.rawBytes_, this.offset_ + 8);
    }

    public void setIndicatorSize(int indicatorSize) {
        BinaryConverter.shortToByteArray((short)indicatorSize, this.rawBytes_, this.offset_ + 10);
    }

    public void setRowSize(int rowSize) {
        BinaryConverter.intToByteArray(rowSize, this.rawBytes_, this.offset_ + 16);
    }

    public void setIndicator(int rowIndex, int columnIndex, int indicator) {
        if (this.indicatorSize_ != 0) {
            BinaryConverter.shortToByteArray((short)indicator, this.rawBytes_, this.indicatorOffset_ + this.indicatorSize_ * (rowIndex * this.columnCount_ + columnIndex));
        }
    }

    public boolean isVariableFieldsCompressed() {
        return this.vlfCompressed_;
    }

    public void resetRowCount(int rowCount) {
        this.rowCount_ = rowCount;
    }

    public void setAliasCount(int aliases) {
        this.aliasCount_ = aliases;
    }

    public int getIndicator(int rowIndex, int columnIndex, int arrayIndex) {
        return -9999;
    }

    public int getDataTotalSize(int colIndex) {
        return -9999;
    }

    public void logInformation(String prefix) {
        JDTrace.logInformation(this, prefix + "offset_=" + this.offset_);
        JDTrace.logInformation(this, prefix + "actualLength_=" + this.actualLength_);
        JDTrace.logInformation(this, prefix + "dataCompressed_=" + this.dataCompressed_);
        JDTrace.logInformation(this, prefix + "vlfCompressed_=" + this.vlfCompressed_);
        JDTrace.logInformation(this, prefix + "rowCount_=" + this.rowCount_);
        JDTrace.logInformation(this, prefix + "columnCount_=" + this.columnCount_);
        JDTrace.logInformation(this, prefix + "indicatorSize_=" + this.indicatorSize_);
        JDTrace.logInformation(this, prefix + "rowSize_=" + this.rowSize_);
        JDTrace.logInformation(this, prefix + "indicatorOffset_=" + this.indicatorOffset_);
        JDTrace.logInformation(this, prefix + "dataOffset_=" + this.dataOffset_);
        JDTrace.logInformation(this, prefix + "length_=" + this.length_);
        JDTrace.logInformation(this, prefix + "offsetToRowInformationHeader_=" + this.offsetToRowInformationHeader_);
        JDTrace.logInformation(this, prefix + "offsetToRowInformationArray_=" + this.offsetToRowInformationArray_);
        JDTrace.logInformation(this, prefix + "aliasCount_=" + this.aliasCount_);
    }
}

