/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBOverlay;
import com.ibm.as400.access.JDUtilities;

class DBLobData
implements DBOverlay {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int actualLength_ = -1;
    private boolean dataCompressed_ = false;
    private int physicalLength_ = -1;

    public DBLobData(int actualLength, int physicalLength, boolean dataCompressed) {
        this.actualLength_ = actualLength;
        this.physicalLength_ = physicalLength;
        this.dataCompressed_ = dataCompressed;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void overlay(byte[] rawBytes, int offset) {
        this.offset_ = offset;
        if (this.dataCompressed_) {
            byte[] decompressedBytes = new byte[this.actualLength_];
            JDUtilities.decompress(rawBytes, this.offset_, this.physicalLength_, decompressedBytes, 0);
            this.offset_ = 0;
            this.rawBytes_ = decompressedBytes;
        } else {
            this.rawBytes_ = rawBytes;
        }
    }

    public int getLength() {
        return this.actualLength_;
    }

    public byte[] getRawBytes() {
        return this.rawBytes_;
    }

    void adjustForGraphic() {
        this.actualLength_ *= 2;
    }
}

