/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import java.io.CharConversionException;

class DBOriginalDataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int REPEATED_LENGTH_ = 54;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int length_ = -1;
    private boolean csRsData_ = false;

    public DBOriginalDataFormat() {
    }

    public DBOriginalDataFormat(int numberOfFields) {
        this.numberOfFields_ = numberOfFields;
        this.length_ = 8 + this.numberOfFields_ * 54;
    }

    public void overlay(byte[] rawBytes, int offset) {
        this.rawBytes_ = rawBytes;
        this.offset_ = offset;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToShort(this.rawBytes_, offset + 4);
            this.length_ = 8 + this.numberOfFields_ * 54;
        } else {
            this.setNumberOfFields(this.numberOfFields_);
        }
    }

    public int getLength() {
        return this.length_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    public int getRecordSize() {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 6);
    }

    public int getFieldSQLType(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 10 + fieldIndex * 54);
    }

    public int getFieldLength(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 12 + fieldIndex * 54);
    }

    public int getArrayFieldLength(int fieldIndex) throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 12 + fieldIndex * 54);
    }

    public int getFieldScale(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 14 + fieldIndex * 54);
    }

    public int getFieldPrecision(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + fieldIndex * 54);
    }

    public int getFieldCCSID(int fieldIndex) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 18 + fieldIndex * 54);
    }

    public int getFieldParameterType(int fieldIndex) {
        return this.rawBytes_[this.offset_ + 20 + fieldIndex * 54];
    }

    public int getFieldLOBLocator(int fieldIndex) {
        return -1;
    }

    public int getFieldLOBMaxSize(int fieldIndex) {
        return -1;
    }

    public int getFieldNameLength(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 28 + fieldIndex * 54);
    }

    public int getFieldNameCCSID(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 30 + fieldIndex * 54);
    }

    public String getFieldName(int fieldIndex, ConvTable converter) {
        return converter.byteArrayToString(this.rawBytes_, this.offset_ + 32 + fieldIndex * 54, this.getFieldNameLength(fieldIndex));
    }

    public void setConsistencyToken(int consistencyToken) {
        BinaryConverter.intToByteArray(consistencyToken, this.rawBytes_, this.offset_);
    }

    public void setNumberOfFields(int numberOfFields) {
        BinaryConverter.shortToByteArray((short)numberOfFields, this.rawBytes_, this.offset_ + 4);
    }

    public void setRecordSize(int recordSize) {
        BinaryConverter.shortToByteArray((short)recordSize, this.rawBytes_, this.offset_ + 6);
    }

    public void setFieldDescriptionLength(int fieldIndex) {
        BinaryConverter.shortToByteArray((short)54, this.rawBytes_, this.offset_ + fieldIndex * 54 + 8);
    }

    public void setFieldSQLType(int fieldIndex, int sqlType) {
        BinaryConverter.shortToByteArray((short)sqlType, this.rawBytes_, this.offset_ + fieldIndex * 54 + 10);
    }

    public void setFieldLength(int fieldIndex, int length) {
        BinaryConverter.shortToByteArray((short)length, this.rawBytes_, this.offset_ + fieldIndex * 54 + 12);
    }

    public void setFieldScale(int fieldIndex, int scale) {
        BinaryConverter.shortToByteArray((short)scale, this.rawBytes_, this.offset_ + fieldIndex * 54 + 14);
    }

    public void setFieldPrecision(int fieldIndex, int precision) {
        BinaryConverter.shortToByteArray((short)precision, this.rawBytes_, this.offset_ + fieldIndex * 54 + 16);
    }

    public void setFieldCCSID(int fieldIndex, int ccsid) {
        BinaryConverter.shortToByteArray((short)ccsid, this.rawBytes_, this.offset_ + fieldIndex * 54 + 18);
    }

    public void setFieldParameterType(int fieldIndex, int parameterType) {
        this.rawBytes_[this.offset_ + fieldIndex * 54 + 20] = (byte)parameterType;
    }

    public void setFieldNameLength(int fieldIndex, int nameLength) {
        BinaryConverter.shortToByteArray((short)nameLength, this.rawBytes_, this.offset_ + fieldIndex * 54 + 28);
    }

    public void setFieldNameCCSID(int fieldIndex, int nameCCSID) {
        BinaryConverter.shortToByteArray((short)nameCCSID, this.rawBytes_, this.offset_ + fieldIndex * 54 + 30);
    }

    public void setFieldName(int fieldIndex, String name, ConvTable converter) throws DBDataStreamException {
        try {
            converter.stringToByteArray(name, this.rawBytes_, this.offset_ + fieldIndex * 54 + 32);
        }
        catch (CharConversionException e) {
            throw new DBDataStreamException();
        }
        int length = name.length();
        int padOffset = this.offset_ + fieldIndex * 54 + 32;
        for (int i = length; i < 30; ++i) {
            this.rawBytes_[padOffset + i] = 0;
        }
    }

    public int getDateFormat() throws DBDataStreamException {
        return -1;
    }

    public int getTimeFormat() throws DBDataStreamException {
        return -1;
    }

    public int getDateSeparator() throws DBDataStreamException {
        return -1;
    }

    public int getTimeSeparator() throws DBDataStreamException {
        return -1;
    }

    public boolean getCSRSData() {
        return this.csRsData_;
    }

    public void setCSRSData(boolean csRsData) {
        this.csRsData_ = csRsData;
    }

    public int getXMLCharType(int fieldIndex) {
        return -1;
    }

    public int getArrayType(int fieldIndex) {
        return -1;
    }

    public int getUDTNameCCSID(int fieldIndex) throws DBDataStreamException {
        return -1;
    }

    public String getUDTName(int fieldIndex, ConvTable converter) throws DBDataStreamException {
        return null;
    }
}

