/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;

class DBSQLDADataFormat
implements DBDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int REPEATED_LENGTH_ = 80;
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int numberOfFields_ = -1;
    private int jobCCSID_;
    private int length_ = -1;
    private boolean csRsData_ = false;

    public DBSQLDADataFormat(int jobCCSID) {
        this.jobCCSID_ = jobCCSID;
    }

    public void overlay(byte[] rawBytes, int offset) {
        this.rawBytes_ = rawBytes;
        this.offset_ = offset;
        if (this.numberOfFields_ == -1) {
            this.numberOfFields_ = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 14);
        }
        this.length_ = 16 + this.numberOfFields_ * 80;
    }

    public int getLength() {
        return this.length_;
    }

    public int getConsistencyToken() {
        return -1;
    }

    public int getNumberOfFields() {
        return this.numberOfFields_;
    }

    public int getRecordSize() {
        int recordSize = 0;
        int numberOfFields = this.getNumberOfFields();
        for (int i = 0; i < numberOfFields; ++i) {
            recordSize += this.getFieldLength(i);
        }
        return recordSize;
    }

    public int getFieldSQLType(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 16 + fieldIndex * 80);
    }

    public int getArrayFieldLength(int fieldIndex) {
        return 0;
    }

    public int getFieldLength(int fieldIndex) {
        int fieldType = this.getFieldSQLType(fieldIndex) & 0xFFFE;
        int length = BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 18 + fieldIndex * 80);
        int precision = this.rawBytes_[this.offset_ + 18 + fieldIndex * 80];
        if (fieldType == 484) {
            length = precision / 2 + 1;
        } else if (fieldType == 488) {
            length = precision;
        } else if (fieldType == 464 || fieldType == 472 || fieldType == 468) {
            length *= 2;
        }
        if (this.isVarType(fieldIndex)) {
            length += 2;
        }
        return length;
    }

    public int getFieldScale(int fieldIndex) {
        int fieldType = this.getFieldSQLType(fieldIndex) & 0xFFFE;
        if (fieldType == 496 || fieldType == 500) {
            return 0;
        }
        return this.rawBytes_[this.offset_ + 19 + fieldIndex * 80];
    }

    public int getFieldPrecision(int fieldIndex) {
        int length = this.rawBytes_[this.offset_ + 18 + fieldIndex * 80];
        if (this.isVarType(fieldIndex)) {
            length += 2;
        }
        return length;
    }

    public int getFieldCCSID(int fieldIndex) {
        return BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.offset_ + 34 + fieldIndex * 80);
    }

    public int getFieldParameterType(int fieldIndex) throws DBDataStreamException {
        switch (this.rawBytes_[this.offset_ + 48 + 80 * fieldIndex]) {
            default: {
                return -16;
            }
            case -42: {
                return -15;
            }
            case -62: 
        }
        return -14;
    }

    public int getFieldLOBLocator(int fieldIndex) {
        return -1;
    }

    public int getFieldLOBMaxSize(int fieldIndex) {
        return -1;
    }

    public int getFieldNameLength(int fieldIndex) {
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.offset_ + 64 + fieldIndex * 80);
    }

    public int getFieldNameCCSID(int fieldIndex) {
        return this.jobCCSID_;
    }

    public String getFieldName(int fieldIndex, ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.rawBytes_, this.offset_ + 66 + fieldIndex * 80, this.getFieldNameLength(fieldIndex));
    }

    private boolean isVarType(int fieldIndex) {
        int type = this.getFieldSQLType(fieldIndex) & 0xFFFE;
        return type == 448 || type == 456 || type == 464 || type == 472 || type == 908;
    }

    public void setConsistencyToken(int consistencyToken) {
    }

    public void setNumberOfFields(int numberOfFields) {
        this.numberOfFields_ = numberOfFields;
    }

    public void setRecordSize(int recordSize) {
    }

    public void setFieldDescriptionLength(int fieldIndex) {
    }

    public void setFieldSQLType(int fieldIndex, int sqlType) {
    }

    public void setFieldLength(int fieldIndex, int length) {
    }

    public void setFieldScale(int fieldIndex, int scale) {
    }

    public void setFieldPrecision(int fieldIndex, int precision) {
    }

    public void setFieldCCSID(int fieldIndex, int ccsid) {
    }

    public void setFieldParameterType(int fieldIndex, int parameterType) {
    }

    public void setFieldNameLength(int fieldIndex, int nameLength) {
    }

    public void setFieldNameCCSID(int fieldIndex, int nameCCSID) {
    }

    public void setFieldName(int fieldIndex, String name, ConvTable converter) throws DBDataStreamException {
    }

    public int getDateFormat() throws DBDataStreamException {
        return -1;
    }

    public int getTimeFormat() throws DBDataStreamException {
        return -1;
    }

    public int getDateSeparator() throws DBDataStreamException {
        return -1;
    }

    public int getTimeSeparator() throws DBDataStreamException {
        return -1;
    }

    public boolean getCSRSData() {
        return this.csRsData_;
    }

    public void setCSRSData(boolean csRsData) {
        this.csRsData_ = csRsData;
    }

    public int getXMLCharType(int fieldIndex) {
        return -1;
    }

    public int getArrayType(int fieldIndex) {
        return -1;
    }

    public int getUDTNameCCSID(int fieldIndex) throws DBDataStreamException {
        return -1;
    }

    public String getUDTName(int fieldIndex, ConvTable converter) throws DBDataStreamException {
        return null;
    }
}

