/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDTrace;

class DBVariableData
implements DBData {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] rawBytes_ = null;
    private int headerCurOffsetToHost_ = -1;
    private int indicatorCurOffsetToHost_ = -1;
    private int dataCurOffsetToHost_ = -1;
    private int headerTotalSizeToHost_ = -1;
    private int indicatorTotalSizeToHost_ = -1;
    private int dataTotalSizeToHost_ = -1;
    private int offset_ = -1;
    private boolean vlfCompressed_ = false;
    private int rowCount_ = -1;
    private int columnCount_ = -1;
    private int indicatorSize_ = -1;
    private final int actual382fInArrayStart_ = 4;
    private final int actual3901OutArrayStart_ = 4;
    private int headerOffsetFromHost_ = -1;
    private int indicatorOffsetFromHost_ = -1;
    private int dataOffsetFromHost_ = -1;
    private int lengthFromHost_ = -1;
    private int[] indicatorOffsetsFromHost_ = null;
    private int[] dataOffsetsFromHost_ = null;
    private int[] indicatorCountsFromHost_ = null;
    private int[] totalDataLengthsFromHost_ = null;
    private int[] arrayDataLengthsFromHost_ = null;
    private int[] dataIsArrayFromHost_ = null;
    private int[] dataIsNullArrayFromHost_ = null;

    public DBVariableData() {
    }

    public DBVariableData(int columnCount, int indicatorSize, int headerTotalSize, int indicatorTotalSize, int dataTotalSize) throws DBDataStreamException {
        this.rowCount_ = 1;
        this.columnCount_ = columnCount;
        this.indicatorSize_ = 2;
        this.headerTotalSizeToHost_ = headerTotalSize;
        this.indicatorTotalSizeToHost_ = indicatorTotalSize;
        this.dataTotalSizeToHost_ = dataTotalSize;
    }

    public void overlay(byte[] rawBytes, int offset) {
        if (this.rowCount_ == -1) {
            this.offset_ = offset;
            this.lengthFromHost_ = 0;
            int headerLength = 0;
            this.columnCount_ = BinaryConverter.byteArrayToShort(rawBytes, this.offset_ + 4);
            this.rowCount_ = 1;
            this.indicatorSize_ = 2;
            this.indicatorOffsetsFromHost_ = new int[this.columnCount_];
            this.indicatorCountsFromHost_ = new int[this.columnCount_];
            this.dataOffsetsFromHost_ = new int[this.columnCount_];
            this.totalDataLengthsFromHost_ = new int[this.columnCount_];
            this.arrayDataLengthsFromHost_ = new int[this.columnCount_];
            this.dataIsArrayFromHost_ = new int[this.columnCount_];
            this.dataIsNullArrayFromHost_ = new int[this.columnCount_];
            int colDescs = this.offset_ + 4 + 2;
            int dataLenAll = 0;
            int indicatorLenAll = 0;
            for (int i = 0; i < this.columnCount_; ++i) {
                short descType = BinaryConverter.byteArrayToShort(rawBytes, colDescs);
                if (descType == -26351) {
                    boolean isNull = BinaryConverter.byteArrayToShort(rawBytes, colDescs + 2) == -1;
                    this.dataIsArrayFromHost_[i] = 1;
                    if (isNull) {
                        colDescs += 4;
                        this.indicatorOffsetsFromHost_[i] = i == 0 ? 0 : this.indicatorOffsetsFromHost_[i - 1] + this.indicatorCountsFromHost_[i - 1] * this.indicatorSize_;
                        this.indicatorCountsFromHost_[i] = 0;
                        this.dataOffsetsFromHost_[i] = i == 0 ? 0 : this.dataOffsetsFromHost_[i - 1];
                        this.totalDataLengthsFromHost_[i] = 0;
                        this.arrayDataLengthsFromHost_[i] = 0;
                        this.dataIsNullArrayFromHost_[i] = -1;
                        continue;
                    }
                    int dataLen = BinaryConverter.byteArrayToInt(rawBytes, colDescs + 4);
                    int arrayLen = BinaryConverter.byteArrayToInt(rawBytes, colDescs + 8);
                    dataLenAll += dataLen * arrayLen;
                    indicatorLenAll += this.indicatorSize_ * arrayLen;
                    this.indicatorOffsetsFromHost_[i] = i == 0 ? 0 : this.indicatorOffsetsFromHost_[i - 1] + this.indicatorCountsFromHost_[i - 1] * this.indicatorSize_;
                    this.indicatorCountsFromHost_[i] = arrayLen;
                    this.dataOffsetsFromHost_[i] = i == 0 ? 0 : this.dataOffsetsFromHost_[i - 1] + this.totalDataLengthsFromHost_[i - 1];
                    this.totalDataLengthsFromHost_[i] = arrayLen * dataLen;
                    this.arrayDataLengthsFromHost_[i] = dataLen;
                    colDescs += 12;
                    this.dataIsNullArrayFromHost_[i] = 0;
                    continue;
                }
                if (descType != -26350) continue;
                this.dataIsArrayFromHost_[i] = 0;
                int dataLen = BinaryConverter.byteArrayToInt(rawBytes, colDescs + 4);
                dataLenAll += dataLen;
                indicatorLenAll += this.indicatorSize_;
                this.indicatorOffsetsFromHost_[i] = i == 0 ? 0 : this.indicatorOffsetsFromHost_[i - 1] + this.indicatorCountsFromHost_[i - 1] * this.indicatorSize_;
                this.indicatorCountsFromHost_[i] = 1;
                this.dataOffsetsFromHost_[i] = i == 0 ? 0 : this.dataOffsetsFromHost_[i - 1] + this.totalDataLengthsFromHost_[i - 1];
                this.totalDataLengthsFromHost_[i] = dataLen;
                this.arrayDataLengthsFromHost_[i] = 0;
                colDescs += 8;
            }
            headerLength = colDescs - this.offset_;
            this.lengthFromHost_ = headerLength + indicatorLenAll + dataLenAll;
            this.rawBytes_ = rawBytes;
            this.headerOffsetFromHost_ = this.offset_;
            this.indicatorOffsetFromHost_ = this.offset_ + headerLength;
            this.dataOffsetFromHost_ = this.indicatorOffsetFromHost_ + indicatorLenAll;
        } else {
            this.rawBytes_ = rawBytes;
            this.offset_ = offset;
            this.headerCurOffsetToHost_ = this.offset_ + 4;
            this.setColumnCount(this.columnCount_);
            this.indicatorCurOffsetToHost_ = this.offset_ + 4 + this.headerTotalSizeToHost_;
            this.dataCurOffsetToHost_ = this.indicatorCurOffsetToHost_ + this.indicatorTotalSizeToHost_;
        }
    }

    public int getLength() {
        if (this.dataTotalSizeToHost_ == -1) {
            return this.lengthFromHost_;
        }
        return 4 + this.headerTotalSizeToHost_ + this.indicatorTotalSizeToHost_ + this.dataTotalSizeToHost_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getRowCount() {
        return this.rowCount_;
    }

    public int getColumnCount() {
        return this.columnCount_;
    }

    public int getIndicatorSize() {
        return this.indicatorSize_;
    }

    public int getRowSize() {
        return -1;
    }

    public int getIndicator(int rowIndex, int columnIndex) {
        return this.getIndicator(rowIndex, columnIndex, -1);
    }

    public int getRowDataOffset(int rowIndex) {
        if (this.dataCurOffsetToHost_ == -1) {
            return this.dataOffsetFromHost_;
        }
        return this.dataCurOffsetToHost_;
    }

    public byte[] getRawBytes() {
        return this.rawBytes_;
    }

    public void setConsistencyToken(int consistencyToken) {
        BinaryConverter.intToByteArray(consistencyToken, this.rawBytes_, this.offset_);
    }

    public void setRowCount(int rowCount) {
    }

    public void setColumnCount(int columnCount) {
        BinaryConverter.shortToByteArray((short)columnCount, this.rawBytes_, this.headerCurOffsetToHost_);
        this.headerCurOffsetToHost_ += 2;
    }

    public void setIndicatorSize(int indicatorSize) {
    }

    public void setRowSize(int rowSize) {
    }

    public void setHeaderColumnInfo(int columnIndex, short type, short indicatorValue, short elementDataType, int dataTypeSize, short arrayLength) {
        if (type == 10000) {
            if (indicatorValue == 0) {
                BinaryConverter.shortToByteArray((short)-26351, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
                BinaryConverter.shortToByteArray(elementDataType, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
                BinaryConverter.intToByteArray(dataTypeSize, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 4;
                BinaryConverter.intToByteArray(arrayLength, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 4;
            } else {
                BinaryConverter.shortToByteArray((short)-26351, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
                BinaryConverter.shortToByteArray(indicatorValue, this.rawBytes_, this.headerCurOffsetToHost_);
                this.headerCurOffsetToHost_ += 2;
            }
        } else {
            BinaryConverter.shortToByteArray((short)-26350, this.rawBytes_, this.headerCurOffsetToHost_);
            this.headerCurOffsetToHost_ += 2;
            BinaryConverter.shortToByteArray(type, this.rawBytes_, this.headerCurOffsetToHost_);
            this.headerCurOffsetToHost_ += 2;
            BinaryConverter.intToByteArray(dataTypeSize, this.rawBytes_, this.headerCurOffsetToHost_);
            this.headerCurOffsetToHost_ += 4;
        }
    }

    public void setIndicator(int rowIndex, int columnIndex, int indicator) {
        if (rowIndex == -1) {
            this.setHeaderColumnInfo(columnIndex, (short)10000, (short)-1, (short)0, 0, (short)0);
        } else {
            BinaryConverter.shortToByteArray((short)indicator, this.rawBytes_, this.indicatorCurOffsetToHost_);
            this.indicatorCurOffsetToHost_ += 2;
        }
    }

    public boolean isVariableFieldsCompressed() {
        return false;
    }

    public void resetRowCount(int rowCount) {
    }

    public void setAliasCount(int aliases) {
    }

    public int getIndicator(int rowIndex, int columnIndex, int arrayIndex) {
        if (arrayIndex == -1) {
            if (this.dataIsArrayFromHost_[columnIndex] == 0) {
                return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffsetFromHost_ + this.indicatorOffsetsFromHost_[columnIndex]);
            }
            return this.dataIsNullArrayFromHost_[columnIndex];
        }
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffsetFromHost_ + this.indicatorOffsetsFromHost_[columnIndex] + arrayIndex * this.indicatorSize_);
    }

    public int getDataTotalSize(int colIndex) {
        return this.totalDataLengthsFromHost_[colIndex];
    }

    public int[] getArrayDataLengthsFromHost() {
        return this.arrayDataLengthsFromHost_;
    }

    public int[] getDataLengthsFromHost() {
        return this.totalDataLengthsFromHost_;
    }

    public int[] getTotalDataLengthsFromHost() {
        return this.totalDataLengthsFromHost_;
    }

    public int[] getIndicatorCountsFromHost() {
        return this.indicatorCountsFromHost_;
    }

    public void logInformation(String prefix) {
        JDTrace.logInformation(this, prefix + "offset_=" + this.offset_);
        JDTrace.logInformation(this, prefix + "vlfCompressed_=" + this.vlfCompressed_);
        JDTrace.logInformation(this, prefix + "rowCount_=" + this.rowCount_);
        JDTrace.logInformation(this, prefix + "columnCount_=" + this.columnCount_);
        JDTrace.logInformation(this, prefix + "indicatorSize_=" + this.indicatorSize_);
        JDTrace.logInformation(this, prefix + "headerCurOffsetToHost_=" + this.headerCurOffsetToHost_);
        JDTrace.logInformation(this, prefix + "indicatorCurOffsetToHost_=" + this.indicatorCurOffsetToHost_);
        JDTrace.logInformation(this, prefix + "dataCurOffsetToHost_=" + this.dataCurOffsetToHost_);
        JDTrace.logInformation(this, prefix + "headerTotalSizeToHost_=" + this.headerTotalSizeToHost_);
        JDTrace.logInformation(this, prefix + "indicatorTotalSizeToHost_=" + this.indicatorTotalSizeToHost_);
        JDTrace.logInformation(this, prefix + "dataTotalSizeToHost_=" + this.dataTotalSizeToHost_);
        JDTrace.logInformation(this, prefix + "headerOffsetFromHost_=" + this.headerOffsetFromHost_);
        JDTrace.logInformation(this, prefix + "indicatorOffsetFromHost_=" + this.indicatorOffsetFromHost_);
        JDTrace.logInformation(this, prefix + "dataOffsetFromHost_=" + this.dataOffsetFromHost_);
        JDTrace.logInformation(this, prefix + "lengthFromHost_=" + this.lengthFromHost_);
    }
}

