/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DDMS38OpenFeedback;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

class DDMObjectDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";

    DDMObjectDataStream() {
    }

    DDMObjectDataStream(byte[] data) {
        super(data);
    }

    DDMObjectDataStream(int length) {
        super(length);
        this.setContinueOnError(false);
        this.setIsChained(false);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(false);
        this.setType(3);
    }

    public Object getNewDataStream() {
        return new DDMObjectDataStream();
    }

    public int hashCode() {
        return 3;
    }

    static DDMObjectDataStream[] getObjectS38BUF(Record[] records, DDMS38OpenFeedback openFeedback, boolean isSSPFile, int maxNumberOfFieldsPerFormatInFile) throws CharConversionException, UnsupportedEncodingException {
        RecordFormat format = records[0].getRecordFormat();
        int recordIncrement = openFeedback.getRecordIncrement();
        int blockingFactor = openFeedback.getMaxNumberOfRecordsTransferred();
        DDMObjectDataStream[] dataStreams = new DDMObjectDataStream[records.length / blockingFactor + (records.length % blockingFactor == 0 ? 0 : 1)];
        int recordIndex = 0;
        for (int dataStreamIndex = 0; dataStreamIndex < dataStreams.length; ++dataStreamIndex) {
            int endIndex = recordIndex + blockingFactor;
            if (endIndex > records.length) {
                endIndex = records.length;
            }
            int fourByteLength = 0;
            int recDataLength = recordIncrement * (endIndex - recordIndex);
            int recordOffset = 10;
            int dsLength = recDataLength + 10;
            int s38BUFLL = recDataLength + 4;
            if (recDataLength > 32757) {
                if (recDataLength > 32763) {
                    fourByteLength = recDataLength;
                    recDataLength -= 4;
                    dsLength += 4;
                    s38BUFLL = 32776;
                    recordOffset = 14;
                }
                recDataLength -= 32757;
            }
            dataStreams[dataStreamIndex] = new DDMObjectDataStream(dsLength);
            dataStreams[dataStreamIndex].set16bit(s38BUFLL, 6);
            dataStreams[dataStreamIndex].set16bit(54277, 8);
            if (fourByteLength != 0) {
                dataStreams[dataStreamIndex].set32bit(fourByteLength, 10);
            }
            while (recordIndex < endIndex) {
                byte[] recordData = records[recordIndex].getContents();
                System.arraycopy(recordData, 0, dataStreams[dataStreamIndex].data_, recordOffset, recordData.length);
                int numFields = records[recordIndex].getNumberOfFields();
                if (!isSSPFile) {
                    if (maxNumberOfFieldsPerFormatInFile == -1) {
                        maxNumberOfFieldsPerFormatInFile = numFields;
                    }
                    int fieldOffset = recordOffset + (recordIncrement - maxNumberOfFieldsPerFormatInFile);
                    for (int f = 0; f < numFields; ++f) {
                        dataStreams[dataStreamIndex].data_[fieldOffset] = records[recordIndex].isNullField(f) ? -15 : -16;
                        ++fieldOffset;
                    }
                }
                ++recordIndex;
                recordOffset += recordIncrement;
            }
        }
        return dataStreams;
    }
}

