/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ReturnCodeException;
import java.io.IOException;

public class ExtendedIOException
extends IOException
implements ReturnCodeException {
    static final long serialVersionUID = 4L;
    private int rc_;
    public static final int FILE_IN_USE = 1;
    public static final int FILE_NOT_FOUND = 2;
    public static final int PATH_NOT_FOUND = 3;
    public static final int DIR_ENTRY_EXISTS = 4;
    public static final int ACCESS_DENIED = 5;
    public static final int INVALID_HANDLE = 6;
    public static final int INVALID_DIR_ENTRY_NAME = 7;
    public static final int INVALID_ATTRIBUTE_NAME = 8;
    public static final int DIR_NOT_EMPTY = 9;
    public static final int FILE_SUBSTREAM_IN_USE = 10;
    public static final int RESOURCE_LIMIT_EXCEEDED = 11;
    public static final int RESOURCE_NOT_AVAILABLE = 12;
    public static final int REQUEST_DENIED = 13;
    public static final int DIR_ENTRY_DAMAGED = 14;
    public static final int INVALID_CONNECTION = 15;
    public static final int INVALID_REQUEST = 16;
    public static final int DATA_STREAM_SYNTAX_ERROR = 17;
    public static final int NO_MORE_FILES = 18;
    public static final int PARM_NOT_SUPPORTED = 19;
    public static final int PARM_VALUE_NOT_SUPPORTED = 20;
    public static final int CANNOT_CONVERT_VALUE = 21;
    public static final int END_OF_FILE = 22;
    public static final int REQUEST_NOT_SUPPORTED = 23;
    public static final int INVALID_USER = 24;
    public static final int UNKNOWN_ERROR = 25;
    public static final int SHARING_VIOLATION = 32;
    public static final int LOCK_VIOLATION = 33;
    public static final int STALE_HANDLE = 34;
    public static final int CERTIFICATE_NOT_FOUND = 40;
    public static final int CERTIFICATE_ALREADY_ADDED = 41;
    public static final int INVALID_CERTIFICATE = 42;

    ExtendedIOException(int returnCode) {
        super(ResourceBundleLoader.getText(ExtendedIOException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    ExtendedIOException(String objectName, int returnCode) {
        super(objectName + ": " + ResourceBundleLoader.getText(ExtendedIOException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    ExtendedIOException(String objectName, int returnCode, int errno) {
        super(objectName + ": " + ResourceBundleLoader.getText(ExtendedIOException.getMRIKey(returnCode)) + " (errno: " + errno + ")");
        this.rc_ = returnCode;
    }

    static String getMRIKey(int returnCode) {
        switch (returnCode) {
            case 5: {
                return "EXC_ACCESS_DENIED";
            }
            case 21: {
                return "EXC_VALUE_CANNOT_CONVERT";
            }
            case 41: {
                return "EXC_CERTIFICATE_ALREADY_ADDED";
            }
            case 40: {
                return "EXC_CERTIFICATE_NOT_FOUND";
            }
            case 17: {
                return "EXC_DATA_STREAM_SYNTAX_ERROR";
            }
            case 14: {
                return "EXC_DIRECTORY_ENTRY_DAMAGED";
            }
            case 4: {
                return "EXC_DIRECTORY_ENTRY_EXISTS";
            }
            case 9: {
                return "EXC_DIRECTORY_NOT_EMPTY";
            }
            case 22: {
                return "EXC_FILE_END";
            }
            case 1: {
                return "EXC_FILE_IN_USE";
            }
            case 2: {
                return "EXC_FILE_NOT_FOUND";
            }
            case 10: {
                return "EXC_FILE_SUBSTREAM_IN_USE";
            }
            case 8: {
                return "EXC_ATTRIBUTE_NOT_VALID";
            }
            case 42: {
                return "EXC_CERTIFICATE_NOT_VALID";
            }
            case 15: {
                return "EXC_CONNECTION_NOT_VALID";
            }
            case 7: {
                return "EXC_DIRECTORY_NAME_NOT_VALID";
            }
            case 6: {
                return "EXC_HANDLE_NOT_VALID";
            }
            case 16: {
                return "EXC_REQUEST_NOT_VALID";
            }
            case 24: {
                return "EXC_USERID_UNKNOWN";
            }
            case 33: {
                return "EXC_LOCK_VIOLATION";
            }
            case 18: {
                return "EXC_FILES_NOT_AVAILABLE";
            }
            case 19: {
                return "EXC_PARAMETER_NOT_SUPPORTED";
            }
            case 20: {
                return "EXC_PARAMETER_VALUE_NOT_SUPPORTED";
            }
            case 3: {
                return "EXC_PATH_NOT_FOUND";
            }
            case 13: {
                return "EXC_REQUEST_DENIED";
            }
            case 11: {
                return "EXC_RESOURCE_LIMIT_EXCEEDED";
            }
            case 12: {
                return "EXC_RESOURCE_NOT_AVAILABLE";
            }
            case 23: {
                return "EXC_REQUEST_NOT_SUPPORTED";
            }
            case 32: {
                return "EXC_SHARE_VIOLATION";
            }
            case 25: {
                return "EXC_UNKNOWN";
            }
        }
        return "EXC_UNKNOWN";
    }

    public int getReturnCode() {
        return this.rc_;
    }

    public String toString() {
        String returnString = super.toString() + " rc=" + this.rc_;
        return returnString;
    }
}

