/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStream;

class IFSExchangeAttrRep
extends IFSDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int DATA_STREAM_LEVEL_OFFSET = 22;
    private static final int MAX_DATA_BLOCK_OFFSET = 26;
    private static final int CCSID_LL_OFFSET = 30;
    private static final int CCSID_CP_OFFSET = 34;
    private static final int CCSID_OFFSET = 36;

    IFSExchangeAttrRep() {
    }

    public Object getNewDataStream() {
        return new IFSExchangeAttrRep();
    }

    int getDataStreamLevel() {
        return this.get16bit(22);
    }

    int getMaxDataBlockSize() {
        return this.get32bit(26);
    }

    int getPreferredCCSID() {
        return this.get16bit(36);
    }

    int[] getPreferredCCSIDs() {
        int llValue = this.get32bit(30);
        int count = (llValue - 6) / 2;
        int[] list = new int[count];
        int i = 0;
        int offset = 36;
        while (i < count) {
            list[i] = this.get16bit(offset);
            ++i;
            offset += 2;
        }
        return list;
    }

    public int hashCode() {
        return 32777;
    }
}

