/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileEvent;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileEnumeration;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IFSFile
implements Serializable,
Comparable {
    static final long serialVersionUID = 4L;
    public static final String pathSeparator = ";";
    public static final char pathSeparatorChar = ';';
    public static final String separator = "/";
    public static final char separatorChar = '/';
    private static final String DOT = ".";
    private static final String DOTDOT = "..";
    static final int ACCESS_EXECUTE = 1;
    static final int ACCESS_WRITE = 2;
    static final int ACCESS_READ = 4;
    public static final int PATTERN_POSIX = 0;
    static final int PATTERN_DEFAULT = 0;
    public static final int PATTERN_POSIX_ALL = 1;
    public static final int PATTERN_OS2 = 2;
    private static final String SECURITY_EXCEPTION = "Security exception.";
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector fileListeners_;
    private transient IFSFileImpl impl_;
    private transient ServiceProgramCall servicePgm_;
    private AS400 system_;
    private String path_ = "";
    private Permission permission_;
    private String subType_;
    private transient IFSCachedAttributes cachedAttributes_;
    private boolean isDirectory_;
    private boolean isFile_;
    private boolean isSymbolicLink_;
    private int patternMatching_;
    private boolean sortLists_;
    private int listFiles0LastNumObjsReturned_;
    private String listFiles0LastRestartName_ = null;
    private byte[] listFiles0LastRestartID_;

    public IFSFile() {
        this.initializeTransient();
    }

    public IFSFile(AS400 system, IFSFile directory, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.path_ = directory.getAbsolutePath();
        if (this.path_.charAt(this.path_.length() - 1) != '/') {
            this.path_ = this.path_ + separator;
        }
        this.path_ = this.path_ + name;
        this.system_ = system;
        this.permission_ = null;
    }

    public IFSFile(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.initializeTransient();
        this.path_ = path.length() == 0 || path.charAt(0) != '/' ? separator + path : path;
        this.system_ = system;
    }

    public IFSFile(AS400 system, String directory, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.path_ = directory.length() == 0 || directory.charAt(0) != '/' ? separator + directory : directory;
        if (this.path_.charAt(this.path_.length() - 1) != '/') {
            this.path_ = this.path_ + separator;
        }
        this.path_ = this.path_ + name;
        this.system_ = system;
    }

    public IFSFile(AS400 system, IFSJavaFile directory, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.path_ = directory.getAbsolutePath().replace(IFSJavaFile.separatorChar, '/');
        if (this.path_.charAt(this.path_.length() - 1) != '/') {
            this.path_ = this.path_ + separator;
        }
        this.path_ = this.path_ + name;
        this.system_ = system;
    }

    IFSFile(AS400 system, IFSCachedAttributes attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        this.initializeTransient();
        String directory = attributes.getParent();
        String name = attributes.getName();
        StringBuffer buff = new StringBuffer();
        if (directory.length() == 0 || directory.charAt(0) != '/') {
            buff.append(separator).append(directory);
        } else {
            buff.append(directory);
        }
        if (buff.toString().charAt(buff.toString().length() - 1) != '/') {
            buff.append(separator);
        }
        this.path_ = buff.append(name).toString();
        this.system_ = system;
        this.cachedAttributes_ = attributes;
        this.isDirectory_ = attributes.getIsDirectory();
        this.isFile_ = attributes.getIsFile();
        this.isSymbolicLink_ = attributes.isSymbolicLink();
    }

    public IFSFile(IFSFile directory, String name) {
        this(directory == null ? null : directory.getSystem(), directory == null ? null : directory.getPath(), name);
    }

    public void addFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public boolean canExecute() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.canExecute();
        }
        catch (AS400SecurityException e) {
            if (e.getReturnCode() == 1) {
                return false;
            }
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean canRead() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.canRead();
        }
        catch (AS400SecurityException e) {
            if (e.getReturnCode() == 1) {
                return false;
            }
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean canWrite() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.canWrite();
        }
        catch (AS400SecurityException e) {
            if (e.getReturnCode() == 1) {
                return false;
            }
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.path_.length() == 0) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.impl_ = (IFSFileImpl)this.system_.loadImpl2("com.ibm.as400.access.IFSFileImplRemote", "com.ibm.as400.access.IFSFileImplProxy");
            this.system_.connectService(0);
            this.impl_.setSystem(this.system_.getImpl());
            this.impl_.setPath(this.path_);
        }
    }

    public void clearCachedAttributes() {
        this.cachedAttributes_ = null;
        if (this.impl_ != null) {
            this.impl_.clearCachedAttributes();
        }
    }

    public int compareTo(Object obj) {
        if (obj instanceof IFSFile) {
            return this.getPath().compareTo(((IFSFile)obj).getPath());
        }
        return this.getPath().compareTo(((File)obj).getPath());
    }

    public boolean copyTo(String path) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        return this.copyTo(path, true);
    }

    boolean copyTo(String path, boolean replace) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.copyTo(path, replace);
    }

    public long created() throws IOException {
        try {
            if (this.cachedAttributes_ != null) {
                return this.cachedAttributes_.getCreationDate();
            }
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.created();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean createNewFile() throws IOException {
        int returnCode = 2;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            returnCode = this.impl_.createNewFile();
            switch (returnCode) {
                case 0: {
                    break;
                }
                case 4: {
                    if (Trace.traceOn_) {
                        Trace.log(1, "File already exists: " + this.path_);
                    }
                    break;
                }
                case 3: {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Path not found: " + this.path_);
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Return code " + returnCode + " from createNewFile().");
                    throw new ExtendedIOException(returnCode);
                }
            }
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int delete0() throws IOException, AS400SecurityException {
        int rc;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((rc = this.impl_.delete()) == 0) {
            if (this.fileListeners_.size() != 0) {
                FileEvent event = new FileEvent(this, 1);
                Vector vector = this.fileListeners_;
                synchronized (vector) {
                    Enumeration e = this.fileListeners_.elements();
                    while (e.hasMoreElements()) {
                        FileListener listener = (FileListener)e.nextElement();
                        listener.fileDeleted(event);
                    }
                }
            }
            this.cachedAttributes_ = null;
        }
        return rc;
    }

    public boolean delete() throws IOException {
        int returnCode = 2;
        try {
            returnCode = this.delete0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    public Enumeration enumerateFiles(IFSFileFilter filter, String pattern) throws IOException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return new IFSFileEnumeration(this, filter, pattern);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public Enumeration enumerateFiles(String pattern) throws IOException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return new IFSFileEnumeration(this, null, pattern);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public Enumeration enumerateFiles(IFSFileFilter filter) throws IOException {
        try {
            return new IFSFileEnumeration(this, filter, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public Enumeration enumerateFiles() throws IOException {
        try {
            return new IFSFileEnumeration(this, null, "*");
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IFSFile)) {
            return false;
        }
        IFSFile target = (IFSFile)obj;
        String targetPathName = target.getPath();
        AS400 targetSystem = target.getSystem();
        String targetSystemName = null;
        if (targetSystem != null) {
            targetSystemName = targetSystem.getSystemName();
        }
        boolean result = true;
        result = this.system_ == null ? targetSystemName == null : this.system_.getSystemName().equals(targetSystemName);
        result = result && this.path_.equals(targetPathName);
        return result;
    }

    int exists0() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.exists();
    }

    public boolean exists() throws IOException {
        int returnCode = 2;
        try {
            returnCode = this.exists0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    public String getAbsolutePath() {
        return this.path_;
    }

    public String getCanonicalPath() {
        StringBuffer pathBuffer = new StringBuffer("");
        if (Trace.isTraceOn()) {
            Trace.log(1, " path_='" + this.path_ + "'");
        }
        StringTokenizer st = new StringTokenizer(this.path_, separator);
        while (st.hasMoreTokens()) {
            String pathElem = st.nextToken();
            if (Trace.isTraceOn()) {
                Trace.log(1, " pathElem='" + pathElem + "'");
            }
            if (pathElem.length() == 0 || pathElem.equals(DOT)) continue;
            if (pathElem.equals(DOTDOT)) {
                int lastSepIndex = pathBuffer.lastIndexOf(separator);
                if (lastSepIndex == -1) continue;
                pathBuffer.delete(lastSepIndex, pathBuffer.length());
                continue;
            }
            pathBuffer.append(separator);
            pathBuffer.append(pathElem);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, " pathBuffer.toString()='" + pathBuffer.toString() + "'");
        }
        if (pathBuffer.length() == 0) {
            return separator;
        }
        return pathBuffer.toString();
    }

    public int getCCSID() throws IOException {
        int result = -1;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            result = this.isDirectory() && this.getSystem().getAuthenticationScheme() == 0 ? this.impl_.getCCSIDByUserHandle() : this.impl_.getCCSID();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return result;
    }

    public String getFileSystem() {
        return this.getPath();
    }

    public long getFreeSpace() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.getAvailableSpace(true);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public static long getFreeSpace(AS400 system) throws IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        try {
            IFSFileImpl impl = (IFSFileImpl)system.loadImpl2("com.ibm.as400.access.IFSFileImplRemote", "com.ibm.as400.access.IFSFileImplProxy");
            system.connectService(0);
            impl.setSystem(system.getImpl());
            impl.setPath(separator);
            return impl.getAvailableSpace(true);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(5);
        }
    }

    long getAvailableSpace(boolean forUserOnly) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getAvailableSpace(forUserOnly);
    }

    long getTotalSpace(boolean forUserOnly) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getTotalSpace(forUserOnly);
    }

    IFSFileImpl getImpl() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_;
    }

    int getListFiles0LastNumObjsReturned() {
        return this.listFiles0LastNumObjsReturned_;
    }

    String getListFiles0LastRestartName() {
        if (this.listFiles0LastRestartName_ == null) {
            return "";
        }
        return this.listFiles0LastRestartName_;
    }

    byte[] getListFiles0LastRestartID() {
        return this.listFiles0LastRestartID_;
    }

    public String getName() {
        int priorQuoteIndex;
        String name = null;
        int index = this.path_.lastIndexOf(47);
        name = index >= 0 ? (index < this.path_.length() - 1 ? this.path_.substring(index + 1) : "") : this.path_;
        int quoteIndex = name.indexOf(34);
        if (quoteIndex >= 0 && quoteIndex == name.lastIndexOf(34) && (priorQuoteIndex = this.path_.lastIndexOf(34, index)) >= 0) {
            int priorSeparatorIndex = this.path_.lastIndexOf(47, priorQuoteIndex);
            name = priorSeparatorIndex >= 0 ? this.path_.substring(priorSeparatorIndex + 1) : this.path_;
        }
        return name;
    }

    public String getOwnerName() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.isDirectory() && this.getSystem().getAuthenticationScheme() == 0) {
            return this.impl_.getOwnerNameByUserHandle();
        }
        return this.impl_.getOwnerName();
    }

    public long getOwnerUID() throws IOException {
        long result = -1L;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            result = this.impl_.getOwnerUID();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return result;
    }

    public int getOwnerId() throws IOException {
        int result = -1;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            result = (int)this.impl_.getOwnerUID();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return result;
    }

    public String getParent() {
        return IFSFile.getParent(this.path_);
    }

    static String getParent(String directory) {
        String parent = null;
        if (!directory.equals(separator)) {
            if (directory.length() == 0) {
                return null;
            }
            int index = directory.lastIndexOf(47);
            if (index <= 0) {
                parent = separator;
            } else {
                if (index == directory.length() - 1) {
                    return IFSFile.getParent(directory.substring(0, directory.length() - 1));
                }
                parent = directory.substring(0, index);
            }
        }
        return parent;
    }

    public IFSFile getParentFile() {
        String parentPath = this.getParent();
        if (parentPath == null) {
            return null;
        }
        if (this.system_ == null) {
            IFSFile parent = new IFSFile();
            try {
                parent.setPath(parentPath);
            }
            catch (PropertyVetoException e) {
                throw new InternalErrorException(10, (Throwable)e);
            }
            return parent;
        }
        return new IFSFile(this.system_, parentPath);
    }

    public String getPath() {
        return this.path_;
    }

    public String getPathPointedTo() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null && !this.isSymbolicLink_) {
            return null;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getPathPointedTo();
    }

    public int getPatternMatching() throws IOException {
        return this.patternMatching_;
    }

    public Permission getPermission() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException {
        if (this.permission_ == null) {
            this.permission_ = new Permission(this);
        }
        return this.permission_;
    }

    byte[] getRestartID() {
        if (this.cachedAttributes_ != null) {
            return this.cachedAttributes_.getRestartID();
        }
        if (Trace.traceOn_) {
            Trace.log(2, "IFSFile.getRestartID() was called when cachedAttributes_==null.");
        }
        return null;
    }

    public String getSubtype() throws IOException, AS400SecurityException {
        if (this.subType_ == null) {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            this.subType_ = this.impl_.getSubtype();
        }
        return this.subType_;
    }

    public boolean isSourcePhysicalFile() throws AS400Exception, AS400SecurityException, IOException {
        if (!this.path_.endsWith(".FILE") || this.path_.indexOf("/QSYS.LIB") == -1 || !this.getSubtype().equals("PF")) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not a physical file.");
            }
            return false;
        }
        return this.impl_.isSourcePhysicalFile();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public int getASP() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.getSystem().getAuthenticationScheme() == 0) {
            return this.impl_.getASP();
        }
        return -1;
    }

    public String getFileSystemType() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.getSystem().getAuthenticationScheme() == 0) {
            return this.impl_.getFileSystemType();
        }
        return "";
    }

    public int hashCode() {
        return this.path_.hashCode();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.cachedAttributes_ = null;
        this.impl_ = null;
    }

    public boolean isAbsolute() {
        if (this.path_.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        return this.path_.length() > 0 && this.path_.charAt(0) == '/';
    }

    int isDirectory0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            if (this.isDirectory_) {
                return 0;
            }
            return 2;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isDirectory();
    }

    public boolean isDirectory() throws IOException {
        int returnCode = 2;
        try {
            returnCode = this.isDirectory0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    int isFile0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            if (this.isFile_) {
                return 0;
            }
            return 2;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isFile();
    }

    public boolean isFile() throws IOException {
        int returnCode = 2;
        try {
            returnCode = this.isFile0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    public boolean isHidden() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return (this.cachedAttributes_.getFixedAttributes() & 2) != 0;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isHidden();
    }

    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return this.isSymbolicLink_;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isSymbolicLink();
    }

    public boolean isReadOnly() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return (this.cachedAttributes_.getFixedAttributes() & 1) != 0;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isReadOnly();
    }

    public boolean isSorted() throws IOException {
        return this.sortLists_;
    }

    public long lastAccessed() throws IOException {
        try {
            if (this.cachedAttributes_ != null) {
                return this.cachedAttributes_.getAccessDate();
            }
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.lastAccessed();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    long lastModified0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return this.cachedAttributes_.getModificationDate();
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.lastModified();
    }

    public long lastModified() throws IOException {
        try {
            return this.lastModified0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    long length0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return this.cachedAttributes_.getSize();
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.length();
    }

    public long length() throws IOException {
        try {
            return this.length0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public String[] list() throws IOException {
        return this.list("*");
    }

    public String[] list(IFSFileFilter filter) throws IOException {
        return this.list(filter, "*");
    }

    String[] list0(IFSFileFilter filter, String pattern) throws IOException, AS400SecurityException {
        String directory;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((directory = this.path_).lastIndexOf(47) != directory.length() - 1) {
            directory = directory + '/';
        }
        String[] allNames = this.impl_.listDirectoryContents(directory + pattern);
        String[] names = null;
        if (allNames != null) {
            names = new String[allNames.length];
            int j = 0;
            for (int i = 0; i < allNames.length; ++i) {
                String name = allNames[i];
                boolean addThisOne = false;
                if (name.equals(DOT) || name.equals(DOTDOT)) continue;
                addThisOne = false;
                if (filter == null) {
                    addThisOne = true;
                } else {
                    IFSFile file = new IFSFile(this.system_, directory, name);
                    if (filter.accept(file)) {
                        addThisOne = true;
                    }
                }
                if (!addThisOne) continue;
                names[j++] = name;
            }
            if (j == 0) {
                names = new String[]{};
            } else if (names.length != j) {
                String[] newNames = new String[j];
                System.arraycopy(names, 0, newNames, 0, j);
                names = newNames;
            }
        }
        return names;
    }

    public String[] list(IFSFileFilter filter, String pattern) throws IOException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.list0(filter, pattern);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public String[] list(String pattern) throws IOException {
        return this.list(null, pattern);
    }

    public IFSFile[] listFiles() throws IOException {
        return this.listFiles(null, "*");
    }

    public IFSFile[] listFiles(IFSFileFilter filter) throws IOException {
        return this.listFiles(filter, "*");
    }

    public IFSFile[] listFiles(IFSFileFilter filter, String pattern) throws IOException {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.listFiles0(filter, pattern, -1, null, null, true);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public IFSFile[] listFiles(String pattern) throws IOException {
        return this.listFiles(null, pattern);
    }

    IFSFile[] listFiles0(IFSFileFilter filter, String pattern, int maxGetCount, String restartName) throws IOException, AS400SecurityException {
        return this.listFiles0(filter, pattern, maxGetCount, restartName, null, true);
    }

    private IFSFile[] listFiles0(IFSFileFilter filter, String pattern, int maxGetCount, String restartName, byte[] restartID, boolean allowSortedRequests) throws IOException, AS400SecurityException {
        String directory;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((directory = this.path_).lastIndexOf(47) != directory.length() - 1) {
            directory = directory + '/';
        }
        IFSCachedAttributes[] fileAttributeList = restartName != null ? this.impl_.listDirectoryDetails(directory + pattern, directory, maxGetCount, restartName) : this.impl_.listDirectoryDetails(directory + pattern, directory, maxGetCount, restartID, allowSortedRequests);
        if (Trace.isTraceOn()) {
            Trace.log(1, "IFSFile::listFile0(): returned (" + this.listFiles0LastNumObjsReturned_ + ") pre objects");
        }
        if (fileAttributeList == null) {
            return new IFSFile[0];
        }
        this.listFiles0LastNumObjsReturned_ = fileAttributeList.length;
        IFSFile[] files = new IFSFile[fileAttributeList.length];
        if (fileAttributeList.length > 0) {
            IFSFile lastFile = new IFSFile(this.system_, fileAttributeList[fileAttributeList.length - 1]);
            this.listFiles0LastRestartName_ = lastFile.getName();
            this.listFiles0LastRestartID_ = lastFile.getRestartID();
        }
        int j = 0;
        for (int i = 0; i < fileAttributeList.length; ++i) {
            IFSFile file = new IFSFile(this.system_, fileAttributeList[i]);
            if (filter != null && !filter.accept(file)) continue;
            files[j++] = file;
        }
        if (j == 0) {
            files = new IFSFile[]{};
        } else if (files.length != j) {
            IFSFile[] newFiles = new IFSFile[j];
            System.arraycopy(files, 0, newFiles, 0, j);
            files = newFiles;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "IFSFile::listFile0(): returned (" + files.length + ") post objects");
        }
        return files;
    }

    IFSFile[] listFiles0(IFSFileFilter filter, String pattern, int maxGetCount, byte[] restartID) throws IOException, AS400SecurityException {
        return this.listFiles0(filter, pattern, maxGetCount, null, restartID, false);
    }

    IFSFile[] listFiles0(IFSFileFilter filter, String pattern) throws IOException, AS400SecurityException {
        return this.listFiles0(filter, pattern, -1, null, null, true);
    }

    int mkdir0(String directory) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.mkdir(directory);
    }

    public boolean mkdir() throws IOException {
        int returnCode = 2;
        try {
            returnCode = this.mkdir0(this.path_);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    int mkdirs0() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.mkdirs();
    }

    public boolean mkdirs() throws IOException {
        int returnCode = 2;
        try {
            returnCode = this.mkdirs0();
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initializeTransient();
    }

    public void removeFileListener(FileListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    int renameTo0(IFSFile file) throws IOException, PropertyVetoException, AS400SecurityException {
        String targetPath;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((targetPath = file.getAbsolutePath()).length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        this.vetos_.fireVetoableChange("path", this.path_, file.getAbsolutePath());
        int rc = this.impl_.renameTo(file.getImpl());
        if (rc == 0) {
            String oldPath = this.path_;
            this.path_ = file.getAbsolutePath();
            this.changes_.firePropertyChange("path", oldPath, this.path_);
            this.cachedAttributes_ = null;
        }
        return rc;
    }

    public boolean renameTo(IFSFile file) throws IOException, PropertyVetoException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        int returnCode = 2;
        try {
            returnCode = this.renameTo0(file);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        return returnCode == 0;
    }

    boolean setAccess(int accessType, boolean enableAccess, boolean ownerOnly) throws IOException, AS400SecurityException {
        if (accessType != 4 && accessType != 2 && accessType != 1) {
            throw new ExtendedIllegalArgumentException("accessType (" + accessType + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.setAccess(accessType, enableAccess, ownerOnly);
    }

    public boolean setCCSID(int ccsid) throws IOException {
        boolean success = false;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            success = this.impl_.setCCSID(ccsid);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
        if (success && this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
        return success;
    }

    boolean setFixedAttributes(int attributes) throws IOException {
        if ((attributes & 0xFFFFFF00) != 0) {
            throw new ExtendedIllegalArgumentException("attributes (" + attributes + ")", 2);
        }
        try {
            boolean success;
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            if (success = this.impl_.setFixedAttributes(attributes)) {
                this.cachedAttributes_ = null;
            }
            return success;
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean setHidden() throws IOException {
        return this.setHidden(true);
    }

    public boolean setHidden(boolean attribute) throws IOException {
        try {
            boolean success;
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            if (success = this.impl_.setHidden(attribute)) {
                this.cachedAttributes_ = null;
                if (this.fileListeners_.size() != 0) {
                    IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
                }
            }
            return success;
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean setLastModified(long time) throws IOException, PropertyVetoException {
        this.vetos_.fireVetoableChange("lastModified", null, new Long(time));
        try {
            return this.setLastModified0(time);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public void setLastModifiedV(long time) throws IOException, PropertyVetoException {
        this.setLastModified(time);
    }

    boolean setLastModified0(long time) throws IOException, AS400SecurityException {
        boolean success;
        if (time < -1L) {
            throw new ExtendedIllegalArgumentException("time (" + Long.toString(time) + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (success = this.impl_.setLastModified(time)) {
            this.changes_.firePropertyChange("lastModified", null, new Long(time));
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
            }
            this.cachedAttributes_ = null;
        }
        return success;
    }

    public boolean setLength(int length) throws IOException {
        try {
            return this.setLength0(length);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    boolean setLength0(int length) throws IOException, AS400SecurityException {
        boolean success;
        if (length < 0) {
            throw new ExtendedIllegalArgumentException("length (" + Integer.toString(length) + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (success = this.impl_.setLength(length)) {
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
            }
            this.cachedAttributes_ = null;
        }
        return success;
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String oldPath = this.path_;
        String newPath = path.length() == 0 || path.charAt(0) != '/' ? separator + path : path;
        this.vetos_.fireVetoableChange("path", oldPath, newPath);
        this.path_ = newPath;
        this.changes_.firePropertyChange("path", oldPath, newPath);
    }

    public void setPatternMatching(int patternMatching) throws IOException {
        if (patternMatching < 0 || patternMatching > 2) {
            throw new ExtendedIllegalArgumentException("patternMatching (" + patternMatching + ")", 2);
        }
        if (this.impl_ == null) {
            try {
                this.chooseImpl();
            }
            catch (AS400SecurityException e) {
                Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        this.impl_.setPatternMatching(patternMatching);
        this.patternMatching_ = patternMatching;
    }

    public void setPermission(Permission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, PropertyVetoException, UnknownHostException {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        AS400 system = permission.getSystem();
        if (system == null) {
            throw new ExtendedIllegalArgumentException("permission.system (null)", 2);
        }
        if (system.equals(this.system_)) {
            if (!this.getFileSystem().equals(permission.getObjectPath())) {
                throw new ExtendedIllegalArgumentException("permission.objectPath (" + permission.getObjectPath() + ")", 2);
            }
        } else {
            String systemName = system.getSystemName();
            throw new ExtendedIllegalArgumentException("permission.system (" + systemName + ")", 2);
        }
        this.vetos_.fireVetoableChange("permission", null, this.permission_);
        this.permission_ = permission;
        permission.commit();
        this.changes_.firePropertyChange("permission", null, this.permission_);
    }

    public boolean setReadOnly() throws IOException {
        return this.setReadOnly(true);
    }

    public boolean setReadOnly(boolean attribute) throws IOException {
        try {
            return this.setReadOnly0(attribute);
        }
        catch (AS400SecurityException e) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    boolean setReadOnly0(boolean attribute) throws IOException, AS400SecurityException {
        boolean success;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (success = this.impl_.setReadOnly(attribute)) {
            this.cachedAttributes_ = null;
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
            }
        }
        return success;
    }

    public void setSorted(boolean sort) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            try {
                this.chooseImpl();
            }
            catch (AS400SecurityException e) {
                Trace.log(2, SECURITY_EXCEPTION, (Throwable)e);
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        this.impl_.setSorted(sort);
        this.sortLists_ = sort;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.vetos_.fireVetoableChange("system", this.system_, system);
        AS400 oldSystem = this.system_;
        this.system_ = system;
        this.changes_.firePropertyChange("system", oldSystem, this.system_);
    }

    public String toString() {
        return this.path_;
    }
}

