/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class IFSFileEnumeration
implements Enumeration {
    private static final int MAXIMUM_GET_COUNT_ = 128;
    private IFSFile[] contents_;
    private IFSFile[] contentsPending_;
    private IFSFile file_;
    private IFSFileFilter filter_;
    private int index_;
    private String pattern_;
    private boolean isRestartByNameSupported_;

    IFSFileEnumeration(IFSFile file, IFSFileFilter filter, String pattern) throws AS400SecurityException, IOException {
        this.file_ = file;
        this.filter_ = filter;
        this.pattern_ = pattern;
        String path = this.file_.getPath().toUpperCase();
        int indexOfQSYS = path.indexOf("/QSYS.LIB");
        if (path.startsWith("/QSYS.LIB") || path.startsWith("/QDLS.LIB") || path.startsWith("/QDLS") || indexOfQSYS != -1 && indexOfQSYS <= 11) {
            this.isRestartByNameSupported_ = true;
            this.contentsPending_ = this.loadPendingBlock((String)null);
        } else {
            this.isRestartByNameSupported_ = false;
            this.contentsPending_ = this.loadPendingBlock((byte[])null);
        }
        this.getNextBlock();
    }

    public boolean hasMoreElements() {
        return this.contents_ != null && this.index_ < this.contents_.length || this.contentsPending_ != null;
    }

    private IFSFile[] loadPendingBlock(String restartName) throws AS400SecurityException, IOException {
        IFSFile[] block = null;
        do {
            block = this.file_.listFiles0(this.filter_, this.pattern_, 128, restartName);
            restartName = this.file_.getListFiles0LastRestartName();
        } while (block.length == 0 && this.file_.getListFiles0LastNumObjsReturned() > 0);
        if (block.length == 0) {
            block = null;
        }
        return block;
    }

    private IFSFile[] loadPendingBlock(byte[] restartID) throws AS400SecurityException, IOException {
        IFSFile[] block = null;
        do {
            block = this.file_.listFiles0(this.filter_, this.pattern_, 128, restartID);
            restartID = this.file_.getListFiles0LastRestartID();
        } while (block.length == 0 && this.file_.getListFiles0LastNumObjsReturned() > 0);
        if (block.length == 0) {
            block = null;
        }
        return block;
    }

    private void getNextBlock() throws AS400SecurityException, IOException {
        if (this.contentsPending_ == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "getNextBlock() was called when contentsPending_==null.");
            }
            return;
        }
        this.contents_ = this.contentsPending_;
        this.contentsPending_ = null;
        this.index_ = 0;
        if (this.file_.getListFiles0LastNumObjsReturned() != 0 && IFSFileEnumeration.isContainWildcard(this.pattern_)) {
            if (this.isRestartByNameSupported_) {
                this.contentsPending_ = this.loadPendingBlock(this.file_.getListFiles0LastRestartName());
            } else {
                byte[] restartID = this.file_.getListFiles0LastRestartID();
                if (IFSFileEnumeration.isAllZeros(restartID)) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "IFSFileEnumeration::getNextBlock(): A zero-valued restartID was returned.");
                    }
                    if (this.contents_ != null && this.contents_.length != 0) {
                        String restartName = this.contents_[this.contents_.length - 1].getName();
                        if (Trace.traceOn_) {
                            Trace.log(1, "IFSFileEnumeration::getNextBlock(): Specifying restartName '" + restartName + "' for next request.");
                        }
                        this.contentsPending_ = this.loadPendingBlock(restartName);
                        return;
                    }
                    if (Trace.traceOn_) {
                        Trace.log(1, "IFSFileEnumeration::getNextBlock(): No restartName available from prior reply.");
                    }
                }
                this.contentsPending_ = this.loadPendingBlock(restartID);
            }
        }
    }

    private static final boolean isAllZeros(byte[] arry) {
        if (arry == null || arry.length == 0) {
            return false;
        }
        for (int i = 0; i < arry.length; ++i) {
            if (arry[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isContainWildcard(String pattern) {
        if (pattern != null && pattern.length() > 0) {
            return pattern.indexOf("*") != -1 || pattern.indexOf("?") != -1;
        }
        return false;
    }

    public Object nextElement() {
        if (this.index_ < this.contents_.length) {
            return this.contents_[this.index_++];
        }
        if (this.contentsPending_ == null) {
            throw new NoSuchElementException();
        }
        try {
            this.getNextBlock();
        }
        catch (Exception e) {
            throw new NoSuchElementException();
        }
        return this.contents_[this.index_++];
    }
}

