/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileInputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSFileInputStreamImplProxy
extends AbstractProxyImpl
implements IFSFileInputStreamImpl {
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false};

    IFSFileInputStreamImplProxy() {
        super("IFSFileInputStream");
    }

    public int available() throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "available").getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void connectAndOpen() throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connectAndOpen");
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            if (e1 instanceof AS400SecurityException) {
                throw (AS400SecurityException)e1;
            }
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public IFSKey lock(long length) throws IOException {
        try {
            return (IFSKey)this.connection_.callMethod(this.pxId_, "lock", new Class[]{Long.TYPE}, new Object[]{new Long(length)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void open() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "open");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public int read(byte[] data, int dataOffset, int length) throws IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, new Integer(dataOffset), new Integer(length)}, ARGS_TO_RETURN, false);
            byte[] returnDataBuffer = (byte[])rv.getArgument(0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = returnDataBuffer[i];
            }
            return rv.getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public String readText(int length) throws IOException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "readText", new Class[]{Integer.TYPE}, new Object[]{new Integer(length)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void setFD(IFSFileDescriptorImpl fd) {
        try {
            this.connection_.callMethod(this.pxId_, "setFD", new Class[]{IFSFileDescriptorImpl.class}, new Object[]{fd});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public long skip(long bytesToSkip) throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "skip", new Class[]{Long.TYPE}, new Object[]{new Long(bytesToSkip)}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void unlock(IFSKey key) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "unlock", new Class[]{IFSKey.class}, new Object[]{key});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

