/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileOutputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.ProxyClientConnection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSFileOutputStreamImplProxy
extends AbstractProxyImpl
implements IFSFileOutputStreamImpl {
    IFSFileOutputStreamImplProxy() {
        super("IFSFileOutputStream");
    }

    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void connectAndOpen(int ccsid) throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connectAndOpen", new Class[]{Integer.TYPE}, new Object[]{new Integer(ccsid)});
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            if (e1 instanceof AS400SecurityException) {
                throw (AS400SecurityException)e1;
            }
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void flush() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "flush");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public IFSKey lock(long length) throws IOException {
        try {
            return (IFSKey)this.connection_.callMethod(this.pxId_, "lock", new Class[]{Long.TYPE}, new Object[]{new Long(length)}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void open(int fileDataCCSID) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "open", new Class[]{Integer.TYPE}, new Object[]{new Integer(fileDataCCSID)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void setAppend(boolean append) {
        try {
            this.connection_.callMethod(this.pxId_, "setAppend", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(append)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void setFD(IFSFileDescriptorImpl fd) {
        try {
            this.connection_.callMethod(this.pxId_, "setFD", new Class[]{IFSFileDescriptorImpl.class}, new Object[]{fd});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public void unlock(IFSKey key) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "unlock", new Class[]{IFSKey.class}, new Object[]{key});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void write(byte[] data, int dataOffset, int length) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "write", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, new Integer(dataOffset), new Integer(length)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void writeText(String data, int ccsid) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "writeText", new Class[]{String.class, Integer.TYPE}, new Object[]{data, new Integer(ccsid)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

