/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class IFSFileReader
extends Reader {
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    private transient ConvTableReader reader_;
    private IFSFileInputStream inputStream_;

    public IFSFileReader(IFSFile file) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        int ccsid = file.getCCSID();
        if (ccsid == -1) {
            IFSFileReader.throwException(file.getPath());
        }
        this.inputStream_ = new IFSFileInputStream(file);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, ccsid);
    }

    public IFSFileReader(IFSFile file, int ccsid) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.inputStream_ = new IFSFileInputStream(file);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, ccsid);
    }

    public IFSFileReader(IFSFile file, int ccsid, int shareOption) throws AS400SecurityException, IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.inputStream_ = new IFSFileInputStream(file, shareOption);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, ccsid);
    }

    public IFSFileReader(IFSFileDescriptor fd) throws AS400SecurityException, IOException {
        int ccsid = fd.getCCSID();
        if (ccsid == -1) {
            IFSFileReader.throwException(fd.getPath());
        }
        this.inputStream_ = new IFSFileInputStream(fd);
        this.reader_ = new ConvTableReader((InputStream)this.inputStream_, ccsid);
    }

    public void close() throws IOException {
        this.reader_.close();
    }

    public int getCCSID() {
        return this.reader_.getCcsid();
    }

    public String getEncoding() {
        return this.reader_.getEncoding();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        return this.reader_.read();
    }

    public int read(char[] cbuf) throws IOException {
        return this.reader_.read(cbuf);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader_.read(cbuf, off, len);
    }

    public boolean ready() throws IOException {
        return this.reader_.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        IFSFileInputStream iFSFileInputStream = this.inputStream_;
        synchronized (iFSFileInputStream) {
            this.inputStream_.reset();
            this.reader_ = new ConvTableReader((InputStream)this.inputStream_, this.reader_.getCcsid());
        }
    }

    public long skip(long charsToSkip) throws IOException {
        return this.reader_.skip(charsToSkip);
    }

    public IFSKey lockBytes(int length) throws IOException {
        return this.lockBytes((long)length);
    }

    public IFSKey lockBytes(long length) throws IOException {
        return this.inputStream_.lock(length);
    }

    public void unlockBytes(IFSKey key) throws IOException {
        this.inputStream_.unlock(key);
    }

    private static final void throwException(String path) throws ExtendedIOException {
        Trace.log(2, "File does not exist or is not readable.");
        throw new ExtendedIOException(path, 2);
    }
}

