/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSListAttrsReq
extends IFSDataStreamReq {
    static final int NO_AUTHORITY_REQUIRED = 0;
    static final int READ_AUTHORITY_REQUIRED = 1;
    static final int WRITE_AUTHORITY_REQUIRED = 2;
    static final int EXEC_AUTHORITY_REQUIRED = 4;
    static final short DEFAULT_ATTR_LIST_LEVEL = 1;
    static final int OA_NONE = 0;
    static final int OA1 = 1;
    static final int OA2 = 2;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int CCSID_OFFSET = 26;
    private static final int WORKING_DIR_HANDLE_OFFSET = 28;
    private static final int CHECK_AUTHORITY_OFFSET = 32;
    private static final int MAX_GET_COUNT_OFFSET = 34;
    private static final int FILE_ATTR_LIST_LEVEL_OFFSET = 36;
    private static final int PATTERN_MATCHING_OFFSET = 38;
    private static final int OPTIONAL_SECTION_OFFSET = 40;
    private static final int FILE_NAME_LL_OFFSET = 40;
    private static final int FILE_NAME_CP_OFFSET = 44;
    private static final int FILE_NAME_OFFSET = 46;
    private static final int OA1_FLAGS_LL_OFFSET = 40;
    private static final int OA1_FLAGS_CP_OFFSET = 44;
    private static final int OA1_FLAGS_OFFSET1 = 46;
    private static final int OA1_FLAGS_OFFSET2 = 50;
    private static final int HEADER_LENGTH = 20;
    private static final int TEMPLATE_LENGTH = 20;
    private static final int LLCP_LENGTH = 6;

    IFSListAttrsReq(byte[] name, int fileNameCCSID, int authority, int maximumGetCount, byte[] restartNameOrID, boolean isRestartName, byte[][] eaNames, int eaNameBytesLength, boolean longFileSize, int patternMatching) {
        super(46 + name.length + (restartNameOrID != null ? 6 + restartNameOrID.length : 0) + (eaNames == null ? 0 : 8 + 10 * eaNames.length + eaNameBytesLength));
        this.setLength(this.data_.length);
        this.setTemplateLen(20);
        this.setReqRepID(10);
        this.set32bit(0, 22);
        this.set16bit(fileNameCCSID, 26);
        this.set32bit(1, 28);
        this.set16bit(authority, 32);
        if (maximumGetCount <= 0) {
            this.set16bit(65535, 34);
        } else {
            this.set16bit(maximumGetCount, 34);
        }
        if (longFileSize) {
            this.set16bit(257, 36);
        } else {
            this.set16bit(1, 36);
        }
        this.set16bit(0, 38);
        this.set32bit(name.length + 6, 40);
        this.set16bit(2, 44);
        System.arraycopy(name, 0, this.data_, 46, name.length);
        int offset = 46 + name.length;
        if (restartNameOrID != null) {
            int codePoint = isRestartName ? 7 : 14;
            this.set32bit(restartNameOrID.length + 6, offset);
            this.set16bit(codePoint, offset + 4);
            System.arraycopy(restartNameOrID, 0, this.data_, offset + 6, restartNameOrID.length);
            offset += 6 + restartNameOrID.length;
        }
        if (eaNames != null) {
            int eaNameListLength = 8 + 10 * eaNames.length + eaNameBytesLength;
            this.set32bit(eaNameListLength, offset + 0);
            this.set16bit(8, offset + 4);
            this.set16bit(eaNames.length & 0xFF, offset + 6);
            offset += 8;
            for (int i = 0; i < eaNames.length; ++i) {
                this.set16bit(fileNameCCSID, offset);
                this.set16bit(eaNames[i].length, offset + 2);
                this.set16bit(0, offset + 4);
                this.set32bit(0, offset + 6);
                System.arraycopy(eaNames[i], 0, this.data_, offset + 10, eaNames[i].length);
                offset += 10 + eaNames[i].length;
            }
        }
        this.setPatternMatching(patternMatching);
    }

    IFSListAttrsReq(int handle) {
        this(handle, 0, 0, 0);
    }

    IFSListAttrsReq(int handle, int attrsType, int flags1, int flags2) {
        super(40 + (attrsType == 1 ? 14 : 0));
        this.setLength(this.data_.length);
        this.setTemplateLen(20);
        this.setReqRepID(10);
        this.set32bit(handle, 22);
        this.set32bit(1, 28);
        this.set16bit(0, 32);
        this.set16bit(65535, 34);
        this.set16bit(0, 38);
        switch (attrsType) {
            case 1: {
                this.set16bit(66, 36);
                this.set32bit(14, 40);
                this.set16bit(16, 44);
                this.set32bit(flags1, 46);
                this.set32bit(flags2, 50);
                break;
            }
            case 2: {
                this.set16bit(68, 36);
                break;
            }
            default: {
                this.set16bit(1, 36);
            }
        }
    }

    final void setPatternMatching(int patternMatching) {
        this.set16bit(patternMatching, 38);
    }

    final void setSorted(boolean sort) {
        int attributeListLevel = this.get16bit(36);
        attributeListLevel = sort ? (attributeListLevel |= 0x80) : (attributeListLevel &= 0xFF7F);
        this.set16bit(attributeListLevel, 36);
    }
}

