/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ISeriesNetServerShare;

public class ISeriesNetServerFileShare
extends ISeriesNetServerShare {
    static final long serialVersionUID = 1L;
    public static final int NO_MAX = -1;
    public static final int UNKNOWN = -1;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    public static final int NOT_ENABLED = 0;
    public static final int ENABLED = 1;
    public static final int ENABLED_AND_MIXED = 2;
    String path_;
    int permissions_;
    int maxNumberOfUsers_;
    int curNumberOfUsers_;
    int ccsidForTextConversion_;
    String textConversionEnablement_;
    String[] fileExtensions_;

    ISeriesNetServerFileShare(String shareName, int permissions, int maxUsers, int currentUsers, String description, String path, int ccsid, String enableConversion, String[] fileExtensions) {
        this.setAttributeValues(shareName, permissions, maxUsers, currentUsers, description, path, ccsid, enableConversion, fileExtensions);
    }

    void setAttributeValues(String shareName, int permissions, int maxUsers, int currentUsers, String description, String path, int ccsid, String enableConversion, String[] fileExtensions) {
        super.setAttributeValues(shareName, description, true);
        this.path_ = path;
        this.permissions_ = permissions;
        this.maxNumberOfUsers_ = maxUsers;
        this.curNumberOfUsers_ = currentUsers;
        this.ccsidForTextConversion_ = ccsid;
        this.textConversionEnablement_ = enableConversion;
        this.fileExtensions_ = fileExtensions;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path_ = path.trim();
    }

    public int getPermissions() {
        return this.permissions_;
    }

    public void setPermissions(int permissions) {
        if (permissions != 1 && permissions != 2) {
            throw new ExtendedIllegalArgumentException(Integer.toString(permissions), 2);
        }
        this.permissions_ = permissions;
    }

    public int getMaximumNumberOfUsers() {
        return this.maxNumberOfUsers_;
    }

    public void setMaximumNumberOfUsers(int maximumUsers) {
        if (maximumUsers < -1) {
            throw new ExtendedIllegalArgumentException(Integer.toString(maximumUsers), 2);
        }
        this.maxNumberOfUsers_ = maximumUsers;
    }

    public int getCurrentNumberOfUsers() {
        return this.curNumberOfUsers_;
    }

    public int getTextConversionEnablement() {
        switch (this.textConversionEnablement_.charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        return 2;
    }

    public void setTextConversionEnablement(int enablement) {
        if (enablement < 0 || enablement > 2) {
            throw new ExtendedIllegalArgumentException(Integer.toString(enablement), 2);
        }
        char[] charArray = new char[1];
        switch (enablement) {
            case 0: {
                charArray[0] = 48;
                break;
            }
            case 1: {
                charArray[0] = 49;
                break;
            }
            default: {
                charArray[0] = 50;
            }
        }
        this.textConversionEnablement_ = new String(charArray);
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 2);
    }

    public int getCcsidForTextConversion() {
        return this.ccsidForTextConversion_;
    }

    public void setCcsidForTextConversion(int ccsid) {
        if (ccsid < 0) {
            throw new ExtendedIllegalArgumentException(Integer.toString(ccsid), 2);
        }
        this.ccsidForTextConversion_ = ccsid;
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 1);
    }

    public String[] getFileExtensions() {
        String[] copyOfList = new String[this.fileExtensions_.length];
        System.arraycopy(this.fileExtensions_, 0, copyOfList, 0, this.fileExtensions_.length);
        return copyOfList;
    }

    public void setFileExtensions(String[] extensions) {
        if (extensions == null) {
            throw new NullPointerException("extensions");
        }
        this.fileExtensions_ = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            this.fileExtensions_[i] = extensions[i].trim();
        }
        this.numOptionalParmsToSet_ = Math.max(this.numOptionalParmsToSet_, 4);
    }
}

