/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ReturnCodeException;

public class InternalErrorException
extends RuntimeException
implements ReturnCodeException {
    static final long serialVersionUID = 4L;
    private int rc_;
    private static ResourceBundleLoader loader_;
    public static final int DATA_STREAM_LEVEL_NOT_VALID = 1;
    public static final int DATA_STREAM_UNKNOWN = 2;
    public static final int PASSWORD_IMPROPERLY_ENCRYPTED = 3;
    public static final int PROTOCOL_ERROR = 4;
    public static final int SYNTAX_ERROR = 5;
    public static final int UNKNOWN = 6;
    public static final int VRM_NOT_VALID = 7;
    public static final int SECURITY_INVALID_STATE = 8;
    public static final int UNEXPECTED_RETURN_CODE = 9;
    public static final int UNEXPECTED_EXCEPTION = 10;

    public InternalErrorException(int returnCode) {
        super(ResourceBundleLoader.getText(InternalErrorException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    InternalErrorException(int returnCode, int value) {
        super(ResourceBundleLoader.getText(InternalErrorException.getMRIKey(returnCode)) + " - " + String.valueOf(value));
        this.rc_ = returnCode;
    }

    InternalErrorException(int returnCode, String text, int value) {
        super(ResourceBundleLoader.getText(InternalErrorException.getMRIKey(returnCode)) + " " + text + " - " + String.valueOf(value));
        this.rc_ = returnCode;
    }

    InternalErrorException(int returnCode, String text, Throwable exception) {
        super(ResourceBundleLoader.getText(InternalErrorException.getMRIKey(returnCode)) + " " + text);
        if (exception != null) {
            try {
                this.initCause(exception);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.rc_ = returnCode;
    }

    InternalErrorException(int returnCode, Throwable exception) {
        super(ResourceBundleLoader.getText(InternalErrorException.getMRIKey(returnCode)) + " " + exception.getMessage());
        if (exception != null) {
            try {
                this.initCause(exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.rc_ = returnCode;
    }

    InternalErrorException(String pathname, int returnCode) {
        super(pathname + ": " + ResourceBundleLoader.getText(InternalErrorException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    static String getMRIKey(int returnCode) {
        switch (returnCode) {
            case 1: {
                return "EXC_DATA_STREAM_LEVEL_NOT_VALID";
            }
            case 2: {
                return "EXC_DATA_STREAM_UNKNOWN";
            }
            case 3: {
                return "EXC_PASSWORD_IMPROPERLY_ENCRYPTED";
            }
            case 4: {
                return "EXC_PROTOCOL_ERROR";
            }
            case 5: {
                return "EXC_SYNTAX_ERROR";
            }
            case 6: {
                return "EXC_UNKNOWN";
            }
            case 7: {
                return "EXC_VRM_NOT_VALID";
            }
            case 8: {
                return "EXC_SECURITY_INVALID_STATE";
            }
            case 9: {
                return "EXC_UNEXPECTED_RETURN_CODE";
            }
            case 10: {
                return "EXC_UNEXPECTED_EXCEPTION";
            }
        }
        return "EXC_UNKNOWN";
    }

    public int getReturnCode() {
        return this.rc_;
    }
}

