/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JDCallableStatementProxy;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDDatabaseMetaDataProxy;
import com.ibm.as400.access.JDPreparedStatementProxy;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDStatementProxy;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyFactoryImpl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

class JDConnectionProxy
extends AbstractProxyImpl
implements Connection {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private JDDatabaseMetaDataProxy metaData_;
    AS400 as400PublicClassObj_;
    private static final String EXC_FUNCTION_NOT_SUPPORTED = "IM001";
    private static final String EXC_CONNECTION_REJECTED = "08004";
    private static final String EXC_CONNECTION_UNABLE = "08001";

    JDConnectionProxy() {
    }

    private Object callFactoryMethod(String methodName, Class[] argClasses, Object[] argValues, ProxyFactoryImpl proxyObject) throws SQLException {
        try {
            if (argClasses == null) {
                return this.connection_.callFactoryMethod(this.pxId_, methodName, proxyObject);
            }
            return this.connection_.callFactoryMethod(this.pxId_, methodName, argClasses, argValues, proxyObject);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private void callMethod(String methodName) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private void callMethod(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private boolean callMethodRtnBool(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private Object callMethodRtnObj(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsObject(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    private Object callMethodRtnObj(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public void clearWarnings() throws SQLException {
        this.callMethod("clearWarnings");
    }

    public void close() throws SQLException {
        this.callMethod("close");
    }

    public void commit() throws SQLException {
        this.callMethod("commit");
    }

    public void construct(ProxyClientConnection connection) {
        this.connection_ = connection;
    }

    public Statement createStatement() throws SQLException {
        JDStatementProxy newStatement = new JDStatementProxy(this);
        return (JDStatementProxy)this.callFactoryMethod("createStatement", null, null, newStatement);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        JDStatementProxy newStatement = new JDStatementProxy(this);
        return (JDStatementProxy)this.callFactoryMethod("createStatement", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency)}, newStatement);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDStatementProxy newStatement = new JDStatementProxy(this);
        return (JDStatementProxy)this.callFactoryMethod("createStatement", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)}, newStatement);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.callMethodRtnBool("getAutoCommit");
    }

    public String getCatalog() throws SQLException {
        return (String)this.callMethodRtnObj("getCatalog");
    }

    public int getConcurrentAccessResolution() throws SQLException {
        return (Integer)this.callMethodRtnObj("getConcurrentAccessResolution");
    }

    public int getHoldability() throws SQLException {
        return (Integer)this.callMethodRtnObj("getHoldability");
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData_ == null) {
            JDDatabaseMetaDataProxy newMetaData = new JDDatabaseMetaDataProxy(this);
            this.metaData_ = (JDDatabaseMetaDataProxy)this.callFactoryMethod("getMetaData", null, null, newMetaData);
        }
        return this.metaData_;
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "getTransactionIsolation");
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public Map getTypeMap() throws SQLException {
        return (Map)this.callMethodRtnObj("getTypeMap");
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.callMethodRtnObj("getWarnings");
    }

    public boolean isClosed() throws SQLException {
        return this.callMethodRtnBool("isClosed");
    }

    public boolean isReadOnly() throws SQLException {
        return this.callMethodRtnBool("isReadOnly");
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "nativeSQL", new Class[]{String.class}, new Object[]{sql}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        JDCallableStatementProxy newStatement = new JDCallableStatementProxy(this);
        return (JDCallableStatementProxy)this.callFactoryMethod("prepareCall", new Class[]{String.class}, new Object[]{sql}, newStatement);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JDCallableStatementProxy newStatement = new JDCallableStatementProxy(this);
        return (JDCallableStatementProxy)this.callFactoryMethod("prepareCall", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)}, newStatement);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDCallableStatementProxy newStatement = new JDCallableStatementProxy(this);
        return (JDCallableStatementProxy)this.callFactoryMethod("prepareCall", new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)}, newStatement);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        JDPreparedStatementProxy newStatement = new JDPreparedStatementProxy(this);
        return (JDPreparedStatementProxy)this.callFactoryMethod("prepareStatement", new Class[]{String.class}, new Object[]{sql}, newStatement);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        JDPreparedStatementProxy newStatement = new JDPreparedStatementProxy(this);
        return (JDPreparedStatementProxy)this.callFactoryMethod("prepareStatement", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, new Integer(autoGeneratedKeys)}, newStatement);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001"), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001"), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JDPreparedStatementProxy newStatement = new JDPreparedStatementProxy(this);
        return (JDPreparedStatementProxy)this.callFactoryMethod("prepareStatement", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)}, newStatement);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDPreparedStatementProxy newStatement = new JDPreparedStatementProxy(this);
        return (JDPreparedStatementProxy)this.callFactoryMethod("prepareStatement", new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)}, newStatement);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001"), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    static InternalErrorException rethrow1(InvocationTargetException e) throws SQLException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof SQLException) {
            throw (SQLException)e2;
        }
        return ProxyClientConnection.rethrow(e);
    }

    public void rollback() throws SQLException {
        this.callMethod("rollback");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001"), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.callMethod("setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(autoCommit)});
    }

    public void setCatalog(String catalog) throws SQLException {
        this.callMethod("setCatalog", new Class[]{String.class}, new Object[]{catalog});
    }

    public void setConcurrentAccessResolution(int concurrentAccessResolution) throws SQLException {
        this.callMethod("setConcurrentAccessResolution", new Class[]{Integer.TYPE}, new Object[]{new Integer(concurrentAccessResolution)});
    }

    public void setHoldability(int holdability) throws SQLException {
        this.callMethod("setHoldability", new Class[]{Integer.TYPE}, new Object[]{new Integer(holdability)});
    }

    void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400 as400) throws SQLException {
        Object[] argValues;
        Class[] argClasses;
        String remoteClassName;
        String secondaryUrl = dataSourceUrl.getSecondaryURL();
        if (secondaryUrl.length() == 0) {
            remoteClassName = "AS400JDBCConnection";
            argClasses = new Class[]{JDDataSourceURL.class, JDProperties.class, AS400Impl.class};
            argValues = new Object[]{dataSourceUrl, properties, as400.getImpl()};
            try {
                as400.connectService(4);
            }
            catch (AS400SecurityException e) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(this, "Security Exception caught", e);
                }
                SQLException sqlex = new SQLException(AS400JDBCDriver.getResource("JD08004"), EXC_CONNECTION_REJECTED, -99999);
                sqlex.initCause(e);
                throw sqlex;
            }
            catch (IOException e) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(this, "IOException caught", e);
                }
                SQLException sqlex = new SQLException(AS400JDBCDriver.getResource("JD08001"), EXC_CONNECTION_UNABLE, -99999);
                sqlex.initCause(e);
                throw sqlex;
            }
        } else {
            remoteClassName = "JDGenericConnection";
            argClasses = new Class[]{String.class, Properties.class};
            argValues = new Object[]{secondaryUrl, properties.getOriginalInfo()};
        }
        try {
            this.pxId_ = this.connection_.callConstructor(remoteClassName, false);
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
        this.callMethod("setProperties", argClasses, argValues);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.callMethod("setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{new Boolean(readOnly)});
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001"), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001"), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    void setSystem(AS400 as400) {
        this.as400PublicClassObj_ = as400;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.callMethod("setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{new Integer(level)});
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        this.callMethod("setTypeMap", new Class[]{Map.class}, new Object[]{typeMap});
    }

    public String toString() {
        try {
            return (String)this.connection_.callMethodReturnsObject(this.pxId_, "toString");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.Connection"};
    }

    public boolean isValid(int timeout) throws SQLException {
        Object[] oa = new Object[]{new Integer(timeout)};
        return (Boolean)this.callMethodRtnObj("isValid", new Class[]{Integer.TYPE}, oa);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.callMethod("setClientInfo", new Class[]{String.class, String.class}, new Object[]{name, value});
        }
        catch (SQLException e) {
            if (e instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e;
            }
            HashMap<String, ClientInfoStatus> m = new HashMap<String, ClientInfoStatus>();
            m.put(name, ClientInfoStatus.REASON_UNKNOWN);
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), m);
            throw clientIE;
        }
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.callMethod("setClientInfo", new Class[]{Properties.class}, new Object[]{properties});
        }
        catch (SQLException e) {
            if (e instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e;
            }
            HashMap<String, ClientInfoStatus> m = new HashMap<String, ClientInfoStatus>();
            Enumeration<Object> clientInfoNames = properties.keys();
            while (clientInfoNames.hasMoreElements()) {
                String clientInfoName = (String)clientInfoNames.nextElement();
                m.put(clientInfoName, ClientInfoStatus.REASON_UNKNOWN);
            }
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), m);
            throw clientIE;
        }
    }

    public String getClientInfo(String name) throws SQLException {
        return (String)this.callMethodRtnObj("getClientInfo", new Class[]{String.class}, new Object[]{name});
    }

    public Properties getClientInfo() throws SQLException {
        return (Properties)this.callMethodRtnObj("getClientInfo");
    }

    public Clob createClob() throws SQLException {
        return (Clob)this.callMethodRtnObj("createClob");
    }

    public Blob createBlob() throws SQLException {
        return (Blob)this.callMethodRtnObj("createBlob");
    }

    public NClob createNClob() throws SQLException {
        return (NClob)this.callMethodRtnObj("createNClob");
    }

    public SQLXML createSQLXML() throws SQLException {
        return (SQLXML)this.callMethodRtnObj("createSQLXML");
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return (Array)this.callMethodRtnObj("createArrayOf", new Class[]{String.class, Object[].class}, new Object[]{typeName, elements});
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return (Struct)this.callMethodRtnObj("createStruct", new Class[]{String.class, Object[].class}, new Object[]{typeName, attributes});
    }

    public String getServerJobIdentifier() throws SQLException {
        return (String)this.callMethodRtnObj("getServerJobIdentifier");
    }

    public void abort(Executor executor) throws SQLException {
        this.callMethod("abort", new Class[]{Executor.class}, new Object[]{executor});
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.callMethod("setNetworkTimeout", new Class[]{Executor.class, Integer.class}, new Object[]{executor, new Integer(milliseconds)});
    }

    public int getNetworkTimeout() throws SQLException {
        return (Integer)this.callMethodRtnObj("getNetworkTimeout");
    }

    public String getSchema() throws SQLException {
        return (String)this.callMethodRtnObj("getSchema");
    }

    public void setSchema(String schema) throws SQLException {
        this.callMethod("setSchema", new Class[]{String.class}, new Object[]{schema});
    }
}

