/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLTokenizer;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

class JDEscapeClause {
    private static final String CALL_ = "CALL";
    private static final String CALL1_ = "?=";
    private static final String CALL2_ = "?=CALL";
    private static final String CALL3_ = "?";
    private static final String DATE_ = "D";
    private static final String ESCAPE_ = "ESCAPE";
    private static final String FN_ = "FN";
    private static final String OJ_ = "OJ";
    private static final String TIME_ = "T";
    private static final String TIMESTAMP_ = "TS";
    private static JDScalarTable scalarFunctionTable_ = new JDScalarTable();

    JDEscapeClause() {
    }

    static String parse(String escapeSyntax, String decimalSeparator, int vrm) throws SQLException {
        JDSQLTokenizer tokenizer = new JDSQLTokenizer(escapeSyntax, "{}'\"");
        return JDEscapeClause.parse(tokenizer, decimalSeparator, true, vrm);
    }

    private static String parse(JDSQLTokenizer tokenizer, String decimalSeparator, boolean flag, int vrm) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        boolean quotes = false;
        char quoteType = ' ';
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("{")) {
                if (quotes) {
                    buffer.append(token);
                    continue;
                }
                buffer.append(JDEscapeClause.parse(tokenizer, decimalSeparator, false, vrm));
                continue;
            }
            if (token.equals("}")) {
                if (quotes) {
                    buffer.append(token);
                    continue;
                }
                if (flag) {
                    JDError.throwSQLException("42601");
                    continue;
                }
                return JDEscapeClause.convert(buffer.toString(), decimalSeparator, vrm);
            }
            if (token.equals("'") || token.equals("\"")) {
                if (quotes) {
                    if (quoteType == token.charAt(0)) {
                        quotes = false;
                    }
                } else {
                    quotes = true;
                    quoteType = token.charAt(0);
                }
                buffer.append(token);
                continue;
            }
            buffer.append(token);
        }
        if (!flag) {
            JDError.throwSQLException("42601");
        }
        return buffer.toString();
    }

    private static String convert(String escapeSyntax, String decimalSeparator, int vrm) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        String trimmed = escapeSyntax.trim();
        int i = trimmed.indexOf(32);
        String keyword = null;
        String value = null;
        if (i == -1) {
            keyword = trimmed;
            value = "";
        } else {
            keyword = trimmed.substring(0, i);
            value = trimmed.substring(i + 1);
        }
        if (keyword.equalsIgnoreCase(CALL_) || keyword.equalsIgnoreCase(CALL1_) || keyword.equalsIgnoreCase(CALL2_) || keyword.equalsIgnoreCase(CALL3_)) {
            buffer.append(keyword);
            buffer.append(' ');
            buffer.append(value);
        } else if (keyword.equalsIgnoreCase(DATE_)) {
            buffer.append(value);
        } else if (keyword.equalsIgnoreCase(TIME_)) {
            buffer.append(value);
        } else if (keyword.equalsIgnoreCase(TIMESTAMP_)) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            if (tokenizer.countTokens() != 2) {
                JDError.throwSQLException("42601");
            }
            buffer.append(tokenizer.nextToken());
            buffer.append('-');
            buffer.append(tokenizer.nextToken().replace(':', '.'));
        } else if (keyword.equalsIgnoreCase(FN_)) {
            buffer.append(JDEscapeClause.convertScalarFunctionCall(value, decimalSeparator, vrm));
        } else if (keyword.equalsIgnoreCase(ESCAPE_)) {
            if (value.trim().length() == 0) {
                JDError.throwSQLException("42601");
            }
            buffer.append(keyword);
            buffer.append(' ');
            buffer.append(value);
        } else if (keyword.equalsIgnoreCase(OJ_)) {
            buffer.append(value);
        }
        if (buffer.length() == 0) {
            JDError.throwSQLException("42601");
        }
        return buffer.toString();
    }

    private static String convertScalarFunctionCall(String functionCall, String decimalSeparator, int vrm) throws SQLException {
        int i = functionCall.indexOf(40);
        int j = functionCall.lastIndexOf(41);
        String functionName = null;
        String argumentString = null;
        if (i < j && i != -1 && j != -1) {
            functionName = functionCall.substring(0, i).trim().toLowerCase();
            argumentString = functionCall.substring(i + 1, j).trim();
        } else {
            JDError.throwSQLException("42601");
        }
        if (!scalarFunctionTable_.contains(functionName, vrm)) {
            return functionCall;
        }
        if (j != -1 && j + 1 < functionCall.length() && functionCall.substring(j + 1).trim().length() > 0) {
            JDError.throwSQLException("42601");
        }
        Vector<String> arguments = new Vector<String>();
        if (argumentString.length() > 0) {
            StringTokenizer atok = new StringTokenizer(argumentString, "(),", true);
            StringBuffer tokbuf = new StringBuffer();
            int nestlevel = 0;
            while (atok.hasMoreTokens()) {
                String token = atok.nextToken();
                if (token.equals("(")) {
                    ++nestlevel;
                    tokbuf.append("(");
                    continue;
                }
                if (token.equals(")")) {
                    --nestlevel;
                    tokbuf.append(")");
                    if (atok.hasMoreTokens()) continue;
                    arguments.add(tokbuf.toString());
                    continue;
                }
                if (token.equals(",")) {
                    if (nestlevel == 0) {
                        arguments.add(tokbuf.toString());
                        tokbuf = new StringBuffer();
                        continue;
                    }
                    tokbuf.append(",");
                    continue;
                }
                tokbuf.append(token);
                if (atok.hasMoreTokens()) continue;
                arguments.add(tokbuf.toString());
            }
        }
        StringBuffer buffer = new StringBuffer();
        String nativeSQL = scalarFunctionTable_.get(functionName, vrm).toString();
        int marker = 0;
        int nextPercent = 0;
        int highestArgumentNumber = 0;
        while (true) {
            if ((nextPercent = nativeSQL.indexOf(37, marker)) == -1 || nextPercent == nativeSQL.length() - 1) break;
            buffer.append(nativeSQL.substring(marker, nextPercent));
            char substitutionCode = nativeSQL.charAt(nextPercent + 1);
            if (Character.isDigit(substitutionCode)) {
                int argumentNumber = Character.digit(substitutionCode, 10);
                if (argumentNumber > arguments.size()) {
                    JDError.throwSQLException("42601");
                }
                if (argumentNumber > highestArgumentNumber) {
                    highestArgumentNumber = argumentNumber;
                }
                buffer.append(arguments.elementAt(argumentNumber - 1));
            } else if (substitutionCode == 'd') {
                buffer.append(decimalSeparator);
            }
            marker = nextPercent + 2;
        }
        buffer.append(nativeSQL.substring(marker));
        if (highestArgumentNumber != arguments.size()) {
            JDError.throwSQLException("42601");
        }
        return buffer.toString();
    }

    static String getNumericFunctions(int vrm) {
        if (vrm >= JDUtilities.vrm610) {
            return "abs,acos,asin,atan,atan2,ceiling,character_length,cos,cot,degrees,exp,floor,log,log10,mod,octet_length,pi,power,position,radians,rand,round,sign,sin,sqrt,tan,truncate";
        }
        if (vrm < JDUtilities.vrm510) {
            return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,round,sin,sign,sqrt,tan,truncate";
        }
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sin,sign,sqrt,tan,truncate";
    }

    static String getStringFunctions(int vrm) {
        if (vrm >= JDUtilities.vrm610) {
            return "ascii,char,char_length,character_length,concat,difference,insert,lcase,left,length,locate,ltrim,octet_length,position,repeat,replace,right,rtrim,soundex,space,substring,ucase";
        }
        if (vrm < JDUtilities.vrm510) {
            return "concat,insert,left,length,locate,ltrim,right,rtrim,substring,ucase";
        }
        if (vrm < JDUtilities.vrm520) {
            return "concat,difference,insert,left,length,locate,ltrim,right,rtrim,soundex,space,substring,ucase";
        }
        if (vrm < JDUtilities.vrm530) {
            return "char,concat,difference,insert,lcase,left,length,locate,ltrim,right,rtrim,soundex,space,substring,ucase";
        }
        return "ascii,char,concat,difference,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,soundex,space,substring,ucase";
    }

    static String getSystemFunctions(int vrm) {
        return "database,ifnull,user";
    }

    static String getTimeDateFunctions(int vrm) {
        if (vrm >= JDUtilities.vrm610) {
            return "current_date,current_time,current_timestamp,curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,extract,hour,minute,month,monthname,now,quarter,second,timestampdiff,week,year";
        }
        if (vrm < JDUtilities.vrm510) {
            return "curdate,curtime,dayofmonth,dayofweek,dayofyear,hour,minute,month,now,quarter,second,week,year";
        }
        if (vrm < JDUtilities.vrm530) {
            return "curdate,curtime,dayofmonth,dayofweek,dayofyear,hour,minute,month,now,quarter,second,timestampdiff,week,year";
        }
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,timestampdiff,week,year";
    }

    static boolean supportsConvert() {
        return false;
    }

    static boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    static {
        scalarFunctionTable_.put("pi", "3%d1415926E00", JDUtilities.vrm510);
        scalarFunctionTable_.put("log", "LN(%1)", 0);
        scalarFunctionTable_.put("length", "LENGTH(STRIP(%1,T))", 0);
        scalarFunctionTable_.put("database", "CURRENT SERVER", JDUtilities.vrm530);
        scalarFunctionTable_.put("user", "USER", 0);
        scalarFunctionTable_.put("jtopeninfo", "'Open Source Software, JTOpen 9.6, codebase 5770-SS1 V7R3M0.00 built=20181007 @X2'", 0);
    }

    private static final class JDScalarTable {
        public static final int NOT_SUPPORTED = 0;
        private static final int HASH = 10;
        private String[][] keys = new String[10][];
        private String[][] data = new String[10][];
        private int[][] vrms = new int[10][];

        private JDScalarTable() {
        }

        final boolean contains(String key, int vrm) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = (key.hashCode() < 0 ? key.hashCode() * -1 : key.hashCode()) % 10;
            String[] keyChain = this.keys[hash];
            int[] vrmChain = this.vrms[hash];
            if (keyChain == null) {
                return false;
            }
            if (vrmChain == null) {
                return false;
            }
            for (int i = 0; i < keyChain.length; ++i) {
                if (keyChain[i] == null || !keyChain[i].equals(key) || vrmChain[i] <= vrm && vrmChain[i] != 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final String get(String key, int vrm) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = (key.hashCode() < 0 ? key.hashCode() * -1 : key.hashCode()) % 10;
            String[][] stringArray = this.keys;
            synchronized (this.keys) {
                String[] keyChain = this.keys[hash];
                int[] vrmChain = this.vrms[hash];
                if (keyChain == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                if (vrmChain == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                for (int i = 0; i < keyChain.length; ++i) {
                    if (keyChain[i] == null || !keyChain[i].equals(key) || vrmChain[i] <= vrm && vrmChain[i] != 0) continue;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.data[hash][i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void put(String key, String value, int vrm) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (vrm < 0) {
                throw new IllegalArgumentException("vrm");
            }
            int hash = (key.hashCode() < 0 ? key.hashCode() * -1 : key.hashCode()) % 10;
            String[][] stringArray = this.keys;
            synchronized (this.keys) {
                String[] valueChain = this.data[hash];
                String[] keyChain = this.keys[hash];
                int[] vrmChain = this.vrms[hash];
                if (keyChain == null) {
                    keyChain = new String[]{key};
                    valueChain = new String[]{value};
                    vrmChain = new int[]{vrm};
                    this.keys[hash] = keyChain;
                    this.data[hash] = valueChain;
                    this.vrms[hash] = vrmChain;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                int len = keyChain.length;
                for (int i = 0; i < len; ++i) {
                    if (keyChain[i] != null && keyChain[i].equals(key)) {
                        valueChain[i] = value;
                        vrmChain[i] = vrm;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                    if (keyChain[i] != null) continue;
                    keyChain[i] = key;
                    valueChain[i] = value;
                    vrmChain[i] = vrm;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                String[] newKeyChain = new String[len * 2];
                System.arraycopy(keyChain, 0, newKeyChain, 0, len);
                String[] newValueChain = new String[len * 2];
                System.arraycopy(valueChain, 0, newValueChain, 0, len);
                int[] newVRMChain = new int[len * 2];
                System.arraycopy(vrmChain, 0, newVRMChain, 0, len);
                newKeyChain[len] = key;
                newValueChain[len] = value;
                newVRMChain[len] = vrm;
                this.keys[hash] = newKeyChain;
                this.data[hash] = newValueChain;
                this.vrms[hash] = newVRMChain;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
    }
}

