/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyFactoryImpl;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;

class JDInputStreamProxy
extends InputStream
implements ProxyFactoryImpl {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private long pxId_;
    private ProxyClientConnection connection_;
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false};

    JDInputStreamProxy() {
    }

    public int available() throws IOException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "available");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    protected void finalize() throws Throwable {
        this.connection_.callFinalize(this.pxId_);
        super.finalize();
    }

    public void initialize(long proxyId, ProxyClientConnection connection) {
        this.pxId_ = proxyId;
        this.connection_ = connection;
    }

    public void mark(int readLimit) {
        try {
            this.connection_.callMethod(this.pxId_, "mark", new Class[]{Integer.TYPE}, new Object[]{new Integer(readLimit)});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public boolean markSupported() {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "markSupported");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    public int read() throws IOException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "read");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int start, int length) throws IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, new Integer(start), new Integer(length)}, ARGS_TO_RETURN, false);
            byte[] returnDataBuffer = (byte[])rv.getArgument(0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = returnDataBuffer[i];
            }
            return rv.getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public void reset() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "reset");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    public long skip(long length) throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "skip", new Class[]{Long.TYPE}, new Object[]{new Long(length)}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

