/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDParameterMetaDataProxy;
import com.ibm.as400.access.JDResultSetMetaDataProxy;
import com.ibm.as400.access.JDResultSetProxy;
import com.ibm.as400.access.JDStatementProxy;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SerializableInputStream;
import com.ibm.as400.access.SerializableReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class JDPreparedStatementProxy
extends JDStatementProxy
implements PreparedStatement {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final String NOT_SERIALIZABLE = "Parameter is not serializable.";

    public JDPreparedStatementProxy(JDConnectionProxy jdConnection) {
        super(jdConnection);
    }

    public void addBatch() throws SQLException {
        this.callMethod("addBatch");
    }

    public void clearParameters() throws SQLException {
        this.callMethod("clearParameters");
    }

    public boolean execute() throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnBool("execute");
    }

    public ResultSet executeQuery() throws SQLException {
        this.cachedResultSet_ = null;
        try {
            JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
            this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "executeQuery", newResultSet);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
        return this.cachedResultSet_;
    }

    public int executeUpdate() throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnInt("executeUpdate");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            JDResultSetMetaDataProxy newMetaData = new JDResultSetMetaDataProxy(this.jdConnection_);
            return (JDResultSetMetaDataProxy)this.connection_.callFactoryMethod(this.pxId_, "getMetaData", newMetaData);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            JDParameterMetaDataProxy newMetaData = new JDParameterMetaDataProxy(this.jdConnection_);
            return (JDParameterMetaDataProxy)this.connection_.callFactoryMethod(this.pxId_, "getParameterMetaData", newMetaData);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    public void setArray(int parameterIndex, Array parameterValue) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setArray", new Class[]{Integer.TYPE, Array.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setAsciiStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        InputStream iStream;
        if (parameterValue == null || parameterValue instanceof Serializable) {
            iStream = parameterValue;
        } else {
            try {
                iStream = new SerializableInputStream(parameterValue);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{new Integer(parameterIndex), iStream, new Integer(length)});
    }

    public void setBigDecimal(int parameterIndex, BigDecimal parameterValue) throws SQLException {
        this.callMethod("setBigDecimal", new Class[]{Integer.TYPE, BigDecimal.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setBinaryStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        InputStream iStream;
        if (parameterValue == null || parameterValue instanceof Serializable) {
            iStream = parameterValue;
        } else {
            try {
                iStream = new SerializableInputStream(parameterValue);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{new Integer(parameterIndex), iStream, new Integer(length)});
    }

    public void setBlob(int parameterIndex, Blob parameterValue) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setBlob", new Class[]{Integer.TYPE, Blob.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setBoolean(int parameterIndex, boolean parameterValue) throws SQLException {
        this.callMethod("setBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(parameterIndex), new Boolean(parameterValue)});
    }

    public void setByte(int parameterIndex, byte parameterValue) throws SQLException {
        this.callMethod("setByte", new Class[]{Integer.TYPE, Byte.TYPE}, new Object[]{new Integer(parameterIndex), new Byte(parameterValue)});
    }

    public void setBytes(int parameterIndex, byte[] parameterValue) throws SQLException {
        this.callMethod("setBytes", new Class[]{Integer.TYPE, byte[].class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setCharacterStream(int parameterIndex, Reader parameterValue, int length) throws SQLException {
        try {
            SerializableReader reader = parameterValue == null ? null : new SerializableReader(parameterValue, Math.max(0, length));
            this.callMethod("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Integer.TYPE}, new Object[]{new Integer(parameterIndex), reader, new Integer(length)});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setClob(int parameterIndex, Clob parameterValue) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setClob", new Class[]{Integer.TYPE, Clob.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setDate(int parameterIndex, Date parameterValue) throws SQLException {
        this.callMethod("setDate", new Class[]{Integer.TYPE, Date.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setDate(int parameterIndex, Date parameterValue, Calendar calendar) throws SQLException {
        this.callMethod("setDate", new Class[]{Integer.TYPE, Date.class, Calendar.class}, new Object[]{new Integer(parameterIndex), parameterValue, calendar});
    }

    public void setDouble(int parameterIndex, double parameterValue) throws SQLException {
        this.callMethod("setDouble", new Class[]{Integer.TYPE, Double.TYPE}, new Object[]{new Integer(parameterIndex), new Double(parameterValue)});
    }

    public void setFloat(int parameterIndex, float parameterValue) throws SQLException {
        this.callMethod("setFloat", new Class[]{Integer.TYPE, Float.TYPE}, new Object[]{new Integer(parameterIndex), new Float(parameterValue)});
    }

    public void setInt(int parameterIndex, int parameterValue) throws SQLException {
        this.callMethod("setInt", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(parameterIndex), new Integer(parameterValue)});
    }

    public void setLong(int parameterIndex, long parameterValue) throws SQLException {
        this.callMethod("setLong", new Class[]{Integer.TYPE, Long.TYPE}, new Object[]{new Integer(parameterIndex), new Long(parameterValue)});
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.callMethod("setNull", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(parameterIndex), new Integer(sqlType)});
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.callMethod("setNull", new Class[]{Integer.TYPE, Integer.TYPE, String.class}, new Object[]{new Integer(parameterIndex), new Integer(sqlType), typeName});
    }

    public void setObject(int parameterIndex, Object parameterValue) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setObject", new Class[]{Integer.TYPE, Object.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setObject(int parameterIndex, Object parameterValue, int sqlType) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE}, new Object[]{new Integer(parameterIndex), parameterValue, new Integer(sqlType)});
    }

    public void setObject(int parameterIndex, Object parameterValue, int sqlType, int scale) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(parameterIndex), parameterValue, new Integer(sqlType), new Integer(scale)});
    }

    public void setRef(int parameterIndex, Ref parameterValue) throws SQLException {
        if (parameterValue != null && !(parameterValue instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setRef", new Class[]{Integer.TYPE, Ref.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setShort(int parameterIndex, short parameterValue) throws SQLException {
        this.callMethod("setShort", new Class[]{Integer.TYPE, Short.TYPE}, new Object[]{new Integer(parameterIndex), new Short(parameterValue)});
    }

    public void setString(int parameterIndex, String parameterValue) throws SQLException {
        this.callMethod("setString", new Class[]{Integer.TYPE, String.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setTime(int parameterIndex, Time parameterValue) throws SQLException {
        this.callMethod("setTime", new Class[]{Integer.TYPE, Time.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setTime(int parameterIndex, Time parameterValue, Calendar calendar) throws SQLException {
        this.callMethod("setTime", new Class[]{Integer.TYPE, Time.class, Calendar.class}, new Object[]{new Integer(parameterIndex), parameterValue, calendar});
    }

    public void setTimestamp(int parameterIndex, Timestamp parameterValue) throws SQLException {
        this.callMethod("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setTimestamp(int parameterIndex, Timestamp parameterValue, Calendar calendar) throws SQLException {
        this.callMethod("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class, Calendar.class}, new Object[]{new Integer(parameterIndex), parameterValue, calendar});
    }

    public void setUnicodeStream(int parameterIndex, InputStream parameterValue, int length) throws SQLException {
        InputStream iStream;
        if (parameterValue == null || parameterValue instanceof Serializable) {
            iStream = parameterValue;
        } else {
            try {
                iStream = new SerializableInputStream(parameterValue);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setUnicodeStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{new Integer(parameterIndex), iStream, new Integer(length)});
    }

    public void setURL(int parameterIndex, URL parameterValue) throws SQLException {
        this.callMethod("setURL", new Class[]{Integer.TYPE, URL.class}, new Object[]{new Integer(parameterIndex), parameterValue});
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.callMethod("setRowId", new Class[]{Integer.TYPE, RowId.class}, new Object[]{new Integer(parameterIndex), x});
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.callMethod("setNString", new Class[]{Integer.TYPE, String.class}, new Object[]{new Integer(parameterIndex), value});
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        try {
            SerializableReader reader = value == null ? null : new SerializableReader(value, (int)Math.max(0L, length));
            this.callMethod("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), reader, new Long(length)});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (value != null && !(value instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setNClob", new Class[]{Integer.TYPE, NClob.class}, new Object[]{new Integer(parameterIndex), value});
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            SerializableReader serialRreader = reader == null ? null : new SerializableReader(reader, (int)Math.max(0L, length));
            this.callMethod("setClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), serialRreader, new Long(length)});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        InputStream iStream;
        if (inputStream == null || inputStream instanceof Serializable) {
            iStream = inputStream;
        } else {
            try {
                iStream = new SerializableInputStream(inputStream);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), iStream, new Long(length)});
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            SerializableReader serialRreader = reader == null ? null : new SerializableReader(reader, (int)Math.max(0L, length));
            this.callMethod("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), serialRreader, new Long(length)});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject != null && !(xmlObject instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}, new Object[]{new Integer(parameterIndex), xmlObject});
    }

    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.PreparedStatement"};
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), iStream, new Long(length)});
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), iStream, new Long(length)});
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            SerializableReader serialReader = reader == null ? null : new SerializableReader(reader, (int)Math.max(0L, length));
            this.callMethod("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(parameterIndex), serialReader, new Long(length)});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{new Integer(parameterIndex), iStream});
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        InputStream iStream;
        if (x == null || x instanceof Serializable) {
            iStream = x;
        } else {
            try {
                iStream = new SerializableInputStream(x);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{new Integer(parameterIndex), iStream});
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        InputStream iStream;
        if (inputStream == null || inputStream instanceof Serializable) {
            iStream = inputStream;
        } else {
            try {
                iStream = new SerializableInputStream(inputStream);
            }
            catch (IOException e) {
                SQLException throwException = new SQLException(e.getMessage());
                try {
                    throwException.initCause(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwException;
            }
        }
        this.callMethod("setBlob", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{new Integer(parameterIndex), iStream});
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            SerializableReader serialReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("setCharacterStream", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(parameterIndex), serialReader});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            SerializableReader serialReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("setClob", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(parameterIndex), serialReader});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        try {
            SerializableReader serialReader = value == null ? null : new SerializableReader(value);
            this.callMethod("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(parameterIndex), serialReader});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            SerializableReader serialReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("setNClob", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(parameterIndex), serialReader});
        }
        catch (IOException e) {
            SQLException throwException = new SQLException(e.getMessage());
            try {
                throwException.initCause(e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwException;
        }
    }

    public void setDBDefault(int parameterIndex) throws SQLException {
        this.setDB2Default(parameterIndex);
    }

    public void setDB2Default(int parameterIndex) throws SQLException {
        this.callMethod("setDB2Default", new Class[]{Integer.TYPE}, new Object[]{new Integer(parameterIndex)});
    }

    public void setDB2Unassigned(int parameterIndex) throws SQLException {
        this.callMethod("setDB2Unassigned", new Class[]{Integer.TYPE}, new Object[]{new Integer(parameterIndex)});
    }

    public void setDBUnassigned(int parameterIndex) throws SQLException {
        this.setDB2Unassigned(parameterIndex);
    }
}

