/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBVariableData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLArray;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLLocator;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Hashtable;

class JDServerRow
implements JDRow {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int[] parameterTypes_;
    private AS400JDBCConnection connection_;
    private int[] ccsids_;
    private int[] dataLength_;
    private int[] arrayDataLength_;
    private int[] dataOffset_;
    private String[] fieldNames_;
    private int[] lobLocatorHandles_;
    private int[] precisions_;
    private byte[] rawBytes_;
    private int rowDataOffset_;
    private int rowIndex_;
    private int[] scales_;
    private DBData serverData_;
    private DBDataFormat serverFormat_;
    private SQLData[] sqlData_;
    private int[] sqlTypes_;
    private String[] sqlTypeNames_;
    private boolean[] translated_;
    private boolean wasCompressed = false;
    private Hashtable insensitiveColumnNames_;
    boolean containsLob_;
    boolean containsArray_;

    JDServerRow(AS400JDBCConnection connection, int id, DBDataFormat serverFormat, SQLConversionSettings settings) throws SQLException {
        this.initialize(connection, id, serverFormat, settings);
    }

    byte[] getRawBytes(int index) {
        int index0 = index - 1;
        byte[] copy = new byte[this.dataLength_[index0]];
        System.arraycopy(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[index0], copy, 0, this.dataLength_[index0]);
        return copy;
    }

    private void initialize(AS400JDBCConnection connection, int id, DBDataFormat serverFormat, SQLConversionSettings settings) throws SQLException {
        this.connection_ = connection;
        this.rawBytes_ = null;
        this.rowDataOffset_ = -1;
        this.rowIndex_ = -1;
        this.serverData_ = null;
        this.serverFormat_ = serverFormat;
        int dateFormat = -1;
        int timeFormat = -1;
        try {
            int count = this.serverFormat_ == null ? 0 : this.serverFormat_.getNumberOfFields();
            this.ccsids_ = new int[count];
            this.dataLength_ = new int[count];
            this.arrayDataLength_ = new int[count];
            this.dataOffset_ = new int[count];
            this.fieldNames_ = new String[count];
            this.lobLocatorHandles_ = new int[count];
            this.precisions_ = new int[count];
            this.scales_ = new int[count];
            this.sqlData_ = new SQLData[count];
            this.sqlTypes_ = new int[count];
            this.sqlTypeNames_ = new String[count];
            this.translated_ = new boolean[count];
            this.insensitiveColumnNames_ = null;
            this.containsLob_ = false;
            this.containsArray_ = false;
            if (count > 0) {
                int offset = 0;
                boolean translateBinary = connection.getProperties().getBoolean(28);
                if (this.connection_.getVRM() >= JDUtilities.vrm610 && this.serverFormat_.getCSRSData()) {
                    dateFormat = this.serverFormat_.getDateFormat();
                    timeFormat = this.serverFormat_.getTimeFormat();
                }
                for (int i = 0; i < count; ++i) {
                    this.ccsids_[i] = this.serverFormat_.getFieldCCSID(i);
                    this.dataOffset_[i] = offset;
                    this.dataLength_[i] = this.serverFormat_.getFieldLength(i);
                    this.lobLocatorHandles_[i] = this.serverFormat_.getFieldLOBLocator(i);
                    offset += this.dataLength_[i];
                    this.scales_[i] = this.serverFormat_.getFieldScale(i);
                    this.precisions_[i] = this.serverFormat_.getFieldPrecision(i);
                    this.sqlTypes_[i] = this.serverFormat_.getFieldSQLType(i);
                    int compositeContentType = -1;
                    if (this.serverFormat_.getArrayType(i) == 1) {
                        compositeContentType = this.sqlTypes_[i] & 0xFFFE;
                        this.sqlTypes_[i] = 10000;
                        this.arrayDataLength_[i] = this.serverFormat_.getArrayFieldLength(i);
                    } else {
                        this.arrayDataLength_[i] = 0;
                    }
                    int fieldType = this.sqlTypes_[i] & 0xFFFE;
                    if (fieldType == 404 || fieldType == 960 || fieldType == 408 || fieldType == 964 || fieldType == 412 || fieldType == 968) {
                        this.containsLob_ = true;
                    } else if (fieldType == 10000) {
                        this.containsArray_ = true;
                    }
                    int maxLobSize = this.serverFormat_.getFieldLOBMaxSize(i);
                    int xmlCharType = this.serverFormat_.getXMLCharType(i);
                    this.sqlData_[i] = fieldType == 10000 ? SQLDataFactory.newData(connection, id, fieldType, this.arrayDataLength_[i], this.precisions_[i], this.scales_[i], this.ccsids_[i], translateBinary, settings, maxLobSize, i + 1, dateFormat, timeFormat, compositeContentType, xmlCharType) : SQLDataFactory.newData(connection, id, fieldType, this.dataLength_[i], this.precisions_[i], this.scales_[i], this.ccsids_[i], translateBinary, settings, maxLobSize, i + 1, dateFormat, timeFormat, compositeContentType, xmlCharType);
                }
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    void setOriginalData() throws SQLException {
        try {
            int count = 0;
            if (this.serverFormat_ != null) {
                count = this.serverFormat_.getNumberOfFields();
            }
            if (count > 0) {
                int offset = 0;
                for (int i = 0; i < count; ++i) {
                    this.dataOffset_[i] = offset;
                    this.dataLength_[i] = this.serverFormat_.getFieldLength(i);
                    this.arrayDataLength_[i] = this.serverFormat_.getArrayFieldLength(i);
                    offset += this.dataLength_[i];
                }
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    void setServerData(DBData serverData) throws SQLException {
        this.serverData_ = serverData;
        try {
            this.rawBytes_ = this.serverData_.getRawBytes();
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    void setRowIndex(int rowIndex) throws SQLException {
        this.rowIndex_ = rowIndex;
        try {
            if (this.serverData_ != null) {
                int numOfFields;
                int offset;
                this.rowDataOffset_ = this.serverData_.getRowDataOffset(this.rowIndex_);
                if (this.containsArray_ && this.rowDataOffset_ != -1) {
                    offset = 0;
                    numOfFields = this.serverFormat_.getNumberOfFields();
                    int[] dataLengths = ((DBVariableData)this.serverData_).getTotalDataLengthsFromHost();
                    int[] arrayDataLengths = ((DBVariableData)this.serverData_).getArrayDataLengthsFromHost();
                    int outCount = 0;
                    for (int j = 0; j < numOfFields; ++j) {
                        if (!this.isOutput(j + 1)) continue;
                        int length = 0;
                        this.dataOffset_[j] = offset;
                        length = dataLengths[outCount];
                        offset += length;
                        this.dataLength_[j] = length;
                        if (arrayDataLengths[outCount] > 0) {
                            this.arrayDataLength_[j] = arrayDataLengths[outCount];
                        }
                        ++outCount;
                    }
                } else if (this.serverData_.isVariableFieldsCompressed() && this.rowDataOffset_ != -1) {
                    this.wasCompressed = true;
                    offset = 0;
                    numOfFields = this.serverFormat_.getNumberOfFields();
                    for (int j = 0; j < numOfFields; ++j) {
                        int sqlType = this.sqlData_[j].getSQLType();
                        int length = 0;
                        this.dataOffset_[j] = offset;
                        switch (sqlType) {
                            case 9: 
                            case 19: 
                            case 20: 
                            case 29: 
                            case 30: 
                            case 31: {
                                length = BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.rowDataOffset_ + offset);
                                length += 2;
                                break;
                            }
                            case 21: 
                            case 32: 
                            case 36: 
                            case 37: {
                                length = 2 * BinaryConverter.byteArrayToUnsignedShort(this.rawBytes_, this.rowDataOffset_ + offset);
                                length += 2;
                                break;
                            }
                            default: {
                                length = this.serverFormat_.getFieldLength(j);
                            }
                        }
                        offset += length;
                        this.dataLength_[j] = length;
                        this.arrayDataLength_[j] = this.serverFormat_.getArrayFieldLength(j);
                    }
                } else if (this.wasCompressed) {
                    this.wasCompressed = false;
                    this.setOriginalData();
                }
            } else {
                this.rowDataOffset_ = -1;
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("HY000", e);
        }
        for (int i = 0; i < this.translated_.length; ++i) {
            this.translated_[i] = false;
        }
    }

    public int findField(String name) throws SQLException {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = JDUtilities.stripOuterDoubleQuotes(name);
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                if (!name.equals(this.getFieldName(i))) continue;
                return i;
            }
        } else {
            Integer x;
            if (this.insensitiveColumnNames_ == null) {
                this.insensitiveColumnNames_ = new Hashtable(this.sqlData_.length);
                for (int i = this.sqlData_.length; i >= 1; --i) {
                    String cName = this.getFieldName(i);
                    this.insensitiveColumnNames_.put(cName, new Integer(i));
                }
            }
            if ((x = (Integer)this.insensitiveColumnNames_.get(name)) != null) {
                return x;
            }
            String upperCaseName = name.toUpperCase();
            x = (Integer)this.insensitiveColumnNames_.get(upperCaseName);
            if (x != null) {
                this.insensitiveColumnNames_.put(name, x);
                return x;
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Did not find column " + name);
            StringBuffer sb = new StringBuffer();
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                sb.append("[" + i + "]=" + this.getFieldName(i) + " ");
            }
            JDTrace.logInformation(this, "Columns are " + sb.toString());
        }
        JDError.throwSQLException("42703");
        return -1;
    }

    public int getFieldCount() {
        return this.sqlData_.length;
    }

    public int getFieldLOBLocatorHandle(int index) throws SQLException {
        return this.lobLocatorHandles_[index - 1];
    }

    public String getFieldName(int index) throws SQLException {
        try {
            boolean reorder;
            int index0 = index - 1;
            if (this.fieldNames_[index0] == null) {
                String thisFieldName = this.serverFormat_.getFieldName(index0, this.connection_.getConverter(this.serverFormat_.getFieldNameCCSID(index0)));
                if (thisFieldName.length() > 0) {
                    thisFieldName = JDUtilities.trimTrailingSpace(thisFieldName);
                }
                this.fieldNames_[index0] = thisFieldName;
            }
            if (reorder = this.connection_.getProperties().getBoolean(60)) {
                String value_ = this.fieldNames_[index0];
                value_ = AS400BidiTransform.convertDataFromHostCCSID(value_, this.connection_, this.serverFormat_.getFieldNameCCSID(index0));
                return value_;
            }
            return this.fieldNames_[index0];
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("07009", e);
            return null;
        }
    }

    public String getSQLTypeName(int index) throws SQLException {
        try {
            boolean reorder;
            int index0 = index - 1;
            if (this.sqlTypeNames_[index0] == null) {
                int ccsid = this.serverFormat_.getUDTNameCCSID(index0);
                if (ccsid > -1) {
                    if (ccsid == 0) {
                        ccsid = 37;
                    }
                    this.sqlTypeNames_[index0] = this.serverFormat_.getUDTName(index0, this.connection_.getConverter(ccsid)).trim();
                }
                if (this.sqlTypeNames_[index0] == null) {
                    this.sqlTypeNames_[index0] = this.sqlData_[index0].getTypeName();
                }
            }
            if (this.sqlTypeNames_[index0] != null && (reorder = this.connection_.getProperties().getBoolean(60))) {
                String value_ = this.sqlTypeNames_[index0];
                value_ = AS400BidiTransform.convertDataFromHostCCSID(value_, this.connection_, this.serverFormat_.getFieldNameCCSID(index0));
                return value_;
            }
            return this.sqlTypeNames_[index0];
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("07009", e);
            return null;
        }
    }

    public SQLData getSQLData(int index) throws SQLException {
        try {
            int index0 = index - 1;
            if (this.rowIndex_ >= 0 && !this.translated_[index0]) {
                ConvTable ccsidConverter = this.connection_.getConverter(this.ccsids_[index0]);
                if (this.rawBytes_ != null) {
                    if (this.sqlData_[index0].getType() == 2003) {
                        int outputIndex0 = this.getVariableOutputIndex(index0);
                        int arrayCount = ((DBVariableData)this.serverData_).getIndicatorCountsFromHost()[outputIndex0];
                        ((SQLArray)this.sqlData_[index0]).setArrayCount(arrayCount);
                        this.sqlData_[index0].convertFromRawBytes(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[index0], ccsidConverter);
                        for (int i = 0; i < arrayCount; ++i) {
                            if (this.serverData_ == null || this.serverData_.getIndicator(this.rowIndex_, outputIndex0, i) != -1) continue;
                            ((SQLArray)this.sqlData_[index0]).setElementNull(i);
                        }
                    } else {
                        try {
                            this.sqlData_[index0].convertFromRawBytes(this.rawBytes_, this.rowDataOffset_ + this.dataOffset_[index0], ccsidConverter);
                        }
                        catch (NumberFormatException nfe) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Caught number format exception rowDataOffset_=" + this.rowDataOffset_ + " dataOffset_[" + index0 + "]=" + this.dataOffset_[index0]);
                                for (int i = 0; i < this.dataOffset_.length; ++i) {
                                    JDTrace.logInformation(this, "....dataOffset_[" + i + "]=" + this.dataOffset_[i]);
                                }
                                JDTrace.logInformation(this, "....rowIndex_=" + this.rowIndex_);
                                this.serverData_.logInformation("...");
                            }
                            throw nfe;
                        }
                    }
                    this.translated_[index0] = true;
                }
            }
            return this.sqlData_[index0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return null;
        }
    }

    int getVariableOutputIndex(int index) throws SQLException {
        int newIndex = 0;
        for (int x = 0; x <= index; ++x) {
            if (!this.isOutput(x + 1)) continue;
            ++newIndex;
        }
        return newIndex - 1;
    }

    public SQLData getSQLType(int index) throws SQLException {
        return this.sqlData_[index - 1];
    }

    public boolean isDataMappingError(int index) throws SQLException {
        try {
            int outputIndex = index;
            if (this.serverData_ instanceof DBVariableData) {
                outputIndex = this.getVariableOutputIndex(index - 1) + 1;
            }
            return this.serverData_ != null && this.serverData_.getIndicator(this.rowIndex_, outputIndex - 1) == -2;
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("07009", e);
            return false;
        }
    }

    public boolean isNull(int index) throws SQLException {
        try {
            int outputIndex = index;
            if (this.serverData_ instanceof DBVariableData) {
                outputIndex = this.getVariableOutputIndex(index - 1) + 1;
            }
            return this.serverData_ != null && this.serverData_.getIndicator(this.rowIndex_, outputIndex - 1) == -1;
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("07009", e);
            return false;
        }
    }

    public int isNullable(int index) throws SQLException {
        try {
            return (this.sqlTypes_[index - 1] & 1) != 0 ? 1 : 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return 0;
        }
    }

    public int getCCSID(int index) throws SQLException {
        return this.ccsids_[index - 1];
    }

    public int getLength(int index) throws SQLException {
        return this.dataLength_[index - 1];
    }

    public int getArrayDataLength(int index) {
        return this.arrayDataLength_[index - 1];
    }

    int getRowLength() throws SQLException {
        try {
            return this.serverFormat_.getRecordSize();
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException("07009", e);
            return -1;
        }
    }

    private synchronized void initParmTypes() {
        int count = this.getFieldCount();
        this.parameterTypes_ = new int[count];
        for (int i = 0; i < count; ++i) {
            this.parameterTypes_[i] = -1;
        }
    }

    boolean isInput(int index) throws SQLException {
        int i;
        if (this.parameterTypes_ == null) {
            this.initParmTypes();
        }
        if (this.parameterTypes_[i = index - 1] == -1) {
            try {
                this.parameterTypes_[i] = this.serverFormat_.getFieldParameterType(i) & 0xFF;
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("07009", e);
            }
        }
        return this.parameterTypes_[i] == 240 || this.parameterTypes_[i] == 242;
    }

    boolean isOutput(int index) throws SQLException {
        int i;
        if (this.parameterTypes_ == null) {
            this.initParmTypes();
        }
        if (this.parameterTypes_[i = index - 1] == -1) {
            try {
                this.parameterTypes_[i] = this.serverFormat_.getFieldParameterType(i) & 0xFF;
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException("07009", e);
            }
        }
        return this.parameterTypes_[i] == 241 || this.parameterTypes_[i] == 242;
    }

    public void updateSettings(SQLConversionSettings settings) {
        if (this.sqlData_ != null) {
            for (int i = 0; i < this.sqlData_.length; ++i) {
                this.sqlData_[i].updateSettings(settings);
            }
        }
    }

    public void restoreSavedParameters(JDServerRow parameterRow_) {
        SQLData[] oldSqlData = parameterRow_.sqlData_;
        for (int i = 0; i < this.sqlData_.length; ++i) {
            if (i >= oldSqlData.length) continue;
            try {
                Object object;
                SQLData oldOne = oldSqlData[i];
                Calendar calendar = AS400Calendar.getGregorianInstance();
                int scale = oldOne.getScale();
                if (oldOne instanceof SQLLocator) {
                    ((SQLLocator)this.sqlData_[i]).setHandle(this.getFieldLOBLocatorHandle(i + 1));
                    object = oldOne.getSavedValue();
                    this.sqlData_[i].set(object, calendar, scale);
                    continue;
                }
                object = oldOne.getSavedValue();
                this.sqlData_[i].set(object, calendar, scale);
                continue;
            }
            catch (SQLException e) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logException(this, "Restoring parameters", e);
            }
        }
    }

    public void saveValues() throws SQLException {
        for (int i = 0; i < this.sqlData_.length; ++i) {
            this.sqlData_[i].saveValue();
        }
    }
}

