/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.KeyedDataQueueEntry;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class KeyedDataQueue
extends BaseDataQueue {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    int keyLength_ = 0;

    public KeyedDataQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing KeyedDataQueue object.");
        }
    }

    public KeyedDataQueue(AS400 system, String path) {
        super(system, path);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing KeyedDataQueue object.");
        }
    }

    private byte[] convertKey(String key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        int keyLength = this.getKeyLength();
        byte[] keyBytes = this.stringToByteArray(key);
        if (keyBytes.length == keyLength) {
            return keyBytes;
        }
        if (keyBytes.length < keyLength) {
            byte[] copy = new byte[keyLength];
            System.arraycopy(keyBytes, 0, copy, 0, keyBytes.length);
            return copy;
        }
        Trace.log(2, "Length of parameter 'key' is not valid: " + key);
        throw new ExtendedIllegalArgumentException("key (" + key + ")", 1);
    }

    public void clear(byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing keyed data queue.");
        }
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (key.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", key.length);
            throw new ExtendedIllegalArgumentException("key.length (" + key.length + ")", 1);
        }
        this.open();
        this.impl_.clear(key);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(0);
        }
    }

    public void clear(String key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        this.clear(this.convertKey(key));
    }

    public void create(int keyLength, int maxEntryLength) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.create(keyLength, maxEntryLength, "*LIBCRTAUT", false, false, "");
    }

    public void create(int keyLength, int maxEntryLength, String authority, boolean saveSenderInformation, boolean forceToAuxiliaryStorage, String description) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating keyed data queue.");
        }
        if (keyLength < 1 || keyLength > 256) {
            Trace.log(2, "Value of parameter 'keyLength' is not valid:", keyLength);
            throw new ExtendedIllegalArgumentException("keyLength (" + keyLength + ")", 4);
        }
        if (maxEntryLength < 1 || maxEntryLength > 64512) {
            Trace.log(2, "Value of parameter 'maxEntryLength' is not valid:", maxEntryLength);
            throw new ExtendedIllegalArgumentException("maxEntryLength (" + maxEntryLength + ")", 4);
        }
        if (authority == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        if (!((authority = authority.toUpperCase().trim()).equals("*LIBCRTAUT") || authority.equals("*ALL") || authority.equals("*CHANGE") || authority.equals("*EXCLUDE") || authority.equals("*USE"))) {
            Trace.log(2, "Value of parameter 'authority' is not valid: " + authority);
            throw new ExtendedIllegalArgumentException("authority (" + authority + ")", 2);
        }
        if (description == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (description.length() > 50) {
            Trace.log(2, "Length of parameter 'description' is not valid: " + description);
            throw new ExtendedIllegalArgumentException("description (" + description + ")", 1);
        }
        this.chooseImpl();
        this.attributesRetrieved_ = false;
        this.maxEntryLength_ = maxEntryLength;
        this.saveSenderInformation_ = saveSenderInformation;
        this.FIFO_ = true;
        this.forceToAuxiliaryStorage_ = forceToAuxiliaryStorage;
        this.description_ = description;
        this.keyLength_ = keyLength;
        this.impl_.create(maxEntryLength, authority, saveSenderInformation, true, keyLength, forceToAuxiliaryStorage, description);
        if (this.objectListeners_ != null) {
            this.fireObjectEvent(1);
        }
        this.attributesRetrieved_ = true;
    }

    public int getKeyLength() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting key length.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Key length:", this.keyLength_);
        }
        return this.keyLength_;
    }

    public KeyedDataQueueEntry peek(byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.peek(key, 0, "EQ");
    }

    public KeyedDataQueueEntry peek(byte[] key, int wait, String searchType) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Peeking keyed data queue.");
        }
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (key.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", key.length);
            throw new ExtendedIllegalArgumentException("key.length (" + key.length + ")", 1);
        }
        if (wait < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", wait);
            throw new ExtendedIllegalArgumentException("wait (" + wait + ")", 2);
        }
        if (searchType == null) {
            Trace.log(2, "Parameter 'searchType' is null.");
            throw new NullPointerException("searchType");
        }
        String search = searchType.toUpperCase();
        if (!(search.equals("EQ") || search.equals("NE") || search.equals("LT") || search.equals("LE") || search.equals("GT") || search.equals("GE"))) {
            Trace.log(2, "Value of parameter 'searchType' is not valid: " + searchType);
            throw new ExtendedIllegalArgumentException("searchType (" + searchType + ")", 2);
        }
        this.open();
        DQReceiveRecord record = this.impl_.read(search, wait, true, key);
        if (record == null) {
            return null;
        }
        KeyedDataQueueEntry entry = new KeyedDataQueueEntry(this, record.key_, record.data_, record.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(1);
        }
        return entry;
    }

    public KeyedDataQueueEntry peek(String key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.peek(key, 0, "EQ");
    }

    public KeyedDataQueueEntry peek(String key, int wait, String searchType) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        return this.peek(this.convertKey(key), wait, searchType);
    }

    public KeyedDataQueueEntry read(byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.read(key, 0, "EQ");
    }

    public KeyedDataQueueEntry read(byte[] key, int wait, String searchType) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Reading data queue.");
        }
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (key.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", key.length);
            throw new ExtendedIllegalArgumentException("key.length (" + key.length + ")", 1);
        }
        if (wait < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", wait);
            throw new ExtendedIllegalArgumentException("wait (" + wait + ")", 2);
        }
        if (searchType == null) {
            Trace.log(2, "Parameter 'searchType' is null.");
            throw new NullPointerException("searchType");
        }
        String search = searchType.toUpperCase();
        if (!(search.equals("EQ") || search.equals("NE") || search.equals("LT") || search.equals("LE") || search.equals("GT") || search.equals("GE"))) {
            Trace.log(2, "Value of parameter 'searchType' is not valid: " + searchType);
            throw new ExtendedIllegalArgumentException("searchType (" + searchType + ")", 2);
        }
        this.open();
        DQReceiveRecord record = this.impl_.read(search, wait, false, key);
        if (record == null) {
            return null;
        }
        KeyedDataQueueEntry entry = new KeyedDataQueueEntry(this, record.key_, record.data_, record.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(2);
        }
        return entry;
    }

    public KeyedDataQueueEntry read(String key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.read(key, 0, "EQ");
    }

    public KeyedDataQueueEntry read(String key, int wait, String searchType) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        return this.read(this.convertKey(key), wait, searchType);
    }

    void retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving keyed data queue attributes.");
        }
        DQQueryRecord record = this.impl_.retrieveAttributes(true);
        this.maxEntryLength_ = record.maxEntryLength_;
        this.saveSenderInformation_ = record.saveSenderInformation_;
        this.FIFO_ = true;
        this.forceToAuxiliaryStorage_ = record.forceToAuxiliaryStorage_;
        this.description_ = record.description_;
        this.keyLength_ = record.keyLength_;
        this.attributesRetrieved_ = true;
    }

    public String toString() {
        return "KeyedDataQueue " + super.toString();
    }

    public void write(byte[] key, byte[] data) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing keyed data queue.");
        }
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (key.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", key.length);
            throw new ExtendedIllegalArgumentException("key.length (" + key.length + ")", 1);
        }
        if (data == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        if (data.length > 64512) {
            Trace.log(2, "Length of parameter 'data' is not valid:", data.length);
            throw new ExtendedIllegalArgumentException("data.length (" + data.length + ")", 1);
        }
        this.open();
        this.impl_.write(key, data);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(3);
        }
    }

    public void write(String key, String data) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (key == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (data == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        this.write(this.convertKey(key), this.stringToByteArray(data));
    }
}

