/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPAttribute;
import java.io.Serializable;

class NPAttrFloat
extends NPAttribute
implements Cloneable,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final int DIGITS = 15;
    private static final int DECIMALPT = 5;
    private float attrValue_;

    NPAttrFloat(NPAttrFloat attr) {
        super(attr);
        this.attrValue_ = attr.attrValue_;
    }

    NPAttrFloat(int ID) {
        super(ID, 7);
    }

    NPAttrFloat(int ID, float value) {
        super(ID, 7);
        this.set(value);
    }

    NPAttrFloat(int ID, byte[] hostDataStream, int offset, int length) {
        super(ID, 7, hostDataStream, offset, length, null);
        this.buildFloatFromHostData();
    }

    private void buildHostData() {
        double MyNumber = Math.abs(this.attrValue_);
        MyNumber += 1.0E-6;
        int needed = 8;
        int byteIndex = needed - 1;
        byte[] hostValue = new byte[needed];
        double mult = Math.pow(10.0, 5.0);
        hostValue[byteIndex] = this.attrValue_ < 0.0f ? 13 : 15;
        boolean fHighNibble = true;
        for (int position = -5; position < 10; ++position) {
            int digit = (int)(MyNumber * mult) % 10;
            mult /= 10.0;
            if (!fHighNibble) {
                hostValue[byteIndex] = (byte)digit;
            } else {
                int n = byteIndex--;
                hostValue[n] = (byte)(hostValue[n] | (byte)digit << 4);
            }
            fHighNibble = !fHighNibble;
        }
        super.setHostData(hostValue, null);
    }

    private void buildFloatFromHostData() {
        int needed = 8;
        this.attrValue_ = 0.0f;
        byte[] hostData = super.getHostData(null);
        if (hostData != null) {
            int j;
            int byteIndex = 0;
            double mult = Math.pow(10.0, 9.0);
            boolean fHighNibble = true;
            for (int i = 0; i < 15; ++i) {
                if (fHighNibble) {
                    j = hostData[byteIndex] >> 4;
                    j &= 0xF;
                } else {
                    j = hostData[byteIndex] & 0xF;
                    ++byteIndex;
                }
                fHighNibble = !fHighNibble;
                this.attrValue_ += (float)j * (float)mult;
                mult /= 10.0;
            }
            j = hostData[byteIndex] & 0xF;
            if (j == 13) {
                this.attrValue_ = (float)((double)this.attrValue_ * -1.0);
            }
        }
    }

    protected Object clone() {
        NPAttrFloat attr = new NPAttrFloat(this);
        return attr;
    }

    float get() {
        return this.attrValue_;
    }

    void set(float value) {
        this.attrValue_ = value;
        this.buildHostData();
    }

    void setHostData(byte[] data, ConverterImpl converter) {
        super.setHostData(data, converter);
        this.buildFloatFromHostData();
    }
}

