/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelRes;
import com.ibm.as400.access.Trace;

class NPCPIDAFPResource
extends NPCPID
implements Cloneable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    NPCPIDAFPResource(NPCPIDAFPResource cp) {
        super(cp);
    }

    NPCPIDAFPResource() {
        super(15);
    }

    NPCPIDAFPResource(byte[] data) {
        super(15, data);
    }

    NPCPIDAFPResource(String resourceName, String resourceLib, String resourceType) {
        super(15);
        int intResourceType = 0;
        this.setAttrValue(175, resourceName);
        this.setAttrValue(174, resourceLib);
        try {
            intResourceType = NPCPSelRes.stringTypeToIntType(resourceType);
        }
        catch (ExtendedIllegalArgumentException e) {
            Trace.log(2, "Parameter 'resource' has a invalid object type.");
            throw new IllegalPathNameException(resourceType, 1);
        }
        this.setAttrValue(176, intResourceType);
    }

    protected Object clone() {
        NPCPIDAFPResource cp = new NPCPIDAFPResource(this);
        return cp;
    }

    String getResourceType() {
        int type = this.getIntValue(176);
        return NPCPSelRes.intTypeToStringType(type);
    }

    String library() {
        return this.getStringValue(174);
    }

    String name() {
        return this.getStringValue(175);
    }
}

