/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NetServer;
import com.ibm.as400.access.NetServerConnection;
import com.ibm.as400.access.NetServerFileShare;
import com.ibm.as400.access.NetServerPrintShare;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ArrayResourceList;
import com.ibm.as400.resource.ChangeableResource;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramAttributeSetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Vector;

public abstract class NetServerShare
extends ChangeableResource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServerShare";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    static ProgramMap getterMap_ = new ProgramMap();
    static final String OLST0100_ = "qzlsolst_zlsl0100";
    static final int ZLSL0100_MAX_RECORD_LENGTH_ = 1188;
    static final int[] INDICES_ = new int[]{0};
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String USER_COUNT = "USER_COUNT";
    static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    static ProgramCallDocument staticDocument_;
    ProgramCallDocument document_;
    static final int FILE_SHARE = 0;
    static final int PRINT_SHARE = 1;
    static final int ALL_SHARES = -1;
    private String name_;
    private Object[] attrsToSetFirst_;
    private ProgramAttributeGetter attributeGetter_;
    private ProgramAttributeSetter attributeSetter_;

    NetServerShare() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    NetServerShare(AS400 system, String name) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setName(name);
    }

    public abstract void add() throws ResourceException;

    protected void commitAttributeChanges(Object[] attributeIDs, Object[] values) throws ResourceException {
        super.commitAttributeChanges(attributeIDs, values);
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeSetter_.setValues(attributeIDs, values);
    }

    static Object computeResourceKey(AS400 system, String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NetServerShare.class);
        buffer.append(':');
        buffer.append(system.getSystemName());
        buffer.append(':');
        buffer.append(name);
        return buffer.toString();
    }

    protected abstract void establishConnection() throws ResourceException;

    abstract void establishConnection(boolean var1) throws ResourceException;

    void establishConnection(ProgramMap setterMap, Object[] attributesToSetFirst, boolean initializeSetterFromSystem) throws ResourceException {
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        super.establishConnection();
        this.attrsToSetFirst_ = attributesToSetFirst;
        AS400 system = this.getSystem();
        if (this.document_ == null) {
            this.document_ = (ProgramCallDocument)staticDocument_.clone();
        }
        try {
            this.document_.setSystem(system);
            this.document_.setValue("qzlsolst_zlsl0100.informationQualifier", this.name_);
            this.attributeGetter_ = new ProgramAttributeGetter(system, this.document_, getterMap_);
            this.attributeSetter_ = new ProgramAttributeSetter(this.getSystem(), this.document_, setterMap);
            if (initializeSetterFromSystem) {
                this.attributeSetter_.initializeAttributeValues(this.attributeGetter_, this.attrsToSetFirst_);
            }
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when establishing connection to share.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    protected void freezeProperties() throws ResourceException {
        if (this.getSystem() == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.name_);
        presentation.setFullName(this.name_);
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServerShare.computeResourceKey(this.getSystem(), this.name_));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    public Object getAttributeUnchangedValue(Object attributeID) throws ResourceException {
        Object value = super.getAttributeUnchangedValue(attributeID);
        if (value == null) {
            if (!this.isConnectionEstablished()) {
                this.establishConnection();
            }
            value = this.attributeGetter_.getValue(attributeID);
        }
        return value;
    }

    public String getName() {
        return this.name_;
    }

    static ResourceList list(AS400 system, int desiredShareType, String qualifier, ProgramMap openListAttributeMap) throws ResourceException {
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(system);
            String programName = OLST0100_;
            document.setValue(programName + ".informationQualifier", qualifier);
            int expectedInfoLength = 11880;
            document.setIntValue(programName + ".lengthOfReceiverVariable", expectedInfoLength);
            NetServer.callListProgram(document, programName, false);
            int recCount = document.getIntValue(programName + ".listInformation.recordsReturned");
            Vector<NetServerShare> shares = new Vector<NetServerShare>();
            String prefix = programName + ".receiverVariable.";
            int index = 0;
            int[] indices = new int[1];
            Object[] attributeIDs = openListAttributeMap.getIDs();
            for (int i = 0; i < recCount; ++i) {
                indices[0] = i;
                int size = document.getIntValue(prefix + "lengthOfThisEntry", indices);
                String shareName = (String)document.getValue(prefix + "shareName", indices);
                int shareType = document.getIntValue(prefix + "deviceType", indices);
                NetServerShare share = null;
                switch (shareType) {
                    case 0: {
                        if (desiredShareType != shareType && desiredShareType != -1) break;
                        share = new NetServerFileShare(system, shareName);
                        break;
                    }
                    case 1: {
                        if (desiredShareType != shareType && desiredShareType != -1) break;
                        share = new NetServerPrintShare(system, shareName);
                        break;
                    }
                    default: {
                        Trace.log(2, "Bad value returned for shareType for share " + shareName + ": " + shareType);
                        throw new InternalErrorException(10);
                    }
                }
                if (share != null) {
                    Object[] values = openListAttributeMap.getValues(attributeIDs, system, document, null, indices);
                    for (int ii = 0; ii < values.length; ++ii) {
                        share.initializeAttributeValue(attributeIDs[ii], values[ii]);
                    }
                    share.freezeProperties();
                    shares.addElement(share);
                }
                index += size;
            }
            Presentation presentation = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
            switch (desiredShareType) {
                case 0: {
                    Object[] fsArray = new NetServerFileShare[shares.size()];
                    shares.copyInto(fsArray);
                    return new ArrayResourceList((Resource[])fsArray, presentation, NetServerShare.getAttributeMetaDataStatic());
                }
                case 1: {
                    Object[] psArray = new NetServerPrintShare[shares.size()];
                    shares.copyInto(psArray);
                    return new ArrayResourceList((Resource[])psArray, presentation, NetServerShare.getAttributeMetaDataStatic());
                }
                case -1: {
                    Object[] array = new NetServerShare[shares.size()];
                    shares.copyInto(array);
                    return new ArrayResourceList((Resource[])array, presentation, NetServerShare.getAttributeMetaDataStatic());
                }
            }
            Trace.log(2, "Bad value for 'desiredShareType': " + desiredShareType);
            throw new InternalErrorException(10);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when listing shares.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    public ResourceList listConnections() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        return NetServerConnection.listConnectionsForShare(this.getSystem(), this.name_);
    }

    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeGetter_.clearBuffer();
        this.attributeSetter_.initializeAttributeValues(this.attributeGetter_, this.attrsToSetFirst_);
        super.refreshAttributeValues();
    }

    public void remove() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection(false);
        }
        NetServerShare.remove(this.getSystem(), this.name_);
        this.fireResourceDeleted();
    }

    static void remove(AS400 system, String shareName) throws ResourceException {
        try {
            ProgramCallDocument document = (ProgramCallDocument)staticDocument_.clone();
            document.setSystem(system);
            document.setValue("qzlsrms.shareName", shareName);
            if (!document.callProgram("qzlsrms")) {
                throw new ResourceException(document.getMessageList("qzlsrms"));
            }
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when removing a share.", (Throwable)e);
            throw new ResourceException(e);
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String oldValue = this.name_;
        this.name_ = name;
        this.firePropertyChange("name", oldValue, name);
    }

    static {
        attributes_.add((Object)DESCRIPTION, String.class, "");
        getterMap_.add((Object)DESCRIPTION, OLST0100_, "receiverVariable.description", INDICES_);
        attributes_.add((Object)USER_COUNT, Integer.class, true);
        getterMap_.add((Object)USER_COUNT, OLST0100_, "receiverVariable.currentUsers", INDICES_);
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException e) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)e);
        }
    }
}

