/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IntegerHashtable;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JobHashtable;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ObjectLockListEntry;
import com.ibm.as400.access.Product;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ObjectDescription {
    private static final String USERSPACE_NAME = "JT4WCLOBJLQTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4WCLOBJL.USRSPC";
    private static final String FORMAT_NAME = "OBJL0100";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    public static final int ALLOW_CHANGE_BY_PROGRAM = 308;
    public static final int APAR = 413;
    public static final String ASP_NAME_ALL = "*";
    public static final String ASP_NAME_SYSBAS = "*SYSBAS";
    public static final String ASP_NAME_CURASPGRP = "*CURASPGRP";
    public static final String ASP_NAME_ALLAVL = "*ALLAVL";
    public static final String ASP_NAME_UNKNOWN = "*N";
    public static final String ASP_SEARCH_TYPE_ASP = "*ASP";
    public static final String ASP_SEARCH_TYPE_ASPGRP = "*ASPGRP";
    public static final int AUDITING = 310;
    public static final String AUDITING_ALL = "*ALL";
    public static final String AUDITING_CHANGE = "*CHANGE";
    public static final String AUDITING_NONE = "*NONE";
    public static final String AUDITING_USER_PROFILE = "*USRPRF";
    public static final int CHANGE_DATE = 305;
    public static final int CHANGED_BY_PROGRAM = 309;
    static final int COMBINATION_200 = 200;
    static final int COMBINATION_300 = 300;
    static final int COMBINATION_400 = 400;
    static final int COMBINATION_500 = 500;
    static final int COMBINATION_600 = 600;
    static final int COMBINATION_700 = 700;
    public static final int COMPILER = 408;
    public static final int COMPRESSION = 307;
    public static final String COMPRESSION_INELIGIBLE = "X";
    public static final String COMPRESSION_NO = "N";
    public static final String COMPRESSION_STORAGE_FREED = "F";
    public static final String COMPRESSION_TEMPORARY = "T";
    public static final String COMPRESSION_YES = "Y";
    public static final int CREATION_DATE = 304;
    public static final int CREATOR_SYSTEM = 406;
    public static final int CREATOR_USER_PROFILE = 405;
    public static final String CURRENT_LIBRARY = "*CURLIB";
    public static final int DAYS_USED = 603;
    public static final int DIGITALLY_SIGNED = 311;
    public static final int DIGITALLY_SIGNED_MULTIPLE = 313;
    public static final int DIGITALLY_SIGNED_TRUSTED = 312;
    public static final int DOMAIN = 303;
    public static final String DOMAIN_SYSTEM = "*S";
    public static final String DOMAIN_USER = "*U";
    public static final int EXTENDED_ATTRIBUTE = 202;
    static final int INFORMATION_STATUS = 201;
    public static final int JOURNAL_STATUS = 513;
    public static final int JOURNAL = 514;
    static final int JOURNAL_LIBRARY = 515;
    public static final int JOURNAL_IMAGES = 516;
    public static final int JOURNAL_OMITTED_ENTRIES = 517;
    public static final int JOURNAL_START_DATE = 518;
    public static final int LAST_USED_DATE = 601;
    public static final int LIBRARY = 10001;
    public static final int LIBRARY_ASP_DEVICE_NAME = 606;
    public static final int LIBRARY_ASP_NUMBER = 314;
    public static final String LIBRARY_LIST = "*LIBL";
    public static final int LICENSED_PROGRAM = 411;
    public static final int NAME = 10000;
    public static final int OBJECT_ASP_DEVICE_NAME = 605;
    public static final int OBJECT_ASP_NUMBER = 301;
    public static final int OBJECT_LEVEL = 409;
    public static final int OBJECT_SIZE = 701;
    static final int OBJECT_SIZE_MULTIPLIER = 702;
    public static final int ORDER_IN_LIBRARY_LIST = 205;
    public static final int OVERFLOWED_ASP = 703;
    public static final int OWNER = 302;
    public static final int PRIMARY_GROUP = 414;
    public static final String PRIMARY_GROUP_NONE = "*NONE";
    public static final int PTF = 412;
    public static final int RESET_DATE = 602;
    public static final int RESTORE_DATE = 502;
    public static final int SAVE_ACTIVE_DATE = 512;
    public static final int SAVE_COMMAND = 506;
    public static final int SAVE_DATE = 501;
    public static final int SAVE_DEVICE = 508;
    public static final String SAVE_DEVICE_DISKETTE = "*DKT";
    public static final String SAVE_DEVICE_NOT_SAVED = "";
    public static final String SAVE_DEVICE_OPTICAL = "*OPT";
    public static final String SAVE_DEVICE_SAVE_FILE = "*SAVF";
    public static final String SAVE_DEVICE_TAPE = "*TAP";
    public static final int SAVE_FILE = 509;
    static final int SAVE_FILE_LIBRARY = 510;
    public static final int SAVE_LABEL = 511;
    public static final int SAVE_SEQUENCE_NUMBER = 505;
    public static final int SAVE_SIZE = 503;
    static final int SAVE_SIZE_MULTIPLIER = 504;
    public static final int SAVE_VOLUME_ID = 507;
    public static final int SOURCE_FILE = 401;
    static final int SOURCE_FILE_LIBRARY = 402;
    static final int SOURCE_FILE_MEMBER = 403;
    public static final int SOURCE_FILE_UPDATED_DATE = 404;
    public static final byte STATUS_DAMAGED = -60;
    public static final byte STATUS_LOCKED = -45;
    public static final byte STATUS_NO_AUTHORITY = -63;
    public static final byte STATUS_NO_ERRORS = 64;
    public static final byte STATUS_PARTIALLY_DAMAGED = -41;
    public static final byte STATUS_UNKNOWN = 0;
    public static final int STORAGE_STATUS = 306;
    public static final String STORAGE_STATUS_FREE = "*FREE";
    public static final String STORAGE_STATUS_KEEP = "*KEEP";
    public static final int SYSTEM_LEVEL = 407;
    public static final String SYSTEM_OR_BASIC_ASP = "*SYSBAS";
    public static final int TEXT_DESCRIPTION = 203;
    public static final int TYPE = 10002;
    public static final int USAGE_INFO_UPDATED = 604;
    public static final int USER_CHANGED = 410;
    public static final int USER_DEFINED_ATTRIBUTE = 204;
    static final IntegerHashtable keyLengths_ = new IntegerHashtable();
    private AS400 system_;
    private QSYSObjectPathName path_;
    private String aspSearchType_ = "*ASP";
    private byte status_;
    private transient AS400Timestamp timestampConverter_;
    private final JobHashtable values_ = new JobHashtable();
    private static final int FORMAT_DTS = 1;

    public ObjectDescription(AS400 system, String path) {
        this(system, new QSYSObjectPathName(path));
    }

    public ObjectDescription(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.path_ = path;
    }

    public ObjectDescription(AS400 system, String objectLibrary, String objectName, String objectType) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (objectLibrary == null) {
            throw new NullPointerException("library");
        }
        if (objectName == null) {
            throw new NullPointerException("name");
        }
        if (objectType == null) {
            throw new NullPointerException("type");
        }
        this.system_ = system;
        this.path_ = new QSYSObjectPathName(objectLibrary, objectName, objectType);
    }

    public ObjectDescription(AS400 system, String objectLibrary, String objectName, String objectType, String aspDeviceName) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (objectLibrary == null) {
            throw new NullPointerException("library");
        }
        if (objectName == null) {
            throw new NullPointerException("name");
        }
        if (objectType == null) {
            throw new NullPointerException("type");
        }
        this.system_ = system;
        this.path_ = new QSYSObjectPathName(objectLibrary, objectName, objectType);
        if (aspDeviceName != null && aspDeviceName.length() != 0) {
            try {
                this.path_.setAspName(aspDeviceName);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    ObjectDescription(AS400 sys, String lib, String name, String type, byte status) {
        this.system_ = sys;
        this.path_ = new QSYSObjectPathName(lib, name, type);
        this.status_ = status;
    }

    ObjectDescription(AS400 sys, String lib, String name, String type, byte status, String aspDeviceName, String aspSearchType) {
        this.system_ = sys;
        this.path_ = new QSYSObjectPathName(lib, name, type);
        this.status_ = status;
        if (aspDeviceName != null && aspDeviceName.length() != 0) {
            try {
                this.path_.setAspName(aspDeviceName);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.aspSearchType_ = aspSearchType;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            ObjectDescription otherObj = (ObjectDescription)obj;
            if (!otherObj.getSystem().getSystemName().equals(this.system_.getSystemName())) {
                return false;
            }
            if (!otherObj.getLibrary().equals(this.getLibrary())) {
                return false;
            }
            if (!otherObj.getName().equals(this.getName())) {
                return false;
            }
            return otherObj.getType().equals(this.getType());
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, e);
            }
            return false;
        }
    }

    public int hashCode() {
        int hash = this.system_.getSystemName().hashCode() + this.getLibrary().hashCode() + this.getName().hashCode() + this.getType().hashCode();
        return hash;
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            this.retrieve(303);
        }
        catch (AS400Exception e) {
            String id = e.getAS400Message().getID().trim();
            if (id.equalsIgnoreCase("CPF9801") || id.equalsIgnoreCase("CPF9810") || id.equalsIgnoreCase("CPF9811") || id.equalsIgnoreCase("CPF9812") || id.equalsIgnoreCase("CPF9814")) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private final Date getDate(Object o) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (o instanceof String) {
            String str = ((String)o).trim();
            switch (str.length()) {
                case 7: {
                    Calendar c = AS400Calendar.getGregorianInstance();
                    c.clear();
                    c.set(Integer.parseInt(str.substring(0, 3)) + 1900, Integer.parseInt(str.substring(3, 5)) - 1, Integer.parseInt(str.substring(5, 7)));
                    return c.getTime();
                }
                case 13: {
                    Calendar c = AS400Calendar.getGregorianInstance();
                    c.clear();
                    c.set(Integer.parseInt(str.substring(0, 3)) + 1900, Integer.parseInt(str.substring(3, 5)) - 1, Integer.parseInt(str.substring(5, 7)), Integer.parseInt(str.substring(7, 9)), Integer.parseInt(str.substring(9, 11)), Integer.parseInt(str.substring(11, 13)));
                    return c.getTime();
                }
            }
            return null;
        }
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            AS400Timestamp conv = this.getTimestampConverter(1);
            return conv.toDate(conv.toTimestamp(b), TimeZone.getDefault());
        }
        return null;
    }

    public String getLibrary() {
        return this.path_.getLibraryName();
    }

    public String getName() {
        return this.path_.getObjectName();
    }

    public String getAspDeviceName() {
        return this.path_.getAspName();
    }

    public String getAspSearchType() {
        return this.aspSearchType_;
    }

    public String getPath() {
        return this.path_.getPath();
    }

    public byte getStatus() {
        return this.status_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private synchronized AS400Timestamp getTimestampConverter(int format) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(format);
        } else if (format != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(format);
        }
        return this.timestampConverter_;
    }

    public String getType() {
        return this.path_.getObjectType();
    }

    public Object getValue(int attribute) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        switch (attribute) {
            case 10000: {
                return this.getName();
            }
            case 10001: {
                return this.getLibrary();
            }
            case 10002: {
                return this.getType();
            }
        }
        Object o = this.values_.get(attribute);
        if (o == null) {
            if (attribute == 205) {
                return new Integer(-1);
            }
            this.retrieve(attribute);
            o = this.values_.get(attribute);
        }
        try {
            switch (attribute) {
                case 304: 
                case 305: 
                case 404: 
                case 501: 
                case 502: 
                case 512: 
                case 518: 
                case 601: 
                case 602: {
                    return this.getDate(o);
                }
                case 514: {
                    String name = (String)o;
                    if (name.length() > 0) {
                        String lib = (String)this.getValue(515);
                        return QSYSObjectPathName.toPath(lib, name, "JRN");
                    }
                    return name;
                }
                case 509: {
                    String name2 = (String)o;
                    if (name2.length() > 0) {
                        String lib2 = (String)this.getValue(510);
                        return QSYSObjectPathName.toPath(lib2, name2, "SAVF");
                    }
                    return name2;
                }
                case 401: {
                    String name3 = (String)o;
                    if (name3.length() > 0) {
                        String lib3 = (String)this.getValue(402);
                        String member = (String)this.getValue(403);
                        return QSYSObjectPathName.toPath(lib3, name3, member, "MBR");
                    }
                    return name3;
                }
                case 701: {
                    long multi = ((Integer)this.getValue(702)).longValue();
                    long size = ((Integer)o).longValue();
                    return new Long(multi * size);
                }
                case 503: {
                    long multi2 = ((Integer)this.getValue(504)).longValue();
                    long size2 = ((Integer)o).longValue();
                    return new Long(multi2 * size2);
                }
                case 408: 
                case 411: {
                    String lpp = (String)o;
                    if (lpp.length() == 0) {
                        return null;
                    }
                    if (lpp.length() < 16) {
                        if (Trace.traceOn_) {
                            Trace.log(4, "Disregarding COMPILER attribute value in nonstandard format: " + lpp);
                        }
                        return null;
                    }
                    String prodID = lpp.substring(0, 7);
                    StringBuffer release = new StringBuffer(6);
                    release.append('V');
                    release.append(Integer.parseInt(lpp.substring(8, 10)));
                    release.append('R');
                    release.append(Integer.parseInt(lpp.substring(11, 13)));
                    release.append('M');
                    release.append(Integer.parseInt(lpp.substring(14, 16)));
                    return new Product(this.system_, prodID, "*BASE", release.toString(), "*CODE");
                }
                case 308: 
                case 309: 
                case 311: 
                case 312: 
                case 313: 
                case 410: 
                case 513: 
                case 516: 
                case 703: {
                    return new Boolean(((String)o).charAt(0) == '1');
                }
                case 604: {
                    return new Boolean(((String)o).charAt(0) == 'Y');
                }
                case 517: {
                    return new Boolean(((String)o).charAt(0) == '0');
                }
            }
            return o;
        }
        catch (NumberFormatException e) {
            Trace.log(2, "Invalid number conversion for attribute " + attribute, (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    public String getValueAsString(int attribute) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (attribute == 408) {
            String lpp;
            Object o = this.values_.get(attribute);
            if (o == null) {
                if (attribute == 205) {
                    return "-1";
                }
                this.retrieve(attribute);
                o = this.values_.get(attribute);
            }
            if ((lpp = (String)o).length() == 0) {
                return null;
            }
            return lpp;
        }
        Object value = this.getValue(attribute);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLockListEntry[] getObjectLockList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall pc;
        boolean willRunProgramsOnThread;
        int systemCCSID = this.system_.getCcsid();
        CharConverter conv = new CharConverter(systemCCSID);
        String aspDeviceName = this.getAspDeviceName();
        ProgramParameter[] parms = new ProgramParameter[aspDeviceName.length() == 0 ? 6 : 9];
        parms[0] = new ProgramParameter(conv.stringToByteArray(USERSPACE_NAME));
        parms[1] = new ProgramParameter(conv.stringToByteArray(FORMAT_NAME));
        String objectNameBuff = this.path_.toQualifiedObjectName();
        parms[2] = new ProgramParameter(conv.stringToByteArray(objectNameBuff));
        StringBuffer objTypeBuff = new StringBuffer("*         ");
        objTypeBuff.replace(1, this.getType().length(), this.getType());
        parms[3] = new ProgramParameter(conv.stringToByteArray(objTypeBuff.toString()));
        parms[4] = new ProgramParameter(conv.stringToByteArray("*NONE     "));
        parms[5] = errorCode_;
        if (parms.length == 9) {
            parms[6] = new ProgramParameter(conv.stringToByteArray(SAVE_DEVICE_NOT_SAVED));
            parms[7] = new ProgramParameter(BinaryConverter.intToByteArray(0));
            StringBuffer aspDeviceNameBuff = new StringBuffer("          ");
            aspDeviceNameBuff.replace(0, aspDeviceName.length(), aspDeviceName);
            parms[8] = new ProgramParameter(conv.stringToByteArray(aspDeviceNameBuff.toString()));
        }
        Object lockObject = (willRunProgramsOnThread = (pc = new ProgramCall(this.system_, "/QSYS.LIB/QWCLOBJL.PGM", parms)).isStayOnThread()) ? USERSPACE_PATH : this.system_;
        byte[] buf = null;
        Object object = lockObject;
        synchronized (object) {
            UserSpace space = new UserSpace(this.system_, USERSPACE_PATH);
            space.setMustUseProgramCall(true);
            if (!willRunProgramsOnThread) {
                space.setMustUseSockets(true);
            }
            try {
                space.create(262144, true, SAVE_DEVICE_NOT_SAVED, (byte)0, "User space for UserObjectsOwnedList", "*EXCLUDE");
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                int size = space.getLength();
                if (size < 144) {
                    Trace.log(2, "User Space size is too small (" + size + ")");
                    throw new InternalErrorException(6, size);
                }
                buf = new byte[size];
                space.read(buf, 0);
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    space.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
                throw throwable;
            }
            try {
                space.delete();
            }
            catch (Exception e) {
                Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
            }
        }
        int startingOffset = BinaryConverter.byteArrayToInt(buf, 124);
        int numEntries = BinaryConverter.byteArrayToInt(buf, 132);
        int entrySize = BinaryConverter.byteArrayToInt(buf, 136);
        int entryCCSID = BinaryConverter.byteArrayToInt(buf, 140);
        String informationStatus = conv.byteArrayToString(buf, 103, 1);
        if (entryCCSID == 0) {
            entryCCSID = systemCCSID;
        }
        conv = new CharConverter(entryCCSID);
        if (Trace.traceOn_) {
            Trace.log(1, "ObjectDescription.getObjectLockList()  informationStatus='" + informationStatus + "' " + "' numEntries='" + numEntries + "'");
        }
        ObjectLockListEntry[] entries = new ObjectLockListEntry[numEntries];
        try {
            int offset = startingOffset;
            for (int i = 0; i < numEntries; ++i) {
                offset = startingOffset + i * entrySize;
                String jobName = conv.byteArrayToString(buf, offset, 10).trim();
                String jobUserName = conv.byteArrayToString(buf, offset += 10, 10).trim();
                String jobNumber = conv.byteArrayToString(buf, offset += 10, 6).trim();
                String lockState = conv.byteArrayToString(buf, offset += 6, 10).trim();
                int lockStatus = BinaryConverter.byteArrayToInt(buf, offset += 10);
                int lockType = BinaryConverter.byteArrayToInt(buf, offset += 4);
                String memberName = conv.byteArrayToString(buf, offset += 4, 10).trim();
                String share = conv.byteArrayToString(buf, offset += 10, 1).trim();
                String lockScope = conv.byteArrayToString(buf, ++offset, 1).trim();
                long threadID = BinaryConverter.byteArrayToLong(buf, ++offset);
                offset += 8;
                entries[i] = new ObjectLockListEntry(jobName, jobUserName, jobNumber, lockState, lockStatus, lockType, memberName, share, lockScope, threadID);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Trace.log(2, "Buffer from QWCLOBJL API was too small.", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
        return entries;
    }

    private static final int lookupFormat(int attribute) {
        switch (attribute) {
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 10000: 
            case 10001: 
            case 10002: {
                return 100;
            }
            case 202: 
            case 203: 
            case 401: 
            case 402: 
            case 403: {
                return 200;
            }
            case 306: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 501: 
            case 502: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 511: 
            case 602: {
                return 300;
            }
            case 204: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 414: 
            case 503: 
            case 504: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 601: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 701: 
            case 702: 
            case 703: {
                return 400;
            }
        }
        throw new ExtendedIllegalArgumentException("attribute", 2);
    }

    private static final int lookupSize(int format) {
        switch (format) {
            case 100: {
                return 90;
            }
            case 200: {
                return 180;
            }
            case 300: {
                return 460;
            }
            case 400: {
                return 667;
            }
        }
        return 0;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(313);
    }

    private void retrieve(int attribute) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int bytesAvailable;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        String aspDeviceName = this.getAspDeviceName();
        int format = ObjectDescription.lookupFormat(attribute);
        int size = ObjectDescription.lookupSize(format);
        AS400Text text10 = new AS400Text(10, ccsid, this.system_);
        ProgramParameter[] parms = new ProgramParameter[aspDeviceName.length() == 0 ? 5 : 7];
        parms[0] = new ProgramParameter(size);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(size));
        parms[2] = new ProgramParameter(conv.stringToByteArray("OBJD0" + format));
        String objectNameAndLibrary = this.path_.toQualifiedObjectName();
        parms[3] = new ProgramParameter(conv.stringToByteArray(objectNameAndLibrary));
        parms[4] = new ProgramParameter(text10.toBytes(ASP_NAME_ALL + this.getType()));
        if (parms.length == 7) {
            parms[5] = new ProgramParameter(new byte[8]);
            byte[] controlFormat = new byte[24];
            System.arraycopy(BinaryConverter.intToByteArray(24), 0, controlFormat, 0, 4);
            for (int i = 4; i < controlFormat.length; ++i) {
                controlFormat[i] = 64;
            }
            conv.stringToByteArray(aspDeviceName, controlFormat, 4);
            if (!(aspDeviceName.equals(ASP_NAME_ALL) || aspDeviceName.equals("*SYSBAS") || aspDeviceName.equals(ASP_NAME_CURASPGRP) || aspDeviceName.equals(ASP_NAME_ALLAVL))) {
                conv.stringToByteArray(this.aspSearchType_, controlFormat, 14);
            }
            parms[6] = new ProgramParameter(controlFormat);
        }
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QUSROBJD.PGM", parms);
        pc.suggestThreadsafe();
        if (!pc.run()) {
            if (this.getType().equals("MBR")) {
                Trace.log(2, "For objects of type *MBR, use MemberDescription instead of ObjectDescription", this.path_.getPath());
            }
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(data, 4))) {
            try {
                int newval = size + (bytesAvailable - bytesReturned);
                if (Trace.traceOn_) {
                    Trace.log(1, "Calling QUSROBJD again with new parm size: " + newval);
                }
                parms[0].setOutputDataLength(newval);
                parms[1].setInputData(BinaryConverter.intToByteArray(newval));
            }
            catch (PropertyVetoException pve) {
                Trace.log(2, pve);
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parms[0].getOutputData();
        }
        String name = conv.byteArrayToString(data, 8, 10).trim();
        String type = conv.byteArrayToString(data, 28, 10).trim().substring(1);
        String library = conv.byteArrayToString(data, 38, 10).trim();
        if (!(name.equals(this.getName()) && type.equals(this.getType()) && library.equals(this.getLibrary()))) {
            try {
                this.path_.setObjectName(name);
                this.path_.setObjectType(type);
                this.path_.setLibraryName(library);
                if (Trace.traceOn_) {
                    Trace.log(1, "Updated path from returned attributes", this.path_.getPath());
                }
            }
            catch (PropertyVetoException pve) {
                throw new InternalErrorException(10, (Throwable)pve);
            }
        }
        this.set(301, BinaryConverter.byteArrayToInt(data, 48));
        this.set(302, conv.byteArrayToString(data, 52, 10).trim());
        this.set(303, conv.byteArrayToString(data, 62, 2));
        this.set(304, conv.byteArrayToString(data, 64, 13));
        this.set(305, conv.byteArrayToString(data, 77, 13));
        if (format >= 200) {
            this.set(202, conv.byteArrayToString(data, 90, 10).trim());
            this.set(203, conv.byteArrayToString(data, 100, 50).trim());
            this.set(401, conv.byteArrayToString(data, 150, 10).trim());
            this.set(402, conv.byteArrayToString(data, 160, 10).trim());
            this.set(403, conv.byteArrayToString(data, 170, 10).trim());
        }
        if (format >= 300) {
            this.set(404, conv.byteArrayToString(data, 180, 13));
            this.set(501, conv.byteArrayToString(data, 193, 13));
            this.set(502, conv.byteArrayToString(data, 206, 13));
            this.set(405, conv.byteArrayToString(data, 219, 10).trim());
            this.set(406, conv.byteArrayToString(data, 229, 8).trim());
            this.set(602, conv.byteArrayToString(data, 237, 7));
            this.set(505, BinaryConverter.byteArrayToInt(data, 248));
            this.set(306, conv.byteArrayToString(data, 252, 10).trim());
            this.set(506, conv.byteArrayToString(data, 262, 10).trim());
            this.set(507, conv.byteArrayToString(data, 272, 71));
            this.set(508, conv.byteArrayToString(data, 343, 10).trim());
            this.set(509, conv.byteArrayToString(data, 353, 10).trim());
            this.set(510, conv.byteArrayToString(data, 363, 10).trim());
            this.set(511, conv.byteArrayToString(data, 373, 17).trim());
            this.set(407, conv.byteArrayToString(data, 390, 9));
            this.set(408, conv.byteArrayToString(data, 399, 16).trim());
            this.set(409, conv.byteArrayToString(data, 415, 8).trim());
            this.set(410, conv.byteArrayToString(data, 423, 1));
            this.set(411, conv.byteArrayToString(data, 424, 16).trim());
            this.set(412, conv.byteArrayToString(data, 440, 10).trim());
            this.set(413, conv.byteArrayToString(data, 450, 10).trim());
        }
        if (format >= 400) {
            this.set(601, conv.byteArrayToString(data, 460, 7).trim());
            this.set(604, conv.byteArrayToString(data, 467, 1));
            this.set(603, BinaryConverter.byteArrayToInt(data, 468));
            this.set(701, BinaryConverter.byteArrayToInt(data, 472));
            this.set(702, BinaryConverter.byteArrayToInt(data, 476));
            this.set(307, conv.byteArrayToString(data, 480, 1));
            this.set(308, conv.byteArrayToString(data, 481, 1));
            this.set(309, conv.byteArrayToString(data, 482, 1));
            this.set(204, conv.byteArrayToString(data, 483, 10).trim());
            this.set(703, conv.byteArrayToString(data, 493, 1));
            this.set(512, conv.byteArrayToString(data, 494, 13));
            this.set(310, conv.byteArrayToString(data, 507, 10).trim());
            this.set(414, conv.byteArrayToString(data, 517, 10).trim());
            this.set(513, conv.byteArrayToString(data, 527, 1));
            this.set(514, conv.byteArrayToString(data, 528, 10).trim());
            this.set(515, conv.byteArrayToString(data, 538, 10).trim());
            this.set(516, conv.byteArrayToString(data, 548, 1));
            this.set(517, conv.byteArrayToString(data, 549, 1));
            this.set(518, conv.byteArrayToString(data, 550, 13).trim());
            this.set(311, conv.byteArrayToString(data, 563, 1));
            this.set(503, BinaryConverter.byteArrayToInt(data, 564));
            this.set(504, BinaryConverter.byteArrayToInt(data, 568));
            this.set(314, BinaryConverter.byteArrayToInt(data, 572));
            this.set(605, conv.byteArrayToString(data, 576, 10).trim());
            this.set(606, conv.byteArrayToString(data, 586, 10).trim());
            this.set(312, conv.byteArrayToString(data, 596, 1));
            this.set(313, conv.byteArrayToString(data, 597, 1));
        }
    }

    void set(int attribute, int value) {
        this.values_.put(attribute, new Integer(value));
    }

    void set(int attribute, long value) {
        this.values_.put(attribute, new Long(value));
    }

    void set(int attribute, boolean value) {
        this.values_.put(attribute, new Boolean(value));
    }

    void set(int attribute, Object value) {
        this.values_.put(attribute, value);
    }

    public void setAspSearchType(String aspSearchType) throws ExtendedIllegalArgumentException {
        if (aspSearchType == null) {
            throw new NullPointerException("aspSearchType");
        }
        if (!aspSearchType.equals(ASP_SEARCH_TYPE_ASP) && !aspSearchType.equals(ASP_SEARCH_TYPE_ASPGRP)) {
            throw new ExtendedIllegalArgumentException("aspSearchType", 2);
        }
        this.aspSearchType_ = aspSearchType;
    }

    public String toString() {
        return this.getPath();
    }

    static {
        keyLengths_.put(200, 80);
        keyLengths_.put(201, 1);
        keyLengths_.put(202, 10);
        keyLengths_.put(203, 50);
        keyLengths_.put(204, 10);
        keyLengths_.put(205, 4);
        keyLengths_.put(300, 144);
        keyLengths_.put(301, 4);
        keyLengths_.put(302, 10);
        keyLengths_.put(303, 2);
        keyLengths_.put(304, 8);
        keyLengths_.put(305, 8);
        keyLengths_.put(306, 10);
        keyLengths_.put(307, 1);
        keyLengths_.put(308, 1);
        keyLengths_.put(309, 1);
        keyLengths_.put(310, 10);
        keyLengths_.put(311, 1);
        keyLengths_.put(312, 1);
        keyLengths_.put(313, 1);
        keyLengths_.put(314, 4);
        keyLengths_.put(400, 296);
        keyLengths_.put(401, 10);
        keyLengths_.put(402, 10);
        keyLengths_.put(403, 10);
        keyLengths_.put(404, 13);
        keyLengths_.put(405, 10);
        keyLengths_.put(406, 8);
        keyLengths_.put(407, 9);
        keyLengths_.put(408, 16);
        keyLengths_.put(409, 8);
        keyLengths_.put(410, 1);
        keyLengths_.put(411, 16);
        keyLengths_.put(412, 10);
        keyLengths_.put(413, 10);
        keyLengths_.put(414, 10);
        keyLengths_.put(500, 504);
        keyLengths_.put(501, 8);
        keyLengths_.put(502, 8);
        keyLengths_.put(503, 4);
        keyLengths_.put(504, 4);
        keyLengths_.put(505, 4);
        keyLengths_.put(506, 10);
        keyLengths_.put(507, 71);
        keyLengths_.put(508, 10);
        keyLengths_.put(509, 10);
        keyLengths_.put(510, 10);
        keyLengths_.put(511, 17);
        keyLengths_.put(512, 8);
        keyLengths_.put(513, 1);
        keyLengths_.put(514, 10);
        keyLengths_.put(515, 10);
        keyLengths_.put(516, 1);
        keyLengths_.put(517, 1);
        keyLengths_.put(518, 8);
        keyLengths_.put(600, 548);
        keyLengths_.put(601, 8);
        keyLengths_.put(602, 8);
        keyLengths_.put(603, 4);
        keyLengths_.put(604, 1);
        keyLengths_.put(605, 10);
        keyLengths_.put(606, 10);
        keyLengths_.put(700, 560);
        keyLengths_.put(701, 4);
        keyLengths_.put(702, 4);
        keyLengths_.put(703, 1);
    }
}

