/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSTunnelConnection;
import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.ProxyServer;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxByteParm;
import com.ibm.as400.access.PxCharParm;
import com.ibm.as400.access.PxClassParm;
import com.ibm.as400.access.PxConstructorReqSV;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDoubleParm;
import com.ibm.as400.access.PxExceptionRepSV;
import com.ibm.as400.access.PxFinalizeReqSV;
import com.ibm.as400.access.PxFloatParm;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxLoadReqSV;
import com.ibm.as400.access.PxLongParm;
import com.ibm.as400.access.PxMethodReqSV;
import com.ibm.as400.access.PxNullParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxShortParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxTable;
import com.ibm.as400.access.PxToolboxObjectParm;
import com.ibm.as400.access.PxTunnelConnectReqSV;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

class PSTunnelController {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static long nextConnectionId_ = 1000L;
    private static Object nextConnectionIdLock_ = new Object();
    private long connectionId_ = -1L;
    private PxDSFactory factory_;
    private static Hashtable clientIds_;
    private static long nextClientId_;
    private static Object nextClientIdLock_;
    private PxTable proxyTable_;
    private static Hashtable useTimes_;
    private transient long clientCleanupInterval_ = 0x6DDD00L;
    private transient long clientLifetime_ = 1800000L;
    transient TunnelProxyServerMaintenance maintenance_;

    public PSTunnelController(ProxyServer proxyServer) {
        clientIds_ = new Hashtable();
        useTimes_ = new Hashtable();
        this.proxyTable_ = new PxTable();
        this.factory_ = new PxDSFactory();
        this.factory_.register(new PxByteParm());
        this.factory_.register(new PxShortParm());
        this.factory_.register(new PxBooleanParm());
        this.factory_.register(new PxIntParm());
        this.factory_.register(new PxStringParm());
        this.factory_.register(new PxSerializedObjectParm(null));
        this.factory_.register(new PxTunnelConnectReqSV(this, clientIds_));
        this.factory_.register(new PxLoadReqSV(new PSLoad()));
        this.factory_.register(new PxLongParm());
        this.factory_.register(new PxFloatParm());
        this.factory_.register(new PxDoubleParm());
        this.factory_.register(new PxCharParm());
        this.factory_.register(new PxToolboxObjectParm());
        this.factory_.register(new PxNullParm());
        this.factory_.register(new PxClassParm());
        this.factory_.register(new PxPxObjectParm(this.proxyTable_));
        this.factory_.register(new PxConstructorReqSV(this.proxyTable_));
        this.factory_.register(new PxMethodReqSV(this.proxyTable_));
        this.factory_.register(new PxFinalizeReqSV(this.proxyTable_));
        this.initializeTransient();
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, "Px server controller " + this + " opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupConnections() {
        Hashtable hashtable = useTimes_;
        synchronized (hashtable) {
            Enumeration keys = useTimes_.keys();
            while (keys.hasMoreElements()) {
                Long key = (Long)keys.nextElement();
                long timeLastRun = (Long)useTimes_.get(key);
                if (System.currentTimeMillis() - timeLastRun <= this.clientLifetime_) continue;
                Hashtable hashtable2 = clientIds_;
                synchronized (hashtable2) {
                    clientIds_.remove(key);
                }
                useTimes_.remove(key);
                this.proxyTable_.removeClientId(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextClientId() {
        Object object = nextClientIdLock_;
        synchronized (object) {
            ++nextClientId_;
            return nextClientId_;
        }
    }

    public long getConnectionId() {
        return this.connectionId_;
    }

    private void initializeTransient() {
        try {
            String clientLifetime;
            String clientCleanupInterval = SystemProperties.getProperty("com.ibm.as400.access.TunnelProxyServer.clientCleanupInterval");
            if (clientCleanupInterval != null) {
                this.clientCleanupInterval_ = Long.valueOf(clientCleanupInterval) * 1000L;
            }
            if ((clientLifetime = SystemProperties.getProperty("com.ibm.as400.access.TunnelProxyServer.clientLifetime")) != null) {
                this.clientLifetime_ = Long.valueOf(clientLifetime) * 1000L;
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        if (this.clientCleanupInterval_ > 0L) {
            this.maintenance_ = new TunnelProxyServerMaintenance();
            this.maintenance_.start();
            if (!this.maintenance_.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            for (int i = 1; !this.maintenance_.isRunning() && i < 6000; ++i) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.maintenance_.isRunning()) {
                Trace.log(4, "maintenance thread failed to start");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        block18: {
            try {
                PxReqSV request = (PxReqSV)this.factory_.getNextDS(inputStream);
                if (Trace.isTraceProxyOn()) {
                    request.dump(Trace.getPrintWriter());
                }
                long clientId = request.getClientId();
                if (request instanceof PxTunnelConnectReqSV) {
                    Object object = nextConnectionIdLock_;
                    synchronized (object) {
                        this.connectionId_ = ++nextConnectionId_;
                    }
                    PxRepSV reply = request.process();
                    if (reply == null) break block18;
                    if (this.clientCleanupInterval_ > 0L) {
                        useTimes_.put(new Long(reply.getClientId()), new Long(System.currentTimeMillis()));
                    }
                    reply.setCorrelationId(request.getCorrelationId());
                    OutputStream outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        if (Trace.isTraceProxyOn()) {
                            reply.dump(Trace.getPrintWriter());
                        }
                        reply.writeTo(outputStream);
                        outputStream.flush();
                        break block18;
                    }
                }
                PSTunnelConnection connectionObject = (PSTunnelConnection)clientIds_.get(new Long(clientId));
                if (connectionObject == null) {
                    PxExceptionRepSV reply = new PxExceptionRepSV(new ProxyException(2));
                    reply.setCorrelationId(request.getCorrelationId());
                    OutputStream outputStream3 = outputStream;
                    synchronized (outputStream3) {
                        if (Trace.isTraceProxyOn()) {
                            reply.dump(Trace.getPrintWriter());
                        }
                        reply.writeTo(outputStream);
                        outputStream.flush();
                        break block18;
                    }
                }
                connectionObject.runRequest(request, outputStream);
                if (this.clientCleanupInterval_ > 0L) {
                    useTimes_.put(new Long(clientId), new Long(System.currentTimeMillis()));
                }
            }
            catch (IOException e) {
                Trace.log(2, "IOException in PSTunnelConnection::runInputStream", (Throwable)e);
                throw e;
            }
        }
    }

    static {
        nextClientId_ = 1L;
        nextClientIdLock_ = new Object();
    }

    class TunnelProxyServerMaintenance
    extends Thread {
        private boolean run_ = false;

        public TunnelProxyServerMaintenance() {
            this.setDaemon(true);
        }

        public boolean isRunning() {
            return this.run_;
        }

        public synchronized void run() {
            this.run_ = true;
            if (Trace.isTraceOn()) {
                Trace.log(3, "TunnelProxyServer maintenance daemon is started...");
            }
            while (true) {
                try {
                    while (true) {
                        TunnelProxyServerMaintenance.sleep(PSTunnelController.this.clientCleanupInterval_);
                        PSTunnelController.this.cleanupConnections();
                    }
                }
                catch (InterruptedException ie) {
                    Trace.log(2, "TunnelProxyServer maintenance daemon failed.");
                    continue;
                }
                break;
            }
        }
    }
}

