/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.PermissionAccessDLO;
import com.ibm.as400.access.PermissionAccessQSYS;
import com.ibm.as400.access.PermissionAccessRoot;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class Permission
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int TYPE_DLO = 0;
    public static final int TYPE_QSYS = 1;
    public static final int TYPE_ROOT = 2;
    private AS400 as400_;
    private String authorizationList_;
    private String autListBackup_;
    private boolean autListChanged_;
    private String name_;
    private String owner_;
    private boolean ownerChanged_;
    private boolean revokeOldAuthority_;
    private boolean revokeOldGroupAuthority_;
    private boolean followSymbolicLinks_ = true;
    private String path_;
    private String asp_ = null;
    private String primaryGroup_;
    private boolean primaryGroupChanged_;
    private boolean sensitivityChanged_;
    private int sensitivityLevel_;
    private int type_;
    private transient Vector userPermissionsBuffer_;
    private transient Vector userPermissions_;
    private transient Object userPermissionsLock_ = new Object();
    private transient PermissionAccess access_;
    private transient PropertyChangeSupport changes_;

    public Permission(IFSFile file) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(file.getSystem(), file.getPath(), false, true);
    }

    public Permission(IFSFile file, boolean pathMayStartWithIASP) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(file.getSystem(), file.getPath(), pathMayStartWithIASP, true);
    }

    public Permission(IFSFile file, boolean pathMayStartWithIASP, boolean followLinks) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(file.getSystem(), file.getPath(), pathMayStartWithIASP, followLinks);
    }

    public Permission(AS400 as400, String fileName) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(as400, fileName, false, true);
    }

    public Permission(AS400 as400, String fileName, boolean pathMayStartWithIASP) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(as400, fileName, pathMayStartWithIASP, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission(AS400 as400, String fileName, boolean pathMayStartWithIASP, boolean followLinks) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (as400 == null) {
            throw new NullPointerException("system");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        this.as400_ = as400;
        this.path_ = fileName;
        int separator = this.path_.lastIndexOf(47);
        this.name_ = this.path_.substring(separator + 1);
        this.type_ = this.parseType(this.path_, pathMayStartWithIASP);
        if (!followLinks && this.as400_.getVRM() < 328704) {
            if (Trace.traceOn_) {
                Trace.log(4, "followLinks(false): Parameter is ignored because system is not V5R4 or higher.");
            }
        } else {
            this.followSymbolicLinks_ = followLinks;
        }
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.access_.setFollowSymbolicLinks(this.followSymbolicLinks_);
        Vector perms = null;
        try {
            perms = this.access_.getAuthority(this.path_);
            this.changes_ = new PropertyChangeSupport(this);
            Object object = this.userPermissionsLock_;
            synchronized (object) {
                this.owner_ = (String)perms.elementAt(0);
                this.primaryGroup_ = (String)perms.elementAt(1);
                this.authorizationList_ = (String)perms.elementAt(2);
                this.sensitivityLevel_ = (Integer)perms.elementAt(3);
                this.userPermissionsBuffer_ = new Vector();
                this.userPermissions_ = new Vector();
                int count = perms.size();
                for (int i = 4; i < count; ++i) {
                    UserPermission userPermission = (UserPermission)perms.elementAt(i);
                    if (userPermission == null) continue;
                    userPermission.setCommitted(-1);
                    this.userPermissionsBuffer_.addElement(userPermission);
                    this.userPermissions_.addElement(userPermission);
                }
            }
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorizedUser(String userProfileName) {
        if (userProfileName == null) {
            throw new NullPointerException("userProfileName");
        }
        String userName = userProfileName.trim().toUpperCase();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            if (this.getUserIndex(userName, this.userPermissions_) != -1) {
                Trace.log(2, "Permission already exists for user " + userProfileName);
                throw new ExtendedIllegalArgumentException("userProfileName (" + userName + ")", 2);
            }
            int index = this.getUserIndex(userName, this.userPermissionsBuffer_);
            if (index != -1) {
                UserPermission usrAut = (UserPermission)this.userPermissionsBuffer_.elementAt(index);
                usrAut.setCommitted(2);
                this.userPermissions_.addElement(usrAut);
            } else {
                UserPermission userPermission;
                switch (this.type_) {
                    case 0: {
                        userPermission = new DLOPermission(userName);
                        break;
                    }
                    case 1: {
                        userPermission = new QSYSPermission(userName);
                        break;
                    }
                    default: {
                        userPermission = new RootPermission(userName);
                    }
                }
                userPermission.setGroupIndicator(1);
                userPermission.setCommitted(0);
                this.userPermissionsBuffer_.addElement(userPermission);
                this.userPermissions_.addElement(userPermission);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserPermission(UserPermission userPermission) {
        if (userPermission == null) {
            throw new NullPointerException("userPermission");
        }
        switch (this.type_) {
            case 0: {
                if (userPermission instanceof DLOPermission) break;
            }
            case 1: {
                if (userPermission instanceof QSYSPermission) break;
            }
            case 2: {
                if (userPermission instanceof RootPermission) break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("userPermission", 2);
            }
        }
        String user = userPermission.getUserID();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            if (this.getUserIndex(user, this.userPermissions_) != -1) {
                Trace.log(2, "Permission already exists for user " + user);
                throw new ExtendedIllegalArgumentException("userProfileName (" + user + ")", 2);
            }
            int index = this.getUserIndex(user, this.userPermissionsBuffer_);
            if (index != -1) {
                userPermission.setCommitted(2);
                this.userPermissionsBuffer_.setElementAt(userPermission, index);
                this.userPermissions_.addElement(userPermission);
            } else {
                userPermission.setCommitted(0);
                this.userPermissionsBuffer_.addElement(userPermission);
                this.userPermissions_.addElement(userPermission);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException {
        if (this.isCommitted()) {
            return;
        }
        for (int numberOfCommitAttempts = 1; numberOfCommitAttempts <= 2; ++numberOfCommitAttempts) {
            try {
                block20: {
                    try {
                        if (this.autListChanged_) {
                            this.access_.setAuthorizationList(this.path_, this.authorizationList_, this.autListBackup_);
                            this.autListChanged_ = false;
                        }
                        if (this.sensitivityChanged_) {
                            this.access_.setSensitivity(this.path_, this.sensitivityLevel_);
                            this.sensitivityChanged_ = false;
                        }
                        if (this.ownerChanged_) {
                            this.access_.setOwner(this.path_, this.owner_, this.revokeOldAuthority_);
                            this.ownerChanged_ = false;
                        }
                        if (this.primaryGroupChanged_) {
                            this.access_.setPrimaryGroup(this.path_, this.primaryGroup_, this.revokeOldGroupAuthority_);
                            this.primaryGroupChanged_ = false;
                        }
                    }
                    catch (AS400Exception e) {
                        Trace.log(2, e);
                        if (numberOfCommitAttempts != 2) break block20;
                        throw e;
                    }
                }
                Object e = this.userPermissionsLock_;
                synchronized (e) {
                    int count = this.userPermissionsBuffer_.size();
                    block14: for (int i = count - 1; i >= 0; --i) {
                        UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(i);
                        switch (userPermission.getCommitted()) {
                            case 3: {
                                this.access_.setFromAuthorizationList(this.path_, userPermission.isFromAuthorizationList());
                                userPermission.setCommitted(-1);
                                continue block14;
                            }
                            case 0: {
                                this.access_.addUser(this.path_, userPermission);
                                userPermission.setCommitted(-1);
                                continue block14;
                            }
                            case 2: {
                                this.access_.setAuthority(this.path_, userPermission);
                                userPermission.setCommitted(-1);
                                continue block14;
                            }
                            case 1: {
                                this.access_.removeUser(this.path_, userPermission.getUserID());
                                userPermission.setCommitted(-1);
                                this.userPermissionsBuffer_.removeElement(userPermission);
                                continue block14;
                            }
                        }
                    }
                    continue;
                }
            }
            catch (PropertyVetoException e) {
                Trace.log(2, e);
            }
        }
        this.changes_.firePropertyChange("permission", null, this);
    }

    public String getAuthorizationList() {
        return this.authorizationList_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAuthorizedUsers() {
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int count = this.userPermissions_.size();
            Vector<String> names = new Vector<String>();
            for (int i = 0; i < count; ++i) {
                UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(i);
                names.addElement(userPermission.getUserID());
            }
            return names.elements();
        }
    }

    public String getObjectPath() {
        return this.path_;
    }

    public String getName() {
        return this.name_;
    }

    public String getOwner() {
        return this.owner_;
    }

    public String getPrimaryGroup() {
        return this.primaryGroup_;
    }

    public int getSensitivityLevel() {
        return this.sensitivityLevel_;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public int getType() {
        return this.type_;
    }

    private int getUserIndex(String userProfileName, Vector vector) {
        int count = vector.size();
        for (int i = 0; i < count; ++i) {
            UserPermission userPermission = (UserPermission)vector.elementAt(i);
            if (!userPermission.getUserID().equals(userProfileName)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserPermission getUserPermission(String userProfileName) {
        if (userProfileName == null) {
            throw new NullPointerException("userProfileName");
        }
        String userName = userProfileName.toUpperCase();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int index = this.getUserIndex(userName, this.userPermissions_);
            if (index != -1) {
                return (UserPermission)this.userPermissions_.elementAt(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getUserPermissions() {
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            return this.userPermissions_.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommitted() {
        boolean committed = true;
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int count = this.userPermissionsBuffer_.size();
            if (this.sensitivityChanged_) {
                return false;
            }
            if (this.autListChanged_) {
                return false;
            }
            if (this.ownerChanged_) {
                return false;
            }
            if (this.primaryGroupChanged_) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(i);
                if (userPermission.getCommitted() == -1) continue;
                committed = false;
                break;
            }
            return committed;
        }
    }

    public boolean isFollowSymbolicLinks() {
        return this.followSymbolicLinks_;
    }

    private int parseType(String objectName, boolean pathMayStartWithIASP) {
        if (Trace.traceOn_) {
            Trace.log(3, "IASP flag is: " + pathMayStartWithIASP + ", object name: " + objectName);
        }
        if (pathMayStartWithIASP) {
            int locationOfQSYS;
            String name = objectName.toUpperCase();
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            if ((locationOfQSYS = name.indexOf("/QSYS.LIB/")) >= 0) {
                if (locationOfQSYS > 0) {
                    String asp = name.substring(1, locationOfQSYS);
                    if (asp.indexOf(47) < 0) {
                        this.asp_ = objectName.substring(0, locationOfQSYS);
                        return 1;
                    }
                } else {
                    return 1;
                }
            }
            if (name.startsWith("/QDLS/")) {
                return 0;
            }
            return 2;
        }
        String name = objectName.toUpperCase();
        if (name.startsWith("/QSYS.LIB/") || name.equals("/QSYS.LIB")) {
            return 1;
        }
        if (name.startsWith("/QDLS/") || name.equals("/QDLS")) {
            return 0;
        }
        return 2;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        int i;
        s.defaultReadObject();
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.access_.setFollowSymbolicLinks(this.followSymbolicLinks_);
        this.userPermissionsLock_ = new Object();
        this.userPermissionsBuffer_ = new Vector();
        this.userPermissions_ = new Vector();
        int size = (Integer)s.readObject();
        for (i = 0; i < size; ++i) {
            this.userPermissionsBuffer_.addElement(s.readObject());
        }
        size = (Integer)s.readObject();
        for (i = 0; i < size; ++i) {
            this.userPermissions_.addElement(s.readObject());
        }
        this.changes_ = new PropertyChangeSupport(this);
        s.readObject();
    }

    public void removeAuthorizedUser(String userProfileName) {
        if (userProfileName == null) {
            throw new NullPointerException("userProfileName");
        }
        String userName = userProfileName.trim().toUpperCase();
        UserPermission userPermission = this.getUserPermission(userName);
        if (userPermission == null) {
            Trace.log(2, "Permission does not exist for user " + userProfileName);
            throw new ExtendedIllegalArgumentException("userProfileName (" + userName + ")", 2);
        }
        this.removeUserPermission(userPermission);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserPermission(UserPermission permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            if (this.userPermissions_.indexOf(permission) == -1) {
                Trace.log(2, "Permission does not exist for user " + permission.getUserID());
                throw new ExtendedIllegalArgumentException("permission", 2);
            }
            switch (permission.getCommitted()) {
                case 0: {
                    this.userPermissions_.removeElement(permission);
                    this.userPermissionsBuffer_.removeElement(permission);
                    permission.setCommitted(-1);
                    break;
                }
                default: {
                    permission.setCommitted(1);
                    this.userPermissions_.removeElement(permission);
                }
            }
        }
    }

    public synchronized void setAuthorizationList(String autList) {
        if (autList == null) {
            throw new NullPointerException("autList");
        }
        if (autList.trim().equalsIgnoreCase(this.authorizationList_)) {
            return;
        }
        if (!this.autListChanged_) {
            this.autListBackup_ = this.authorizationList_;
        }
        this.authorizationList_ = autList.trim().toUpperCase();
        this.autListChanged_ = true;
    }

    public synchronized void setOwner(String owner, boolean revokeOldAuthority) {
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        this.owner_ = owner;
        this.revokeOldAuthority_ = revokeOldAuthority;
        this.ownerChanged_ = true;
    }

    public void setPrimaryGroup(String primaryGroup, boolean revokeOldAuthority) {
        if (primaryGroup == null) {
            throw new NullPointerException("primaryGroup");
        }
        this.primaryGroup_ = primaryGroup;
        this.revokeOldGroupAuthority_ = revokeOldAuthority;
        this.primaryGroupChanged_ = true;
    }

    public synchronized void setSensitivityLevel(int sensitivityLevel) {
        if (sensitivityLevel < 0 || sensitivityLevel > 4) {
            throw new ExtendedIllegalArgumentException("sensitivityLevel (" + sensitivityLevel + ")", 2);
        }
        this.sensitivityLevel_ = sensitivityLevel;
        this.sensitivityChanged_ = true;
    }

    public synchronized void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.as400_ == null) {
            this.as400_ = system;
        } else {
            if (this.as400_.isConnected()) {
                throw new ExtendedIllegalStateException("system", 5);
            }
            if (this.as400_.equals(system)) {
                return;
            }
        }
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.access_.setFollowSymbolicLinks(this.followSymbolicLinks_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int i;
            s.writeObject(new Integer(this.userPermissionsBuffer_.size()));
            for (i = 0; i < this.userPermissionsBuffer_.size(); ++i) {
                s.writeObject(this.userPermissionsBuffer_.elementAt(i));
            }
            s.writeObject(new Integer(this.userPermissions_.size()));
            for (i = 0; i < this.userPermissions_.size(); ++i) {
                s.writeObject(this.userPermissions_.elementAt(i));
            }
            s.writeObject(null);
        }
    }
}

