/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPoolAuthentication;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.PoolItemProperties;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Locale;

class PoolItem {
    private AS400 AS400object_;
    private PoolItemProperties properties_;
    private Locale locale_ = null;

    PoolItem(String systemName, String userID, AS400ConnectionPoolAuthentication poolAuth, boolean secure, Locale locale, int service, boolean connect, boolean threadUse, SocketProperties socketProperties, int ccsid) throws AS400SecurityException, IOException {
        String password = null;
        if (poolAuth.getAuthenticationScheme() == 2) {
            ProfileTokenCredential profileToken = poolAuth.getProfileToken();
            this.AS400object_ = secure ? new SecureAS400(systemName, profileToken) : new AS400(systemName, profileToken);
        } else {
            password = poolAuth.getPassword();
            this.AS400object_ = secure ? (password == null ? (userID.equals("*CURRENT") ? new SecureAS400(systemName) : new SecureAS400(systemName, userID)) : new SecureAS400(systemName, userID, password)) : (password == null ? (userID.equals("*CURRENT") ? new AS400(systemName) : new AS400(systemName, userID)) : new AS400(systemName, userID, password));
        }
        if (locale != null) {
            this.AS400object_.setLocale(locale);
            this.locale_ = locale;
        } else {
            this.locale_ = null;
        }
        this.properties_ = new PoolItemProperties();
        try {
            if (poolAuth.getAuthenticationScheme() == 0 && password != null) {
                this.AS400object_.setGuiAvailable(false);
            }
            if (!threadUse) {
                this.AS400object_.setThreadUsed(false);
            }
            if (socketProperties != null) {
                this.AS400object_.setSocketProperties(socketProperties);
            }
            if (ccsid != -1) {
                this.AS400object_.setCcsid(ccsid);
            }
            if (connect) {
                this.AS400object_.connectService(service);
            } else {
                this.AS400object_.connectService(7);
                this.AS400object_.disconnectService(7);
            }
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
        }
    }

    AS400 getAS400Object() {
        return this.AS400object_;
    }

    long getInactivityTime() {
        return this.properties_.getInactivityTime();
    }

    long getInUseTime() {
        return this.properties_.getInUseTime();
    }

    long getLifeSpan() {
        return this.properties_.getLifeSpan();
    }

    Locale getLocale() {
        return this.locale_;
    }

    int getUseCount() {
        return this.properties_.getUseCount();
    }

    boolean isFailedPretest() {
        return this.properties_.isFailedPretest();
    }

    boolean isInUse() {
        return this.properties_.isInUse();
    }

    void setFailedPretest() {
        this.properties_.setFailedPretest();
    }

    void setInUse(boolean inUse) {
        this.properties_.setInUse(inUse);
    }
}

