/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

abstract class PrintObjectImplRemote
implements PrintObjectImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    NPCPAttribute attrs;
    private AS400ImplRemote system_;
    private NPCPID cpID_;
    private int objectType_;

    PrintObjectImplRemote() {
    }

    void checkRunTimeState() {
        if (this.getSystem() == null) {
            Trace.log(2, "Parameter 'system' has not been set.");
            throw new ExtendedIllegalStateException("system", 4);
        }
    }

    abstract NPCPAttributeIDList getAttrIDsToRetrieve();

    abstract NPCPAttributeIDList getAttrIDsToRetrieve(int var1);

    public NPCPAttribute getAttrValue() {
        return this.attrs;
    }

    final NPCPID getIDCodePoint() {
        return this.cpID_;
    }

    public Integer getIntegerAttribute(int attributeID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Integer aValue = null;
        if (this.attrs != null) {
            aValue = this.attrs.getIntValue(attributeID);
        }
        if (aValue == null && (aValue = this.getIDCodePoint().getIntValue(attributeID)) == null) {
            NPCPAttributeIDList attrIDsToRetreive = this.getAttrIDsToRetrieve();
            if (attrIDsToRetreive.containsID(attributeID)) {
                this.updateAttrs(attrIDsToRetreive);
                if (this.attrs != null) {
                    aValue = this.attrs.getIntValue(attributeID);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + attributeID + " requested but not valid at this time.");
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attributeID), 2);
            }
        }
        if (aValue == null) {
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPConversation conversation = npSystem.getConversation();
            String curLevel = conversation.getAttribute(141);
            npSystem.returnConversation(conversation);
            throw new RequestNotSupportedException(curLevel, 1);
        }
        return aValue;
    }

    public Integer getSingleIntegerAttribute(int attributeID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Integer aValue = null;
        if (this.attrs != null) {
            aValue = this.attrs.getIntValue(attributeID);
        }
        if (aValue == null && (aValue = this.getIDCodePoint().getIntValue(attributeID)) == null) {
            NPCPAttributeIDList attrIDsToRetreive = this.getAttrIDsToRetrieve(attributeID);
            if (attrIDsToRetreive.containsID(attributeID)) {
                this.updateAttrs(attrIDsToRetreive);
                if (this.attrs != null) {
                    aValue = this.attrs.getIntValue(attributeID);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + attributeID + " requested but not valid at this time.");
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attributeID), 2);
            }
        }
        if (aValue == null) {
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPConversation conversation = npSystem.getConversation();
            String curLevel = conversation.getAttribute(141);
            npSystem.returnConversation(conversation);
            throw new RequestNotSupportedException(curLevel, 1);
        }
        return aValue;
    }

    public Float getSingleFloatAttribute(int attributeID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Float aValue = null;
        if (this.attrs != null) {
            aValue = this.attrs.getFloatValue(attributeID);
        }
        if (aValue == null && (aValue = this.getIDCodePoint().getFloatValue(attributeID)) == null) {
            NPCPAttributeIDList attrIDsToRetreive = this.getAttrIDsToRetrieve(attributeID);
            if (attrIDsToRetreive.containsID(attributeID)) {
                this.updateAttrs(attrIDsToRetreive);
                if (this.attrs != null) {
                    aValue = this.attrs.getFloatValue(attributeID);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + attributeID + " requested but not valid at this time.");
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attributeID), 2);
            }
        }
        if (aValue == null) {
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPConversation conversation = npSystem.getConversation();
            String curLevel = conversation.getAttribute(141);
            npSystem.returnConversation(conversation);
            throw new RequestNotSupportedException(curLevel, 1);
        }
        return aValue;
    }

    public String getSingleStringAttribute(int attributeID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        String str = null;
        if (this.attrs != null) {
            str = this.attrs.getStringValue(attributeID);
        }
        if (str == null && (str = this.getIDCodePoint().getStringValue(attributeID)) == null) {
            NPCPAttributeIDList attrIDsToRetreive = this.getAttrIDsToRetrieve(attributeID);
            if (attrIDsToRetreive.containsID(attributeID)) {
                this.updateAttrs(attrIDsToRetreive);
                if (this.attrs != null) {
                    str = this.attrs.getStringValue(attributeID);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + attributeID + " requested but not valid at this time.");
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attributeID), 2);
            }
        }
        if (str == null) {
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPConversation conversation = npSystem.getConversation();
            String curLevel = conversation.getAttribute(141);
            npSystem.returnConversation(conversation);
            throw new RequestNotSupportedException(curLevel, 1);
        }
        return str;
    }

    public Float getFloatAttribute(int attributeID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Float aValue = null;
        if (this.attrs != null) {
            aValue = this.attrs.getFloatValue(attributeID);
        }
        if (aValue == null && (aValue = this.getIDCodePoint().getFloatValue(attributeID)) == null) {
            NPCPAttributeIDList attrIDsToRetreive = this.getAttrIDsToRetrieve();
            if (attrIDsToRetreive.containsID(attributeID)) {
                this.updateAttrs(attrIDsToRetreive);
                if (this.attrs != null) {
                    aValue = this.attrs.getFloatValue(attributeID);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + attributeID + " requested but not valid at this time.");
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attributeID), 2);
            }
        }
        if (aValue == null) {
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPConversation conversation = npSystem.getConversation();
            String curLevel = conversation.getAttribute(141);
            npSystem.returnConversation(conversation);
            throw new RequestNotSupportedException(curLevel, 1);
        }
        return aValue;
    }

    public String getStringAttribute(int attributeID) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        String str = null;
        if (this.attrs != null) {
            str = this.attrs.getStringValue(attributeID);
        }
        if (str == null && (str = this.getIDCodePoint().getStringValue(attributeID)) == null) {
            NPCPAttributeIDList attrIDsToRetreive = this.getAttrIDsToRetrieve();
            if (attrIDsToRetreive.containsID(attributeID)) {
                this.updateAttrs(attrIDsToRetreive);
                if (this.attrs != null) {
                    str = this.attrs.getStringValue(attributeID);
                }
            } else {
                Trace.log(2, "PrintObjectImplRemote.java - Attribute " + attributeID + " requested but not valid at this time.");
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(attributeID), 2);
            }
        }
        if (str == null) {
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPConversation conversation = npSystem.getConversation();
            String curLevel = conversation.getAttribute(141);
            npSystem.returnConversation(conversation);
            throw new RequestNotSupportedException(curLevel, 1);
        }
        return str;
    }

    public final AS400ImplRemote getSystem() {
        return this.system_;
    }

    final void setIDCodePoint(NPCPID cpID) {
        this.cpID_ = cpID;
    }

    public void setPrintObjectAttrs(NPCPID idCodePoint, NPCPAttribute cpAttrs, int type) {
        block3: {
            this.cpID_ = idCodePoint;
            this.attrs = cpAttrs;
            this.objectType_ = type;
            try {
                this.cpID_.setConverter(ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_));
                if (this.attrs != null) {
                    this.attrs.setConverter(ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_));
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTraceErrorOn()) break block3;
                Trace.log(2, "Error initializing converter for print object", (Throwable)e);
            }
        }
    }

    public final void setSystem(AS400Impl system) {
        this.system_ = (AS400ImplRemote)system;
        this.attrs = null;
    }

    public void update() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    void updateAttrs(NPCPAttributeIDList attrIDs) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        NPDataStream req = new NPDataStream(this.objectType_);
        NPDataStream reply = new NPDataStream(this.objectType_);
        NPCPAttribute cpAttrs = new NPCPAttribute();
        req.setAction(15);
        req.addCodePoint(this.getIDCodePoint());
        req.addCodePoint(attrIDs);
        reply.addCodePoint(cpAttrs);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        if (npSystem != null) {
            int rc = npSystem.makeRequest(req, reply);
            if (rc == 0) {
                if (this.attrs != null) {
                    this.attrs.addUpdateAttributes(cpAttrs);
                } else {
                    this.attrs = cpAttrs;
                }
            } else {
                NPConversation conversation = npSystem.getConversation();
                String curLevel = conversation.getAttribute(141);
                npSystem.returnConversation(conversation);
                switch (rc) {
                    case 4: {
                        throw new RequestNotSupportedException(curLevel, 1);
                    }
                }
            }
        }
    }
}

