/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectListEvent;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.PrintObjectListListener;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class PrintObjectList
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final String SYSTEM = "system";
    private NPCPAttributeIDList attrsToRetrieve_ = null;
    private NPCPID idFilter_ = null;
    private NPCPSelection selection_ = null;
    AS400 system_ = null;
    private int typeOfObject_ = 0;
    private boolean listOutOfSync_ = false;
    private boolean objectAddedEvent_ = false;
    private transient boolean open_;
    private transient Vector printObjectListListeners_;
    private transient Vector theList_;
    transient PrintObjectListImpl impl_;
    transient PropertyChangeSupport changes;
    transient VetoableChangeSupport vetos;
    transient PrintObjectListListener dispatcher_;
    boolean useCache_ = true;

    public void setCache(boolean f) {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.useCache_ = f;
        this.impl_.setCache(f);
    }

    PrintObjectList(int objectType, NPCPSelection selectionCP) {
        this.typeOfObject_ = objectType;
        this.selection_ = selectionCP;
        this.initializeTransient();
    }

    PrintObjectList(int objectType, NPCPSelection selectionCP, AS400 system) {
        this(objectType, selectionCP);
        if (system == null) {
            Trace.log(2, "printObjectList: Parameter 'system' is null.");
            throw new NullPointerException(SYSTEM);
        }
        this.system_ = system;
    }

    public void addPrintObjectListListener(PrintObjectListListener listener) {
        this.printObjectListListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    abstract void chooseImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (!this.open_) {
                this.theList_.removeAllElements();
                return;
            }
            this.impl_.close();
            this.open_ = false;
        }
    }

    private PrintObjectListEvent createPrintObjectListEvent(int id, PrintObject printObject, Exception exception) {
        PrintObjectListEvent event = exception != null ? new PrintObjectListEvent((Object)this, exception) : (printObject != null ? new PrintObjectListEvent((Object)this, printObject) : new PrintObjectListEvent((Object)this, id));
        return event;
    }

    private void firePrintObjectList(PrintObjectListEvent event) {
        event.setSource(this);
        if (this.printObjectListListeners_.isEmpty()) {
            return;
        }
        Vector l = (Vector)this.printObjectListListeners_.clone();
        block7: for (int i = 0; i < l.size(); ++i) {
            switch (event.getID()) {
                case 5: {
                    PrintObject printObject = event.getObject();
                    if (this.useCache_) {
                        this.theList_.addElement(printObject);
                    }
                    this.objectAddedEvent_ = true;
                    ((PrintObjectListListener)l.elementAt(i)).listObjectAdded(event);
                    continue block7;
                }
                case 1: {
                    ((PrintObjectListListener)l.elementAt(i)).listClosed(event);
                    continue block7;
                }
                case 2: {
                    ((PrintObjectListListener)l.elementAt(i)).listCompleted(event);
                    continue block7;
                }
                case 3: {
                    ((PrintObjectListListener)l.elementAt(i)).listErrorOccurred(event);
                    continue block7;
                }
                case 4: {
                    ((PrintObjectListListener)l.elementAt(i)).listOpened(event);
                }
            }
        }
    }

    private void firePrintObjectList(int id, PrintObject printObject, Exception exception) {
        this.firePrintObjectList(this.createPrintObjectListEvent(id, printObject, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintObject getObject(int index) {
        if (!this.open_) {
            Trace.log(2, "getObject: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        Vector vector = this.theList_;
        synchronized (vector) {
            if (this.theList_.size() > index && (!this.listOutOfSync_ || this.listOutOfSync_ && this.objectAddedEvent_ && this.theList_.size() == this.impl_.size())) {
                this.objectAddedEvent_ = false;
                return (PrintObject)this.theList_.elementAt(index);
            }
            PrintObject npobject = null;
            if (this.listOutOfSync_) {
                this.theList_.removeAllElements();
                this.listOutOfSync_ = false;
            }
            if (this.useCache_) {
                for (int i = this.theList_.size(); i <= index; ++i) {
                    NPCPAttribute cpattr;
                    NPCPID cpid;
                    block10: {
                        cpid = this.impl_.getNPCPID(i);
                        cpattr = this.impl_.getNPCPAttribute(i);
                        try {
                            cpid.setConverter(new Converter((int)this.system_.getCcsid(), (AS400)this.system_).impl);
                            cpattr.setConverter(new Converter((int)this.system_.getCcsid(), (AS400)this.system_).impl);
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!Trace.isTraceErrorOn()) break block10;
                            Trace.log(2, "Error initializing converter for print object", (Throwable)e);
                        }
                    }
                    npobject = this.newNPObject(cpid, cpattr);
                    this.theList_.addElement(npobject);
                }
                return npobject;
            }
            return null;
        }
    }

    public Enumeration getObjects() {
        if (!this.open_) {
            Trace.log(2, "getObjects: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        this.getObject(this.impl_.size() - 1);
        return this.theList_.elements();
    }

    NPCPSelection getSelectionCP() {
        return this.selection_;
    }

    public final AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.impl_ = null;
        this.printObjectListListeners_ = new Vector();
        this.changes = new PropertyChangeSupport(this);
        this.vetos = new VetoableChangeSupport(this);
        this.theList_ = new Vector();
        this.open_ = false;
        this.dispatcher_ = new PrintObjectListListener(){

            public void listClosed(PrintObjectListEvent event) {
                PrintObjectList.this.firePrintObjectList(event);
            }

            public void listCompleted(PrintObjectListEvent event) {
                PrintObjectList.this.firePrintObjectList(event);
            }

            public void listErrorOccurred(PrintObjectListEvent event) {
                PrintObjectList.this.firePrintObjectList(event);
            }

            public void listOpened(PrintObjectListEvent event) {
                PrintObjectList.this.firePrintObjectList(event);
            }

            public void listObjectAdded(PrintObjectListEvent event) {
                PrintObjectList.this.firePrintObjectList(event);
            }
        };
    }

    public boolean isCompleted() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (!this.open_) {
            Trace.log(2, "isCompleted: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        return this.impl_.isCompleted();
    }

    abstract PrintObject newNPObject(NPCPID var1, NPCPAttribute var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAsynchronously() {
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (this.open_) {
                Trace.log(2, "open: List is already opened.");
                throw new ExtendedIllegalStateException(2);
            }
            if (this.impl_ == null) {
                if (this.system_ == null) {
                    ExtendedIllegalStateException e = new ExtendedIllegalStateException(SYSTEM, 4);
                    this.firePrintObjectList(3, null, e);
                }
                this.chooseImpl();
            }
            if (!this.getSystem().isThreadUsed()) {
                Trace.log(2, "open: Threads can not be started.");
                throw new ExtendedIllegalStateException(9);
            }
            this.open_ = true;
            this.listOutOfSync_ = true;
            this.impl_.openAsynchronously();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSynchronously() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (this.open_) {
                Trace.log(2, "open: List is already opened.");
                throw new ExtendedIllegalStateException(2);
            }
            if (this.impl_ == null) {
                if (this.system_ == null) {
                    ExtendedIllegalStateException e = new ExtendedIllegalStateException(SYSTEM, 4);
                    this.firePrintObjectList(3, null, e);
                }
                this.chooseImpl();
            }
            this.open_ = true;
            this.listOutOfSync_ = true;
            this.impl_.openSynchronously();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePrintObjectListListener(PrintObjectListListener listener) {
        this.printObjectListListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void resetAttributesToRetrieve() {
        if (this.open_) {
            Trace.log(2, "resetAttributesToRetrieve: List is already opened.");
            throw new ExtendedIllegalStateException(2);
        }
        this.attrsToRetrieve_ = null;
        if (this.impl_ != null) {
            this.impl_.resetAttributesToRetrieve();
        }
    }

    public void resetFilter() {
        if (this.open_) {
            Trace.log(2, "resetFilter: List is already opened.");
            throw new ExtendedIllegalStateException(2);
        }
        this.selection_.reset();
        this.idFilter_ = null;
        if (this.impl_ != null) {
            this.impl_.resetFilter();
        }
    }

    public synchronized void setAttributesToRetrieve(int[] attributes) {
        if (attributes == null) {
            Trace.log(2, "setAttributesToRetrieve: Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        if (this.open_) {
            Trace.log(2, "setAttributesToRetrieve: List is already opened.");
            throw new ExtendedIllegalStateException(2);
        }
        if (this.attrsToRetrieve_ != null) {
            this.attrsToRetrieve_.reset();
        } else {
            this.attrsToRetrieve_ = new NPCPAttributeIDList();
        }
        for (int i = 0; i < attributes.length; ++i) {
            this.attrsToRetrieve_.addAttrID(attributes[i]);
        }
        if (this.impl_ != null) {
            this.impl_.setAttributesToRetrieve(attributes);
        }
    }

    void setIDCodePointFilter(NPCPID cpID) {
        this.idFilter_ = cpID;
        if (this.impl_ != null) {
            this.impl_.setIDCodePointFilter(cpID);
        }
    }

    void setImpl() {
        try {
            this.system_.connectService(1);
        }
        catch (Exception e) {
            Trace.log(2, "Error occurred connecting to Print service.", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.impl_.setSystem(this.system_.getImpl());
        this.impl_.addPrintObjectListListener(this.dispatcher_);
        this.impl_.setPrintObjectListAttrs(this.attrsToRetrieve_, this.idFilter_, this.selection_, this.typeOfObject_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            Trace.log(2, "setSystem: Parameter 'system' is null.");
            throw new NullPointerException(SYSTEM);
        }
        AS400 oldSystem = this.getSystem();
        this.vetos.fireVetoableChange(SYSTEM, oldSystem, system);
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (this.open_) {
                Trace.log(2, "setSystem: List is already opened.");
                throw new ExtendedIllegalStateException(2);
            }
            this.system_ = system;
            if (this.impl_ != null) {
                this.impl_.setSystem(system.getImpl());
            }
        }
        this.changes.firePropertyChange(SYSTEM, oldSystem, system);
    }

    public synchronized int size() {
        if (!this.open_) {
            Trace.log(2, "size: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        return this.impl_.size();
    }

    public void waitForItem(int itemNumber) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (!this.open_) {
            Trace.log(2, "waitForItem: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        if (itemNumber < 1) {
            Trace.log(2, "waitForItem: Parameter 'itemNumber' is less than 1.");
            throw new ExtendedIllegalArgumentException("itemNumber(" + itemNumber + ")", 4);
        }
        this.impl_.waitForItem(itemNumber);
    }

    public void waitForListToComplete() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (!this.open_) {
            Trace.log(2, "waitForListToComplete: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        this.impl_.waitForListToComplete();
    }
}

