/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelOutQ;
import com.ibm.as400.access.NPCPSelPrtD;
import com.ibm.as400.access.NPCPSelPrtF;
import com.ibm.as400.access.NPCPSelRes;
import com.ibm.as400.access.NPCPSelSplF;
import com.ibm.as400.access.NPCPSelWrtJ;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectListEvent;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.PrintObjectListListener;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Vector;

abstract class PrintObjectListImplRemote
implements PrintObjectListImpl,
Runnable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    private NPCPAttributeIDList attrsToRetrieve_;
    private NPCPID idFilter_;
    private NPCPSelection selection_;
    private AS400ImplRemote system_;
    private int typeOfObject_ = 0;
    private transient boolean completed_ = false;
    private transient boolean closed_ = false;
    private final Object closeLock_ = new Object();
    private transient boolean waiting_ = false;
    private final Object waitLock_ = new Object();
    private transient int waitingForItem_ = -1;
    private transient Vector cpidList_ = null;
    private transient Vector cpattrList_ = null;
    private transient int numItems_ = 0;
    private transient Exception anyException_ = null;
    private transient Vector printObjectListListeners_ = null;
    private boolean useCache_ = true;

    PrintObjectListImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintObjectListListener(PrintObjectListListener listener) {
        if (this.printObjectListListeners_ == null) {
            this.printObjectListListeners_ = new Vector();
        }
        Vector vector = this.printObjectListListeners_;
        synchronized (vector) {
            this.printObjectListListeners_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        if (npSystem != null) {
            NPConversation conversation = npSystem.getConversation();
            try {
                if (conversation != null) {
                    boolean fTossData = false;
                    boolean fMoreData = true;
                    int count = 0;
                    ConverterImpl converter = conversation.getConverter();
                    AS400Server server = conversation.getServer();
                    int correlation = server.newCorrelationId();
                    NPDataStream request = new NPDataStream(this.typeOfObject_);
                    request.setCorrelation(correlation);
                    request.setAction(22);
                    request.setConverter(converter);
                    if (this.selection_ != null) {
                        request.addCodePoint(this.selection_);
                    }
                    if (this.idFilter_ != null) {
                        request.addCodePoint(this.idFilter_);
                    }
                    if (this.attrsToRetrieve_ != null) {
                        request.addCodePoint(this.attrsToRetrieve_);
                    } else {
                        request.addCodePoint(this.getDefaultAttrsToList());
                    }
                    server.send(request, correlation);
                    do {
                        NPDataStream reply;
                        if ((reply = (NPDataStream)server.receive(correlation)) == null) {
                            fMoreData = false;
                            Trace.log(2, "buildList: Null reply from AS400Server.receive()!");
                            throw new InternalErrorException(4);
                        }
                        ++count;
                        boolean bl = fMoreData = !reply.isLastReply();
                        if (fTossData) continue;
                        reply.setConverter(converter);
                        int rc = reply.getReturnCode();
                        if (rc == 0) {
                            NPCPID cpid = this.newNPCPID(reply);
                            NPCPAttribute cpattr = this.newNPCPAttribute(reply);
                            if (cpid == null) continue;
                            Object object = this.closeLock_;
                            synchronized (object) {
                                if (this.closed_ || this.completed_) {
                                    fTossData = true;
                                } else {
                                    if (this.useCache_) {
                                        this.cpidList_.addElement(cpid);
                                    }
                                    if (this.useCache_) {
                                        this.cpattrList_.addElement(cpattr);
                                    }
                                    ++this.numItems_;
                                    this.firePrintObjectList(5, cpid, cpattr, null);
                                    if (this.waiting_ && this.waitingForItem_ <= this.numItems_ && this.waitingForItem_ > -1) {
                                        Object object2 = this.waitLock_;
                                        synchronized (object2) {
                                            this.waitLock_.notifyAll();
                                        }
                                    }
                                }
                            }
                        }
                        if (rc == 9) {
                            NPCPAttribute cpCPFMessage = (NPCPAttribute)reply.getCodePoint(8);
                            if (cpCPFMessage == null) continue;
                            String strCPFMessageID = cpCPFMessage.getStringValue(147);
                            String strCPFMessageText = cpCPFMessage.getStringValue(128);
                            String strCPFMessageHelp = cpCPFMessage.getStringValue(129);
                            if (Trace.traceOn_) {
                                Trace.log(2, "buildList: CPF Message(" + strCPFMessageID + ") = " + strCPFMessageText + ", HelpText= " + strCPFMessageHelp);
                            }
                            AS400Message msg = new AS400Message(strCPFMessageID, strCPFMessageText);
                            msg.setHelp(strCPFMessageHelp);
                            AS400Exception e = new AS400Exception(msg);
                            throw e;
                        }
                        if (rc == 20) continue;
                        Trace.log(2, "buildList: Host Return Code" + rc);
                        if (rc == 4) {
                            throw new RequestNotSupportedException(conversation.getAttribute(141), 1);
                        }
                        throw new ErrorCompletingRequestException(1, "QNPSERVS RC = " + rc);
                    } while (fMoreData);
                }
                Object var19_20 = null;
                npSystem.returnConversation(conversation);
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                npSystem.returnConversation(conversation);
                throw throwable;
            }
        }
    }

    void checkRunTimeState() {
        if (this.getSystem() == null) {
            Trace.log(2, "checkRunTimeState: Parameter 'system' has not been set.");
            throw new ExtendedIllegalStateException("system", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock_;
        synchronized (object) {
            this.closed_ = true;
            this.cpidList_ = null;
            this.cpattrList_ = null;
            this.numItems_ = 0;
            this.anyException_ = null;
        }
        this.firePrintObjectList(1, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePrintObjectList(int id, NPCPID cpid, NPCPAttribute cpattr, Exception exception) {
        if (this.printObjectListListeners_ == null) {
            return;
        }
        PrintObjectListEvent event = exception != null ? new PrintObjectListEvent((Object)this, exception) : (cpid != null ? new PrintObjectListEvent(this, cpid, cpattr) : new PrintObjectListEvent((Object)this, id));
        Vector vector = this.printObjectListListeners_;
        synchronized (vector) {
            int size = this.printObjectListListeners_.size();
            block10: for (int i = 0; i < size; ++i) {
                switch (id) {
                    case 5: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listObjectAdded(event);
                        continue block10;
                    }
                    case 1: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listClosed(event);
                        continue block10;
                    }
                    case 2: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listCompleted(event);
                        continue block10;
                    }
                    case 3: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listErrorOccurred(event);
                        continue block10;
                    }
                    case 4: {
                        ((PrintObjectListListener)this.printObjectListListeners_.elementAt(i)).listOpened(event);
                    }
                }
            }
        }
    }

    abstract NPCPAttributeIDList getDefaultAttrsToList();

    public synchronized NPCPID getNPCPID(int index) {
        return (NPCPID)this.cpidList_.elementAt(index);
    }

    public synchronized NPCPAttribute getNPCPAttribute(int index) {
        return (NPCPAttribute)this.cpattrList_.elementAt(index);
    }

    NPCPSelection getSelectionCP() {
        return this.selection_;
    }

    public final AS400ImplRemote getSystem() {
        return this.system_;
    }

    public boolean isCompleted() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (this.anyException_ != null) {
            this.rethrowException();
        }
        return this.completed_;
    }

    abstract NPCPID newNPCPID(NPDataStream var1);

    NPCPAttribute newNPCPAttribute(NPDataStream reply) {
        return (NPCPAttribute)reply.getCodePoint(8);
    }

    public void openAsynchronously() {
        this.checkRunTimeState();
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openSynchronously() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        block10: {
            Object object;
            NPSystem npSystem;
            this.checkRunTimeState();
            AS400ImplRemote theSystem = this.getSystem();
            if (theSystem != null && (npSystem = NPSystem.getSystem(theSystem)) != null) {
                NPConversation conversation = npSystem.getConversation();
                npSystem.returnConversation(conversation);
            }
            this.cpidList_ = new Vector();
            this.cpattrList_ = new Vector();
            this.numItems_ = 0;
            this.completed_ = false;
            this.closed_ = false;
            this.anyException_ = null;
            this.firePrintObjectList(4, null, null, null);
            try {
                try {
                    this.buildList();
                }
                catch (Exception e) {
                    this.anyException_ = e;
                    this.firePrintObjectList(3, null, null, e);
                    Object var5_6 = null;
                    this.firePrintObjectList(2, null, null, null);
                    Object object3 = this.waitLock_;
                    synchronized (object3) {
                        this.completed_ = true;
                        this.waitLock_.notifyAll();
                        break block10;
                    }
                }
                Object var5_5 = null;
                this.firePrintObjectList(2, null, null, null);
                object = this.waitLock_;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.firePrintObjectList(2, null, null, null);
                Object object2 = this.waitLock_;
                synchronized (object2) {
                    this.completed_ = true;
                    this.waitLock_.notifyAll();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.completed_ = true;
                this.waitLock_.notifyAll();
            }
        }
        if (this.anyException_ != null) {
            this.rethrowException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintObjectListListener(PrintObjectListListener listener) {
        if (this.printObjectListListeners_ != null) {
            Vector vector = this.printObjectListListeners_;
            synchronized (vector) {
                this.printObjectListListeners_.removeElement(listener);
            }
        }
    }

    public void resetAttributesToRetrieve() {
        this.attrsToRetrieve_ = null;
    }

    public void resetFilter() {
        this.selection_.reset();
        this.idFilter_ = null;
    }

    private void rethrowException() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (this.anyException_ instanceof AS400Exception) {
            throw (AS400Exception)this.anyException_;
        }
        if (this.anyException_ instanceof AS400SecurityException) {
            throw (AS400SecurityException)this.anyException_;
        }
        if (this.anyException_ instanceof ConnectionDroppedException) {
            throw (ConnectionDroppedException)this.anyException_;
        }
        if (this.anyException_ instanceof ErrorCompletingRequestException) {
            throw (ErrorCompletingRequestException)this.anyException_;
        }
        if (this.anyException_ instanceof InterruptedException) {
            throw (InterruptedException)this.anyException_;
        }
        if (this.anyException_ instanceof IOException) {
            throw (IOException)this.anyException_;
        }
        if (this.anyException_ instanceof RequestNotSupportedException) {
            throw (RequestNotSupportedException)this.anyException_;
        }
        if (this.anyException_ instanceof ExtendedIllegalStateException) {
            throw (ExtendedIllegalStateException)this.anyException_;
        }
        if (this.anyException_ instanceof NullPointerException) {
            throw (NullPointerException)this.anyException_;
        }
        Trace.log(2, "rethrowException: Exception was not rethrown.");
    }

    public void run() {
        try {
            this.openSynchronously();
        }
        catch (Exception e) {
            this.anyException_ = e;
        }
    }

    public void setAttributesToRetrieve(int[] attributes) {
        if (attributes == null) {
            Trace.log(2, "setAttributesToRetrieve: Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        if (this.attrsToRetrieve_ != null) {
            this.attrsToRetrieve_.reset();
        } else {
            this.attrsToRetrieve_ = new NPCPAttributeIDList();
        }
        for (int i = 0; i < attributes.length; ++i) {
            this.attrsToRetrieve_.addAttrID(attributes[i]);
        }
    }

    public void setCache(boolean f) {
        this.useCache_ = f;
    }

    public void setIDCodePointFilter(NPCPID cpID) {
        this.idFilter_ = cpID;
    }

    public void setFilter(String filterType, String filter) {
        NPCPSelection selectionCP;
        if (filterType.equals("resource")) {
            selectionCP = (NPCPSelRes)this.getSelectionCP();
            ((NPCPSelRes)selectionCP).setResource(filter);
        }
        if (filterType.equals("queue")) {
            selectionCP = (NPCPSelOutQ)this.getSelectionCP();
            ((NPCPSelOutQ)selectionCP).setQueue(filter);
        } else if (filterType.equals("printer")) {
            selectionCP = (NPCPSelPrtD)this.getSelectionCP();
            ((NPCPSelPrtD)selectionCP).setPrinter(filter);
        } else if (filterType.equals("printerFile")) {
            selectionCP = (NPCPSelPrtF)this.getSelectionCP();
            ((NPCPSelPrtF)selectionCP).setPrinterFile(filter);
        } else if (filterType.equals("formType")) {
            selectionCP = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)selectionCP).setFormType(filter);
        } else if (filterType.equals("spooledFileQueue")) {
            selectionCP = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)selectionCP).setQueue(filter);
        } else if (filterType.equals("user")) {
            selectionCP = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)selectionCP).setUser(filter);
        } else if (filterType.equals("userData")) {
            selectionCP = (NPCPSelSplF)this.getSelectionCP();
            ((NPCPSelSplF)selectionCP).setUserData(filter);
        } else if (filterType.equals("writerJobQueue")) {
            selectionCP = (NPCPSelWrtJ)this.getSelectionCP();
            ((NPCPSelWrtJ)selectionCP).setQueue(filter);
        } else if (filterType.equals("writer")) {
            selectionCP = (NPCPSelWrtJ)this.getSelectionCP();
            ((NPCPSelWrtJ)selectionCP).setWriter(filter);
        }
    }

    public void setPrintObjectListAttrs(NPCPAttributeIDList attrsToRetrieve, NPCPID idFilter, NPCPSelection selection, int typeOfObject) {
        this.attrsToRetrieve_ = attrsToRetrieve;
        this.idFilter_ = idFilter;
        this.selection_ = selection;
        this.typeOfObject_ = typeOfObject;
    }

    public void setSystem(AS400Impl system) {
        this.system_ = (AS400ImplRemote)system;
    }

    public int size() {
        return this.numItems_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForItem(int itemNumber) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        while (this.numItems_ < itemNumber && !this.completed_ && !this.closed_) {
            this.waitingForItem_ = itemNumber;
            this.waiting_ = true;
            try {
                Object object = this.waitLock_;
                synchronized (object) {
                    if (!this.closed_ && !this.completed_) {
                        this.waitLock_.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.anyException_ = e;
            }
            if (this.anyException_ == null) continue;
            this.rethrowException();
        }
        this.waiting_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForListToComplete() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        while (!this.completed_ && !this.closed_) {
            this.waitingForItem_ = -1;
            this.waiting_ = true;
            try {
                Object object = this.waitLock_;
                synchronized (object) {
                    if (!this.completed_ && !this.closed_) {
                        this.waitLock_.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.anyException_ = e;
            }
            if (this.anyException_ == null) continue;
            this.rethrowException();
        }
        this.waiting_ = false;
    }
}

