/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.PrintObjectImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterImpl;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrinterImplRemote
extends PrintObjectImplRemote
implements PrinterImpl {
    private static final NPCPAttributeIDList attrsToRetrieve_ = new NPCPAttributeIDList();
    private static boolean fAttrIDsToRtvBuilt_ = false;
    private static final String NAME = "name";
    private RemoteCommandImpl remoteCommand_;

    PrinterImplRemote() {
    }

    private synchronized void buildAttrIDsToRtv() {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(10);
            attrsToRetrieve_.addAttrID(190);
            attrsToRetrieve_.addAttrID(12);
            attrsToRetrieve_.addAttrID(16);
            attrsToRetrieve_.addAttrID(206);
            attrsToRetrieve_.addAttrID(207);
            attrsToRetrieve_.addAttrID(55);
            attrsToRetrieve_.addAttrID(191);
            attrsToRetrieve_.addAttrID(25);
            attrsToRetrieve_.addAttrID(109);
            attrsToRetrieve_.addAttrID(38);
            attrsToRetrieve_.addAttrID(39);
            attrsToRetrieve_.addAttrID(199);
            attrsToRetrieve_.addAttrID(40);
            attrsToRetrieve_.addAttrID(42);
            attrsToRetrieve_.addAttrID(204);
            attrsToRetrieve_.addAttrID(44);
            attrsToRetrieve_.addAttrID(46);
            attrsToRetrieve_.addAttrID(183);
            attrsToRetrieve_.addAttrID(182);
            attrsToRetrieve_.addAttrID(47);
            attrsToRetrieve_.addAttrID(48);
            attrsToRetrieve_.addAttrID(67);
            attrsToRetrieve_.addAttrID(208);
            attrsToRetrieve_.addAttrID(209);
            attrsToRetrieve_.addAttrID(256);
            attrsToRetrieve_.addAttrID(62);
            attrsToRetrieve_.addAttrID(65);
            attrsToRetrieve_.addAttrID(68);
            attrsToRetrieve_.addAttrID(94);
            attrsToRetrieve_.addAttrID(205);
            attrsToRetrieve_.addAttrID(73);
            attrsToRetrieve_.addAttrID(74);
            attrsToRetrieve_.addAttrID(75);
            attrsToRetrieve_.addAttrID(200);
            attrsToRetrieve_.addAttrID(83);
            attrsToRetrieve_.addAttrID(89);
            attrsToRetrieve_.addAttrID(90);
            attrsToRetrieve_.addAttrID(335);
            attrsToRetrieve_.addAttrID(257);
            attrsToRetrieve_.addAttrID(262);
            attrsToRetrieve_.addAttrID(258);
            attrsToRetrieve_.addAttrID(259);
            attrsToRetrieve_.addAttrID(260);
            attrsToRetrieve_.addAttrID(261);
            attrsToRetrieve_.addAttrID(255);
            attrsToRetrieve_.addAttrID(104);
            attrsToRetrieve_.addAttrID(105);
            attrsToRetrieve_.addAttrID(197);
            attrsToRetrieve_.addAttrID(305);
            attrsToRetrieve_.addAttrID(116);
            attrsToRetrieve_.addAttrID(-11);
            attrsToRetrieve_.addAttrID(165);
            attrsToRetrieve_.addAttrID(164);
            attrsToRetrieve_.addAttrID(166);
            attrsToRetrieve_.addAttrID(163);
            attrsToRetrieve_.addAttrID(170);
            attrsToRetrieve_.addAttrID(168);
            attrsToRetrieve_.addAttrID(167);
            attrsToRetrieve_.addAttrID(113);
            attrsToRetrieve_.addAttrID(187);
            attrsToRetrieve_.addAttrID(203);
            attrsToRetrieve_.addAttrID(201);
            attrsToRetrieve_.addAttrID(202);
            attrsToRetrieve_.addAttrID(121);
            attrsToRetrieve_.addAttrID(122);
            attrsToRetrieve_.addAttrID(123);
            attrsToRetrieve_.addAttrID(124);
            attrsToRetrieve_.addAttrID(120);
            attrsToRetrieve_.addAttrID(193);
            fAttrIDsToRtvBuilt_ = true;
        }
    }

    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Parameter 'name' has not been set.");
            throw new ExtendedIllegalStateException(NAME, 4);
        }
    }

    NPCPAttributeIDList getAttrIDsToRetrieve() {
        if (!fAttrIDsToRtvBuilt_) {
            this.buildAttrIDsToRtv();
        }
        return attrsToRetrieve_;
    }

    NPCPAttributeIDList getAttrIDsToRetrieve(int attrToRtv) {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(attrToRtv);
        }
        return attrsToRetrieve_;
    }

    public void setAttributes(PrintParameterList attributes) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        this.checkRunTimeState();
        String changes = attributes.getStringParameter(191);
        String formType = attributes.getStringParameter(48);
        Integer fileSep = attributes.getIntegerParameter(44);
        String outQ = attributes.getStringParameter(-6);
        Integer drawerSep = attributes.getIntegerParameter(42);
        String desc = attributes.getStringParameter(109);
        String printerName = this.getIDCodePoint().getStringValue(89);
        if (desc != null) {
            boolean result;
            desc = PrinterImplRemote.prepareForSingleQuotes(desc);
            String cmdText = "CHGDEVPRT DEVD(" + printerName + ") TEXT('" + desc + "')";
            if (this.remoteCommand_ == null) {
                this.setupRemoteCommand();
            }
            if (!(result = this.remoteCommand_.runCommand(cmdText))) {
                Trace.log(2, "Error when changing printer attributes.");
                throw new AS400Exception(this.remoteCommand_.getMessageList());
            }
        }
        if (changes != null || formType != null || fileSep != null || outQ != null || drawerSep != null) {
            boolean result;
            String stringVal;
            StringBuffer cmdBuf = new StringBuffer("CHGWTR WTR(" + printerName + ")");
            if (changes != null) {
                cmdBuf.append(" OPTION(" + changes + ")");
            }
            if (formType != null) {
                cmdBuf.append(" FORMTYPE(" + formType + ")");
            }
            if (fileSep != null) {
                int intVal = fileSep;
                stringVal = null;
                switch (intVal) {
                    case -1: {
                        stringVal = "*FILE";
                        break;
                    }
                    default: {
                        stringVal = fileSep.toString();
                    }
                }
                cmdBuf.append(" FILESEP(" + stringVal + ")");
            }
            if (outQ != null) {
                QSYSObjectPathName path = new QSYSObjectPathName(outQ);
                cmdBuf.append(" OUTQ(" + path.getLibraryName() + "/" + path.getObjectName() + ")");
            }
            if (drawerSep != null) {
                int intVal = drawerSep;
                stringVal = null;
                switch (intVal) {
                    case -1: {
                        stringVal = "*FILE";
                        break;
                    }
                    case -2: {
                        stringVal = "*DEVD";
                        break;
                    }
                    default: {
                        stringVal = drawerSep.toString();
                    }
                }
                cmdBuf.append(" SEPDRAWER(" + stringVal + ")");
            }
            if (this.remoteCommand_ == null) {
                this.setupRemoteCommand();
            }
            if (!(result = this.remoteCommand_.runCommand(cmdBuf.toString()))) {
                Trace.log(2, "Error when changing printer attributes.");
                throw new AS400Exception(this.remoteCommand_.getMessageList());
            }
        }
        NPCPAttribute cpNewAttrs = attributes.getAttrCodePoint();
        if (this.attrs == null) {
            this.attrs = new NPCPAttribute();
        }
        this.attrs.addUpdateAttributes(cpNewAttrs);
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.remoteCommand_ == null) {
            AS400ImplRemote system = this.getSystem();
            if (system.canUseNativeOptimizations()) {
                try {
                    this.remoteCommand_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                }
                catch (Throwable e) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", e);
                }
            }
            if (this.remoteCommand_ == null) {
                this.remoteCommand_ = new RemoteCommandImplRemote();
            }
            this.remoteCommand_.setSystem(system);
        }
    }

    private static final String prepareForSingleQuotes(String text) {
        if (text.indexOf(39) == -1) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.trim());
        if (buf.indexOf("''") != -1) {
            boolean followedByQuote = false;
            for (int i = buf.length() - 1; i >= 0; --i) {
                char thisChar = buf.charAt(i);
                if (thisChar == '\'') {
                    if (followedByQuote) {
                        buf.deleteCharAt(i);
                        continue;
                    }
                    followedByQuote = true;
                    continue;
                }
                followedByQuote = false;
            }
        }
        if (buf.charAt(0) == '\'' && buf.charAt(buf.length() - 1) == '\'') {
            buf.deleteCharAt(buf.length() - 1);
            buf.deleteCharAt(0);
        }
        for (int i = buf.length() - 1; i >= 0; --i) {
            char thisChar = buf.charAt(i);
            if (thisChar != '\'') continue;
            buf.insert(i, '\'');
        }
        return buf.toString();
    }
}

