/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSConnection;
import com.ibm.as400.access.PSController;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.PxAcceptRepSV;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxRejectRepSV;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Verbose;
import java.util.Vector;

class PxConnectReqSV
extends PxReqSV {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String PROXY_CONNECTION_ACCEPTED_ = ResourceBundleLoader.getText("PROXY_CONNECTION_ACCEPTED");
    private static final String PROXY_CONNECTION_REDIRECTED_ = ResourceBundleLoader.getText("PROXY_CONNECTION_REDIRECTED");
    private static final String PROXY_CONNECTION_REJECTED_ = ResourceBundleLoader.getText("PROXY_CONNECTION_REJECTED");
    private PSController controller_;
    private PSLoad load_;
    private PSLoadBalancer loadBalancer_;
    private Vector threadGroup_;

    public PxConnectReqSV(Vector threadGroup, PSController controller, PSLoad load, PSLoadBalancer loadBalancer) {
        super((short)11010);
        this.controller_ = controller;
        this.load_ = load;
        this.loadBalancer_ = loadBalancer;
        this.threadGroup_ = threadGroup;
    }

    public PxRepSV process() {
        PxRepSV reply;
        String modification = ((PxStringParm)this.getParm(0)).getStringValue();
        int rejectionCount = ((PxIntParm)this.getParm(1)).getIntValue();
        String clientLocale = ((PxStringParm)this.getParm(2)).getStringValue();
        String peer = this.loadBalancer_.accept(rejectionCount);
        if (peer == null) {
            reply = new PxAcceptRepSV();
            PSConnection connection = new PSConnection(this.controller_.getConnectionId(), this.controller_.getConnectedSocket(), this.controller_.getInputStream(), this.controller_.getOutputStream(), this.load_);
            connection.start();
            this.threadGroup_.addElement(connection);
            Verbose.println(ResourceBundleLoader.substitute(PROXY_CONNECTION_ACCEPTED_, new Object[]{this.controller_, this.controller_.getClientAddress(), Long.toString(this.controller_.getConnectionId())}));
        } else {
            reply = new PxRejectRepSV(peer);
            if (peer.length() == 0) {
                Verbose.println(ResourceBundleLoader.substitute(PROXY_CONNECTION_REJECTED_, this.controller_, this.controller_.getClientAddress()));
            } else {
                Verbose.println(ResourceBundleLoader.substitute(PROXY_CONNECTION_REDIRECTED_, new Object[]{this.controller_, this.controller_.getClientAddress(), peer}));
            }
        }
        return reply;
    }
}

