/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class RCCallProgramReplyDataStream
extends ClientAccessDataStream {
    RCCallProgramReplyDataStream() {
    }

    public Object getNewDataStream() {
        return new RCCallProgramReplyDataStream();
    }

    public int hashCode() {
        return 32771;
    }

    int getRC() {
        return this.get16bit(20);
    }

    AS400Message[] getMessageList(ConverterImplRemote converter) throws IOException {
        return RemoteCommandImplRemote.parseMessages(this.data_, converter);
    }

    void getParameterList(ProgramParameter[] parameterList) {
        int index = 24;
        for (int i = 0; i < parameterList.length; ++i) {
            byte[] outputData;
            if (parameterList[i].getOutputDataLength() <= 0) continue;
            int byteLength = BinaryConverter.byteArrayToInt(this.data_, index);
            int parameterUsage = BinaryConverter.byteArrayToUnsignedShort(this.data_, index + 10);
            int outputDataLength = BinaryConverter.byteArrayToInt(this.data_, index + 6);
            if (parameterUsage == 22 || parameterUsage == 23) {
                outputData = DataStreamCompression.decompressRLE(this.data_, index + 12, byteLength - 12, outputDataLength, (byte)27);
            } else {
                outputData = new byte[outputDataLength];
                System.arraycopy(this.data_, index + 12, outputData, 0, byteLength - 12);
            }
            parameterList[i].setOutputData(outputData);
            index += byteLength;
        }
    }

    protected int readAfterHeader(InputStream in) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving call program reply...");
        }
        return super.readAfterHeader(in);
    }
}

