/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;

class RetryInputStream
extends FilterInputStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int exceptionThreshold_ = 3;

    public RetryInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int exceptionCount = 0;
        while (true) {
            try {
                return super.read();
            }
            catch (SocketException e) {
                if (!Trace.isTraceOn()) continue;
                Trace.log(2, "Socket closed prematurely, let's try again", (Throwable)e);
                if (++exceptionCount < 3) continue;
                throw e;
            }
            break;
        }
    }

    public int read(byte[] b) throws IOException {
        int exceptionCount = 0;
        while (true) {
            try {
                return super.read(b);
            }
            catch (SocketException e) {
                if (!Trace.isTraceOn()) continue;
                Trace.log(2, "Socket closed prematurely, let's try again", (Throwable)e);
                if (++exceptionCount < 3) continue;
                throw e;
            }
            break;
        }
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int exceptionCount = 0;
        while (true) {
            try {
                return super.read(b, offset, length);
            }
            catch (SocketException e) {
                if (!Trace.isTraceOn()) continue;
                Trace.log(2, "Socket closed prematurely, let's try again", (Throwable)e);
                if (++exceptionCount < 3) continue;
                throw e;
            }
            break;
        }
    }
}

