/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5219Writer;
import com.ibm.as400.access.SCSFontData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS3812Writer
extends SCS5219Writer {
    static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int DUPLEX_DUPLEX = 2;
    public static final int DUPLEX_SIMPLEX = 1;
    public static final int DUPLEX_TUMBLE = 3;
    public static final int FONT_COURIER_10 = 0;
    public static final int FONT_COURIER_12 = 1;
    public static final int FONT_COURIER_15 = 2;
    public static final int FONT_COURIER_17 = 3;
    public static final int FONT_COURIER_5 = 4;
    public static final int FONT_COURIER_BOLD_10 = 5;
    public static final int FONT_COURIER_BOLD_17 = 6;
    public static final int FONT_COURIER_BOLD_5 = 7;
    public static final int FONT_COURIER_ITALIC_10 = 8;
    public static final int FONT_COURIER_ITALIC_12 = 9;
    public static final int FONT_GOTHIC_10 = 10;
    public static final int FONT_GOTHIC_12 = 11;
    public static final int FONT_GOTHIC_13 = 12;
    public static final int FONT_GOTHIC_15 = 13;
    public static final int FONT_GOTHIC_20 = 14;
    public static final int FONT_GOTHIC_27 = 15;
    public static final int FONT_GOTHIC_BOLD_10 = 16;
    public static final int FONT_GOTHIC_BOLD_12 = 17;
    public static final int FONT_GOTHIC_ITALIC_12 = 18;
    public static final int FONT_LETTER_GOTHIC_12 = 19;
    public static final int FONT_LETTER_GOTHIC_BOLD_12 = 20;
    public static final int FONT_OCR_A_10 = 21;
    public static final int FONT_OCR_B_10 = 22;
    public static final int FONT_ORATOR_10 = 23;
    public static final int FONT_ORATOR_BOLD_10 = 24;
    public static final int FONT_PRESTIGE_10 = 25;
    public static final int FONT_PRESTIGE_12 = 26;
    public static final int FONT_PRESTIGE_15 = 27;
    public static final int FONT_PRESTIGE_BOLD_12 = 28;
    public static final int FONT_PRESTIGE_ITALIC_12 = 29;
    public static final int FONT_ROMAN_10 = 30;
    public static final int FONT_SCRIPT_12 = 31;
    public static final int FONT_SERIF_10 = 32;
    public static final int FONT_SERIF_12 = 33;
    public static final int FONT_SERIF_15 = 34;
    public static final int FONT_SERIF_BOLD_12 = 35;
    public static final int FONT_SERIF_ITALIC_10 = 36;
    public static final int FONT_SERIF_ITALIC_12 = 37;
    private static final byte[] SCG = new byte[]{43, -47, 6, 1, 0, 0, 0, 0};
    private static final byte[] SFID = new byte[]{43, -47, 7, 5, 0, 0, 0, 0, 1};
    private static final byte[] STO = new byte[]{43, -45, 6, -10, 0, 0, 0, 0};
    private static final byte[] BES = new byte[]{43, -47, 3, -118, 0};
    private static final byte[] EES = new byte[]{43, -47, 3, -114, 0};
    private byte[] orientation_ = new byte[]{-1, -1};
    private int font_ = 0;
    private boolean bold_ = false;

    public SCS3812Writer(OutputStream out) {
        super(out);
    }

    public SCS3812Writer(OutputStream out, int ccsid) throws UnsupportedEncodingException {
        super(out, ccsid);
    }

    public SCS3812Writer(OutputStream out, int ccsid, AS400 system) throws UnsupportedEncodingException {
        super(out, ccsid, system);
    }

    public SCS3812Writer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
    }

    public void endPage() throws IOException {
        if (this.bold_) {
            this.addToBuffer(EES);
        }
        super.endPage();
    }

    void initPage() throws IOException {
        super.initPage();
        this.setBold(this.bold_);
        this.sendSTO();
        if (!this.fontOrCPI) {
            this.setFont(this.font_);
        }
    }

    private void sendSTO() throws IOException {
        byte[] cmd = STO;
        cmd[6] = this.orientation_[0];
        cmd[7] = this.orientation_[1];
        this.addToBuffer(cmd);
    }

    public void setBold(boolean bold) throws IOException {
        this.bold_ = bold;
        if (this.pageStarted_) {
            if (this.bold_) {
                this.addToBuffer(BES);
            } else {
                this.addToBuffer(EES);
            }
        }
    }

    public void setDuplex(int duplex) {
        switch (duplex) {
            case 1: 
            case 2: 
            case 3: {
                this.plex_ = (byte)duplex;
                break;
            }
            default: {
                String arg = "Duplex (" + String.valueOf(duplex) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
    }

    public void setFont(int font) throws IOException {
        byte[] cmd = SFID;
        int[] fontIDs = SCSFontData.fontIDs;
        if (font < 0 || font > fontIDs.length) {
            String arg = "Font (" + String.valueOf(font) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.font_ = font;
        this.fontOrCPI = false;
        if (!this.pageStarted_) {
            this.initPage();
        }
        int fgid = SCSFontData.fontIDs[font];
        int width = SCSFontData.fontWidths[font];
        cmd[4] = (byte)(fgid >> 8);
        cmd[5] = (byte)fgid;
        cmd[6] = (byte)(width >> 8);
        cmd[7] = (byte)width;
        this.addToBuffer(cmd);
    }

    public void setTextOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                this.orientation_[0] = 0;
                this.orientation_[1] = 0;
                break;
            }
            case 90: {
                this.orientation_[0] = 45;
                this.orientation_[1] = 0;
                break;
            }
            case 180: {
                this.orientation_[0] = 90;
                this.orientation_[1] = 0;
                break;
            }
            case 270: {
                this.orientation_[0] = -121;
                this.orientation_[1] = 0;
                break;
            }
            default: {
                String arg = "Orientation (" + String.valueOf(orientation) + ")";
                throw new ExtendedIllegalArgumentException(arg, 2);
            }
        }
    }
}

